/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.SwkTableModel;
import com.onemoonscientific.swank.chart.XYData;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.data.DomainOrder;
import org.jfree.data.xy.TableXYDataset;

public class XYTableGroupData
extends XYData
implements TableXYDataset {
    int xColumn = -1;
    int gColumn = -1;
    int yColumn = -1;
    SwkTableModel tableModel = null;
    Map seriesMap = new TreeMap();
    List seriesNames = new ArrayList();
    List seriesLists = new ArrayList();

    public XYTableGroupData() {
        this.name = "xyData" + id;
        datasetMap.put(this.name, this);
        ++id;
    }

    public XYTableGroupData(String name) {
        this.name = name;
        datasetMap.put(name, this);
    }

    public void setTableModel(SwkTableModel model) {
        if (EventQueue.isDispatchThread()) {
            this.setTableModelOnEventThread(model);
        } else {
            new SetModel().exec(model);
        }
    }

    public void setTableModelOnEventThread(SwkTableModel model) {
        this.tableModel = model;
        this.xColumn = -1;
        this.gColumn = -1;
        this.yColumn = -1;
    }

    public void setXColumn(int column) {
        this.xColumn = column;
    }

    public void setGColumn(int column) {
        this.gColumn = column;
    }

    public void setYColumn(int column) {
        this.yColumn = column;
    }

    public void getSeries() {
        this.seriesMap.clear();
        this.seriesLists.clear();
        this.seriesNames.clear();
        int nRows = this.tableModel.getNRows();
        int nSeries = 0;
        for (int i = 0; i < nRows; ++i) {
            Object gObject = this.tableModel.getValueAt(i, this.gColumn);
            Integer seriesIndex = (Integer)this.seriesMap.get(gObject);
            ArrayList<Integer> arrayList = null;
            if (seriesIndex == null) {
                this.seriesNames.add(gObject);
                this.seriesMap.put(gObject, nSeries);
                arrayList = new ArrayList<Integer>();
                this.seriesLists.add(arrayList);
                ++nSeries;
            } else {
                int index = seriesIndex;
                arrayList = (ArrayList<Integer>)this.seriesLists.get(index);
            }
            arrayList.add(i);
        }
    }

    public int getTableRow(int series, int index) {
        ArrayList arrayList = (ArrayList)this.seriesLists.get(series);
        Integer rowInt = (Integer)arrayList.get(index);
        return rowInt;
    }

    public int getSeriesCount() {
        return this.seriesLists.size();
    }

    public String getSeriesName(int series) {
        if (series >= 0 && series < this.seriesLists.size()) {
            Object gObject = this.seriesNames.get(series);
            return gObject.toString();
        }
        return null;
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.NONE;
    }

    public int getItemCount(int series) {
        int nRows = 0;
        if (this.tableModel != null) {
            ArrayList arrayList = (ArrayList)this.seriesLists.get(series);
            nRows = arrayList.size();
        }
        return nRows;
    }

    public int getItemCount() {
        int nRows = 0;
        if (this.tableModel != null) {
            nRows = this.tableModel.getNRows();
        }
        return nRows;
    }

    public Comparable getSeriesKey(int series) {
        return this.getSeriesName(series);
    }

    public int indexOf(Comparable seriesKey) {
        int index = -1;
        int nSeries = this.getSeriesCount();
        for (int i = 0; i < nSeries; ++i) {
            if (!this.getSeriesName(i).equals(seriesKey.toString())) continue;
            index = i;
            break;
        }
        return index;
    }

    public double getXValue(int series, int item) {
        int rowIndex = this.getTableRow(series, item);
        double x = 0.0;
        if (this.xColumn < 0 || this.xColumn >= this.tableModel.getNCols()) {
            x = rowIndex;
        } else {
            Object xObject = this.tableModel.getValueAt(rowIndex, this.xColumn);
            if (xObject instanceof Number) {
                x = ((Number)xObject).doubleValue();
            }
        }
        return x;
    }

    public Number getX(int series, int item) {
        Number x = null;
        int rowIndex = this.getTableRow(series, item);
        if (this.xColumn < 0 || this.xColumn >= this.tableModel.getNCols()) {
            x = rowIndex;
        } else {
            Object xObject = this.tableModel.getValueAt(rowIndex, this.xColumn);
            if (xObject instanceof Number) {
                x = (Number)xObject;
            }
        }
        return x;
    }

    public double getYValue(int series, int item) {
        double y = 0.0;
        int rowIndex = this.getTableRow(series, item);
        if (this.yColumn < 0 || this.yColumn >= this.tableModel.getNCols()) {
            y = rowIndex;
        } else {
            Object yObject = this.tableModel.getValueAt(rowIndex, this.yColumn);
            if (yObject instanceof Number) {
                y = ((Number)yObject).doubleValue();
            }
        }
        return y;
    }

    public Number getY(int series, int item) {
        Object yObject;
        Number y = null;
        if (this.yColumn >= 0 && this.yColumn < this.tableModel.getNCols() && (yObject = this.tableModel.getValueAt(item, this.yColumn)) instanceof Number) {
            y = (Number)yObject;
        }
        return y;
    }

    public double getEndYValue(int series, int item) {
        double yValue = this.getYValue(series, item);
        return yValue + this.deltaY / 2.0;
    }

    public Number getEndY(int series, int item) {
        double yValue = this.getEndYValue(series, item);
        return new Double(yValue);
    }

    public double getStartYValue(int series, int item) {
        double yValue = this.getYValue(series, item);
        return yValue - this.deltaY / 2.0;
    }

    public Number getStartY(int series, int item) {
        double yValue = this.getStartYValue(series, item);
        return new Double(yValue);
    }

    public double getEndXValue(int series, int item) {
        double xValue = this.getXValue(series, item);
        return xValue + this.deltaX / 2.0;
    }

    public Number getEndX(int series, int item) {
        double xValue = this.getEndXValue(series, item);
        return new Double(xValue);
    }

    public double getStartXValue(int series, int item) {
        double xValue = this.getXValue(series, item);
        return xValue - this.deltaX / 2.0;
    }

    public Number getStartX(int series, int item) {
        double xValue = this.getStartXValue(series, item);
        return new Double(xValue);
    }

    class SetModel
    extends GetValueOnEventThread {
        SwkTableModel model;

        SetModel() {
        }

        void exec(SwkTableModel model) {
            this.model = model;
            this.execOnThread();
        }

        public void run() {
            XYTableGroupData.this.setTableModelOnEventThread(this.model);
        }
    }
}

