/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.DirectoryContents;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.util.Signal;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

final class Unix {
    static final String INVALID_DESCRIPTOR_MSG = "invalid descriptor";
    static final String UNSUPPORTED_SOCKOPT_MSG = "unsupported socket option";
    static final String DIRLISTING_CLOSED_MSG = "directory listing is closed";
    static final double MILLISECS_PER_SEC = 1000.0;

    private Unix() {
    }

    static void fail(String string, Exception exception) throws FailException {
        assert (string != null) : "null prim";
        assert (exception != null) : "null e";
        String string2 = exception.getMessage();
        Unix.fail(string, string2 != null ? string2 : "");
    }

    static void fail(String string, String string2) throws FailException {
        assert (string != null) : "null prim";
        assert (string2 != null) : "null msg";
        Value value = CurrentContext.CODE_STATE.getCallback("Unix.Unix_error");
        if (value == null) {
            Fail.invalidArgument("Exception Unix.Unix_error not initialized, please link unix.cma");
        } else {
            Value value2 = Value.createBlock(0, value, Value.ZERO, Value.createString(string), Value.createString(string2));
            Fail.raise(value2);
        }
    }

    static Value createInetAddr(InetAddress inetAddress) throws FailException {
        if (inetAddress != null) {
            return Value.createString(inetAddress.getAddress());
        }
        Unix.fail("", "unable to get address");
        return Value.UNIT;
    }

    static Value createSockAddr(InetSocketAddress inetSocketAddress) throws FailException {
        if (inetSocketAddress != null) {
            return Value.createBlock(1, Unix.createInetAddr(inetSocketAddress.getAddress()), Value.createLong(inetSocketAddress.getPort()));
        }
        Unix.fail("", "unable to get socket address");
        return Value.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String emul(String string, String string2, String ... stringArray) throws FailException, FalseExit {
        assert (string != null) : "null prim";
        assert (string2 != null) : "null cmd";
        assert (stringArray != null) : "null args";
        Context context = CurrentContext.CONTEXT;
        if (!context.getParameters().isUnixEmulated()) {
            Fail.invalidArgument("Unix." + string + " not implemented");
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        stringArray2[0] = Unix.lookupPath(string2);
        System.arraycopy(stringArray, 0, stringArray2, 1, n);
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray2);
        processBuilder.directory(context.getFilesState().getPwd());
        processBuilder.redirectErrorStream(true);
        try {
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            int n2 = process.waitFor();
            if (n2 != 0) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = inputStream.read();
            while (true) {
                if (n3 == -1) {
                    return stringBuilder.toString();
                }
                stringBuilder.append((char)n3);
                n3 = inputStream.read();
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(context);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (InterruptedException interruptedException) {
            FalseExit falseExit = FalseExit.createFromContext(context);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
    }

    static String lookupPath(String string) {
        String string2 = System.getenv("PATH");
        if (string.indexOf(File.separatorChar) == -1 && string2 != null) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(File.pathSeparator)) {
                File file = new File(string3, string);
                if (!file.exists() || !file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return string;
    }

    static final class AlarmThread
    extends Thread {
        private static final String PREFIX = "OCaml-Java-AlarmThread-";
        private static final AtomicInteger NEXT_ID = new AtomicInteger();
        private final CodeRunner codeRunner;
        private final Context context;
        private long millis;
        private final long interval;
        private final SignalKind signal;
        private boolean activated;
        private long start;

        AlarmThread(CodeRunner codeRunner, long l, long l2, SignalKind signalKind) {
            super(codeRunner.getContext().getThreadsState().getThreadGroup(), AlarmThread.getNextName());
            assert (codeRunner != null) : "null runner";
            assert (l > 0L) : "val should be > 0";
            assert (l2 >= 0L) : "itv should be >= 0";
            assert (signalKind != null) : "null sgn";
            this.codeRunner = codeRunner;
            this.context = codeRunner.getContext();
            this.millis = l;
            this.interval = l2;
            this.signal = signalKind;
            this.activated = true;
            this.start();
        }

        long getInterval() {
            return this.interval;
        }

        long getValue() {
            return this.millis - (System.currentTimeMillis() - this.start);
        }

        long unactivate() {
            this.activated = false;
            return this.millis - (System.currentTimeMillis() - this.start);
        }

        @Override
        public void run() {
            do {
                this.start = System.currentTimeMillis();
                try {
                    Thread.sleep(this.millis);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if (this.activated) {
                    Channel channel;
                    Signals.enqueueSignal(new Signal(this.signal));
                    try {
                        Signals.processSignal(this.codeRunner);
                    }
                    catch (FalseExit falseExit) {
                        this.context.getSignalsState().setAsyncException(falseExit);
                    }
                    catch (FailException failException) {
                        channel = this.context.getFilesState().getChannel(2);
                        Value value = this.context.getCodeState().getGlobalData();
                        String string = Misc.convertException(failException.getValue(), value);
                        Channel.tryWrite(channel, "Error in signal handler: exception " + string);
                    }
                    catch (FatalError fatalError) {
                        channel = this.context.getFilesState().getChannel(2);
                        Channel.tryWrite(channel, "Error in signal handler: exception " + fatalError.getMessage());
                    }
                    catch (OCamlJavaException oCamlJavaException) {
                        channel = this.context.getFilesState().getChannel(2);
                        Channel.tryWrite(channel, "Error in signal handler: exception " + oCamlJavaException.getMessage());
                    }
                }
                this.millis = this.interval;
            } while (this.millis > 0L);
        }

        private static String getNextName() {
            StringBuilder stringBuilder = new StringBuilder(PREFIX);
            stringBuilder.append(NEXT_ID.getAndIncrement());
            return stringBuilder.toString();
        }
    }

    static final class DirList {
        private int nextIndex;
        private final String[] elems;
        private boolean open;

        DirList(Value value) throws FailException {
            assert (value != null) : "null path";
            this.nextIndex = 0;
            String[] stringArray = null;
            FilesState filesState = CurrentContext.FILES_STATE;
            if (filesState.getFileHook() != null) {
                try {
                    stringArray = DirectoryContents.getAsArray(filesState, value);
                }
                catch (Throwable throwable) {
                    Unix.fail("opendir", "unable to get directory content");
                }
            }
            if (stringArray == null) {
                File file = CurrentContext.FILES_STATE.getRealFile(value);
                stringArray = file.list();
            }
            if (stringArray != null) {
                int n = stringArray.length;
                this.elems = new String[n + 2];
                this.elems[0] = ".";
                this.elems[1] = "..";
                System.arraycopy(stringArray, 0, this.elems, 2, n);
                this.open = true;
            } else {
                Unix.fail("opendir", "unable to get directory content");
                this.elems = null;
                this.open = false;
            }
        }

        String next() throws FailException {
            if (this.open) {
                if (this.nextIndex < this.elems.length) {
                    return this.elems[this.nextIndex++];
                }
                Fail.raiseEndOfFile();
                return null;
            }
            Unix.fail("readdir", Unix.DIRLISTING_CLOSED_MSG);
            return null;
        }

        void rewind() throws FailException {
            if (this.open) {
                this.nextIndex = 0;
            } else {
                Unix.fail("rewinddir", Unix.DIRLISTING_CLOSED_MSG);
            }
        }

        void close() {
            this.open = false;
        }
    }
}

