/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.chart;

import com.onemoonscientific.swank.canvas.CanvasParameter;
import com.onemoonscientific.swank.canvas.FillParameter;
import com.onemoonscientific.swank.canvas.GradientParameter;
import com.onemoonscientific.swank.canvas.TagsParameter;
import com.onemoonscientific.swank.canvas.TransformerParameter;
import com.onemoonscientific.swank.canvas.WidthParameter;
import com.onemoonscientific.swank.chart.DAutoParameter;
import com.onemoonscientific.swank.chart.DCXYToolTipGenerator;
import com.onemoonscientific.swank.chart.DLabelParameter;
import com.onemoonscientific.swank.chart.DMaxParameter;
import com.onemoonscientific.swank.chart.DMinParameter;
import com.onemoonscientific.swank.chart.DatasetParameter;
import com.onemoonscientific.swank.chart.LegendLocParameter;
import com.onemoonscientific.swank.chart.LegendStateParameter;
import com.onemoonscientific.swank.chart.PaintParameter;
import com.onemoonscientific.swank.chart.RAutoParameter;
import com.onemoonscientific.swank.chart.RLabelParameter;
import com.onemoonscientific.swank.chart.RMaxParameter;
import com.onemoonscientific.swank.chart.RMinParameter;
import com.onemoonscientific.swank.chart.SplineParameter;
import com.onemoonscientific.swank.chart.StatisticalXYBarRenderer;
import com.onemoonscientific.swank.chart.XYData;
import com.onemoonscientific.swank.chart.XYPlotShape;
import com.onemoonscientific.swank.chart.XYTableStatsData;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYDataset;

public class XYStatShapeComplete
extends XYPlotShape {
    static CanvasParameter[] parameters = new CanvasParameter[]{new TagsParameter(), new DatasetParameter(), new LegendStateParameter(), new LegendLocParameter(), new PaintParameter(), new SplineParameter(), new DLabelParameter(), new DMinParameter(), new DMaxParameter(), new DAutoParameter(), new RLabelParameter(), new RMinParameter(), new RMaxParameter(), new RAutoParameter(), new TransformerParameter(), new WidthParameter(), new FillParameter(), new GradientParameter()};
    static Map parameterMap = new TreeMap();
    String plotType = "xystatplot";

    public XYStatShapeComplete() {
        this.rect2D = new Rectangle2D.Double();
        this.setRenderer();
        this.plot.setRangeAxis((ValueAxis)new NumberAxis());
        this.plot.setDomainAxis((ValueAxis)new NumberAxis());
        this.setShape(this.rect2D);
        this.setFill(Color.gray);
        this.setWidth(0.95);
    }

    public String getType() {
        return this.plotType;
    }

    public void paintShape(Graphics2D g2) {
        if (this.getFillGradient() != null) {
            this.renderer.setSeriesPaint(0, (Paint)this.getFillGradient());
        } else {
            this.renderer.setSeriesPaint(0, (Paint)this.getFill());
        }
        XYData data = (XYData)this.plot.getDataset();
        data.setDeltaX(this.getWidth());
        super.paintShape(g2);
    }

    public void setRenderer() {
        this.renderer = new StatisticalXYBarRenderer();
        this.plot.setRenderer(this.renderer);
        DCXYToolTipGenerator generator = new DCXYToolTipGenerator("{0} {1} {2} {3}", new DecimalFormat("0.000"), (NumberFormat)new DecimalFormat("0.000"));
        this.renderer.setToolTipGenerator((XYToolTipGenerator)generator);
    }

    public void setDataset(Dataset dataset) {
        if (dataset instanceof XYTableStatsData) {
            this.plot.setDataset((XYDataset)((XYTableStatsData)dataset));
        }
    }

    public CanvasParameter[] getParameters() {
        return parameters;
    }

    public Map getParameterMap() {
        return parameterMap;
    }

    static {
        XYStatShapeComplete.initializeParameters((CanvasParameter[])parameters, (Map)parameterMap);
    }
}

