#
#  Copyright (c) 2005 Advanced Micro Devices, Inc.
#
#  See the file "license.amd" for information on usage and
#  redistribution of this file, and for a DISCLAIMER OF ALL
#   WARRANTIES.
#
#  RCS: @(#) $Id: compileproc.tcl,v 1.34 2006/08/21 21:41:13 mdejong Exp $
#
#

# The compileproc module will parse and compile the contents of a proc.

# Convert a proc declaration to a list of proc arguments.
# This method assumes that the script string is already
# a valid Tcl list.

TJC::command compileproc_script_to_proc_list tjc.CompileprocScriptToProcListCmd
#
#
#
#
#
#
#
#
#

# Split arguments to a proc up into three types.
# The return value is a list of length 3 consisting
# of {NON_DEFAULT_ARGS DEFAULT_ARGS ARGS}. The
# first list is made up of those argumens that
# have no default value. The second list is made
# up of those arguments that have a default value.
# The third list is a single boolean element, it is
# true if the special "args" argument was found as
# the last element.

TJC::command compileproc_args_split tjc.CompileprocArgsSplitCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


# Process proc arguments and emit code to set local variables
# named in the proc argument to the values in the passed in objv.

TJC::command compileproc_args_assign tjc.CompileprocArgsAssignCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to assign a procedure argument to the local variable
# table. Name is the name of the argument to the procedure.
# Index is the integer index from the passed in objv array where
# the value of the argument will be found.

TJC::command compileproc_assign_arg tjc.CompileprocAssignArgCmd
#
#
#
#
#
#
#
#
#

# Emit code to assign a procedure argument with a default value
# to the local variable table. Name is the name of the argument
# to the procedure.
# Index is the integer index from the passed in objv array where
# the value of the argument will be found.

TJC::command compileproc_assign_default_arg tjc.CompileprocAssignDefaultArgCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to assign procedure arguments to a local named "args"
# starting from the given index.

TJC::command compileproc_assign_args_arg tjc.CompileprocAssignArgsArgCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Process proc that has the -compile option set. This method will
# generate a Java class that will just eval the proc body string much
# like the Tcl proc command would.

TJC::command compileproc_nocompile tjc.CompileprocNocompileCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Split class name like foo.bar.OneCmd into package and class
# name parts.

TJC::command compileproc_split_classname tjc.CompileprocSplitClassnameCmd
#
#
#
#
#
#
#

# Invoked by main module to compile a proc into
# Java source code. This method should catch
# errors raised during compilation and print a
# diagnostic "interal error" type of message to
# indicate where something went wrong.
#
# The filename argument is the name of the Tcl
# file that the proc was defined in. It is used
# in error reporting and is returned in the
# result tuple. Can be "".
#
# The proc_tuple argument is a tuple of:
# {PROC_NAME PROC_JAVA_CLASS_NAME PROC_LIST}
#
# PROC_NAME is the plain name of the Tcl proc
# PROC_JAVA_CLASS_NAME is the short name
#     of the Java class.
# PROC_LIST is a list containing the proc declaration.
#     The list length is 4: like {proc p {} {}}

TJC::command compileproc_entry_point tjc.CompileprocEntryPointCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


# Generate TJCExtension class that will be included in the JAR.
# The init method of the TJCExtension class will be invoked
# as a result of running the TJC::package command to load
# a TJC compiled package.

TJC::command compileproc_tjcextension tjc.CompileprocTjcextensionCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


# The functions below are used when compiling a proc body into
# a set of commands, words, and inlined methods.

TJC::command compileproc_init tjc.CompileprocInitCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

TJC::command compileproc_start tjc.CompileprocStartCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return descend command keys for those commands in the first
# level of the proc body. Nested commands or commands inside
# containers are not included in this list.

TJC::command compileproc_keys tjc.CompileprocKeysCmd
#
#

# Return info tuple for each key parsed while processing the keys.
# The order of the key info is the parse order.

TJC::command compileproc_keys_info tjc.CompileprocKeysInfoCmd
#
#
#

# Return a list of command keys that are children of
# the passed in parent key. If no children exist
# then {} is returned.

TJC::command compileproc_key_children tjc.CompileprocKeyChildrenCmd
#
#
#
#
#
#
#
#

# Invoked when a new command is being processed. This method
# will determine if the command is at the toplevel of the
# proc or if it is an embedded command or a contained command
# and save the results accordingly.

TJC::command compileproc_command_start_callback tjc.CompileprocCommandStartCallbackCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked when a command is no longer being processed.

TJC::command compileproc_command_finish_callback tjc.CompileprocCommandFinishCallbackCmd
#
#
#
#
#
#
#
#

# Entry point for all compiled proc variations. This method
# is invoked by compileproc_entry_point and returns a buffer
# containing the generated Java source code.

TJC::command compileproc_compile tjc.CompileprocCompileCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Reset the compiled in constant cache for a given proc.

TJC::command compileproc_constant_cache_init tjc.CompileprocConstantCacheInitCmd
#
#
#
#
#
#
#
#

# Add a constant Tcl string value to the constant cache.

TJC::command compileproc_constant_cache_add tjc.CompileprocConstantCacheAddCmd
#
#
#
#
#
#
#
#
#
#
#
#

# Determine the type for a constant TclObject based on
# what type the string looks like. Note that this
# implementation will determine the type based on
# integer and double ranges that are valid in Java.

TJC::command compileproc_constant_cache_type tjc.CompileprocConstantCacheTypeCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return a class instance scoped reference for the
# given constant Tcl string. Note that a constant
# added to the pool will not actually appear in
# the Java file unless this method is invoked
# for that constant.

# FIXME: Write some tests for string that are the
# same after any backslash and output subst done
# in the emitter layer. Should not have duplicated
# constant strings in the cache.

TJC::command compileproc_constant_cache_get tjc.CompileprocConstantCacheGetCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Generate code to setup constant TclObject instance
# variables. These are used when a constant word
# value in a Tcl proc is used over and over again.

TJC::command compileproc_constant_cache_generate tjc.CompileprocConstantCacheGenerateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# The list of all commands that could be invoked during
# this method is iterated here to create a large switch
# method to update the command cache. Command names
# are resolved into command refrences that are checked
# on a per-instance basis.

TJC::command compileproc_command_cache_init_generate tjc.CompileprocCommandCacheInitGenerateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return a buffer that checks to see if a WrappedCommand ref
# is still valid and returns a Command value (or null).

TJC::command compileproc_command_cache_epoch_check tjc.CompileprocCommandCacheEpochCheckCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# If a cached command is no longer valid, try to update
# the cached value by looking the command up again.
# This method will also check to see if the containing
# command's cmdEpoch was changed and flush all the
# cached symbols in that case.

TJC::command compileproc_command_cache_update tjc.CompileprocCommandCacheUpdateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Given "cmdcache1" return integer cache id "1".

TJC::command compileproc_get_cache_id_from_symbol tjc.CompileprocGetCacheIdFromSymbolCmd
#
#
#
#
#
#

# Emit code to check the command epoch
# for the "this" command that contains other
# cached commands. The this epoch could
# be changed when a command is renamed
# or moved into another namespace. When
# the this command epoch is changed, all
# cached commands inside this command
# should be flushed. This check needs to
# be done before a specific cached command's
# epoch is checked.

TJC::command compileproc_command_cache_this_check tjc.CompileprocCommandCacheThisCheckCmd
#
#
#
#
#
#
#
#
#
#
#

# Lookup a command cache symbol given a command key.
# The order which the commands appear in the proc
# define what order the commands are initialized in.

TJC::command compileproc_command_cache_lookup tjc.CompileprocCommandCacheLookupCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Lookup a cached scalar variable by name. This
# method is used to get a token for a scalar
# variable read or write operation. This method
# assumes that the passed in vname is a constant str.

TJC::command compileproc_variable_cache_lookup tjc.CompileprocVariableCacheLookupCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

TJC::command compileproc_get_variable_cache_id_from_symbol tjc.CompileprocGetVariableCacheIdFromSymbolCmd
#
#
#
#
#
#

# Return 1 if there are cached variables, this method is used
# to detect when cached variable support should be enabled
# in the generated code.

TJC::command compileproc_variable_cache_is_used tjc.CompileprocVariableCacheIsUsedCmd
#
#
#
#
#
#
#
#

# Return the number of compiled local cache vars used in the method.
# This is only valid when compileproc_variable_cache_is_used return 1.

TJC::command compileproc_variable_cache_count tjc.CompileprocVariableCacheCountCmd
#
#

# Return a buffer that declares an array containing
# the name of each compiled local.

TJC::command compileproc_variable_cache_names_array tjc.CompileprocVariableCacheNamesArrayCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if the expr value stack option is enabled
# and expr values will be grabbed and stored on the
# stack instead of being grabbed and released before
# each use.

TJC::command compileproc_expr_value_stack_is_used tjc.CompileprocExprValueStackIsUsedCmd
#
#
#
#
#
#
#
#

# Get an ExprValue ref from the stack. This
# method is invoked during code generation
# when an ExprValue ref is needed. The returned
# ref must be released.

TJC::command compileproc_expr_value_stack_get tjc.CompileprocExprValueStackGetCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

TJC::command compileproc_expr_value_stack_release tjc.CompileprocExprValueStackReleaseCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Create alias from a local to an expr value local.
# This tricky little bit of code is needed so that
# an alias symbol can be released instread of
# the actual expr value symbol on the stack.

TJC::command compileproc_expr_value_stack_alias tjc.CompileprocExprValueStackAliasCmd
#
#
#
#

TJC::command compileproc_expr_value_stack_lookup_alias tjc.CompileprocExprValueStackLookupAliasCmd
#
#

# Return a buffer that declares local ExprValue variables
# and grabs values from the runtime pool.

TJC::command compileproc_expr_value_stack_generate tjc.CompileprocExprValueStackGenerateCmd
#
#
#
#
#
#
#
#
#
#
#

# Return a buffer that releases a local ExprValue
# back into the runtime pool of objects.

TJC::command compileproc_expr_value_stack_release_generate tjc.CompileprocExprValueStackReleaseGenerateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Loop over parsed command keys and determine information
# about each command and its arguments. Scanning the commands
# generates meta-data about the parse trees that is then
# used to generate code with specific optimizations enabled.
# The scan starts with the toplevel keys for a specific proc
# and descends into all the keys that are children of these
# toplevel keys. The scan will also descend into container
# commands if that option is enabled. The keys list indicates
# a "block" of commands, starting with the toplevel keys
# in a proc.

TJC::command compileproc_scan_keys tjc.CompileprocScanKeysCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Scan each command key inside the container command indicated
# by the passed in key. This method is able to handle
# container commands like "while" that use a flat list of keys
# as well as complex commands like "if" that use lists
# containing sublists for each block.

TJC::command compileproc_scan_keys_in_container tjc.CompileprocScanKeysInContainerCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Scan input klists list, each element is a list of keys.
# This method is tricky because a list element can itself
# be a list of keys and this method will need to be
# invoked recursively in that case.

TJC::command compileproc_scan_keys_in_container_sublist tjc.CompileprocScanKeysInContainerSublistCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Returns true if the given dkey is an empty command, meaning
# it has no child keys.

TJC::command compileproc_is_empty_command tjc.CompileprocIsEmptyCommandCmd
#
#
#
#
#
#
#

# Reset child key counter and list of child keys.
# This list is used when iterating over a variable
# or a word that is an argument to a the command
# denoted by the key argument.

TJC::command compileproc_childkey_reset tjc.CompileprocChildkeyResetCmd
#
#
#
#
#

# Return the next child key for the given key and
# increment the child key counter.

TJC::command compileproc_childkey_next tjc.CompileprocChildkeyNextCmd
#
#
#
#
#
#
#
#
#
#
#

TJC::command compileproc_childkey_validate tjc.CompileprocChildkeyValidateCmd
#
#
#
#
#
#
#
#
#
#

# Given a variable subtree and the script it was generated from,
# scan the contents of the variable and return a list that
# describes how to evaluate the variable starting from the
# inner most value and progressing to the outer most one.

TJC::command compileproc_scan_variable tjc.CompileprocScanVariableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Callback invoked while variable elements are being scanned. Variables
# are fully scanned before any code is generated.

TJC::command _compileproc_scan_variable_iterator tjc.CompileprocScanVariableIteratorCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Scan contents of a word subtree and return a formatted
# description of the word elements.

TJC::command compileproc_scan_word tjc.CompileprocScanWordCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

TJC::command _compileproc_scan_word_iterate tjc.CompileprocScanWordIterateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return a tuple of {TYPE PSTR} for an argument.
# The pstr value is a printable string that
# describes the argument. This is commonly used
# to print an argument description inside a comment.

TJC::command compileproc_argument_printable tjc.CompileprocArgumentPrintableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code that will invoke a Tcl method. The descend key for
# the method invocation to be written is passed.

TJC::command compileproc_emit_invoke tjc.CompileprocEmitInvokeCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit call to TJC.invoke() to directly invoke a Tcl
# command via its Command.cmdProc() implementation.
# Pass the descend key for the command to invoke.

TJC::command compileproc_emit_invoke_call tjc.CompileprocEmitInvokeCallCmd
#
#
#
#
#
#
#
#

# Emit code to allocate an array of TclObjects and
# assign command arguments to the array. This
# command will invoke a specific callback to
# emit code that appears after the array has
# been allocated and populated.
#
# key : dkey for command
# starti : integer index of first argument to assign
# endi : integer index of last argument to assign
# tmpsymbol : pass already declared TclObject, {} if none
# force_decl_tmpsymbol : pass true to force declaration of
#     TclObject temp symbol before the try loop. This
#     flag is only used if tmpsymbol is {}.
# callback : command to invoke after array has been populated.
# userdata : user supplied data to pass into callback command

TJC::command compileproc_emit_objv_assignment tjc.CompileprocEmitObjvAssignmentCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit TJC.invoke() for either the runtime lookup case or the
# cached command case. The arraysym is the symbol declared
# as a TclObject[]. The tmpsymbol is a symbol declared as
# as TclObject used to store a tmp result inside the try block,
# it will be {} if no tmpsymbol was declared.

TJC::command compileproc_emit_invoke_call_impl tjc.CompileprocEmitInvokeCallImplCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to evaluate the value of a Tcl command
# argument. This method will return a tuple of
# {TYPE SYMBOL BUFFER}. A constant argument will be
# added to the constant pool by this method. By
# default a TclObject will be declared to contain
# the result. If declare_flag is false then the variable
# declaration will be left up to the caller.

TJC::command compileproc_emit_argument tjc.CompileprocEmitArgumentCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return a tuple {TYPE INFO INSTR CMAP} for the argument
# at the given index.

TJC::command compileproc_get_argument_tuple tjc.CompileprocGetArgumentTupleCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Generate code to determine a variable value at runtime
# and assign the value the the given tmpsymbol. This
# method is the primary entry point for variable evaluation.

TJC::command compileproc_emit_variable tjc.CompileprocEmitVariableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to get the value of a scalar variable and assign
# it to a tmpsymbol of type TclObject. This method
# is used by compileproc_emit_variable for scalars. A local
# variable scalar or a fully qualified global namespace
# qualifier like $::myglobal are both supported. A namespace
# relative scoped qualifier like $child::var can't be
# cached and is not added to the compiled local table.

TJC::command compileproc_emit_scalar_variable_get tjc.CompileprocEmitScalarVariableGetCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to set the value of a scalar variable. This method
# assigns a new value to a scalar variable and returns an
# assignable value of type TclObject. This method is used
# throughout this module to set a scalar variable value. A namespace
# relative scoped qualifier like $child::var can't be
# cached and is not added to the compiled local table.

TJC::command compileproc_emit_scalar_variable_set tjc.CompileprocEmitScalarVariableSetCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to get the value of an array variable and assign
# it to a tmpsymbol of type TclObject. This method is
# used by compileproc_emit_variable for arrays. A local
# variable array or a fully qualified global namespace
# qualifier like $::myglobal(elem) are both supported.
# A namespace relative scoped qualifier like $child::var(elem)
# can't be cached and is not added to the compiled local table.
#
# tmpsymbol : TclObject symbol to assign get result to
# vname : name of variable
# key : array element key
# key_is_string : true if key is a constant literal String.

TJC::command compileproc_emit_array_variable_get tjc.CompileprocEmitArrayVariableGetCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to set the value of an array variable and assign
# the result to a tmpsymbol of type TclObject. This method
# will assign a new value to an array element. This method is used
# throughout this module to set an array variable value.
# A absolute namespace scope array name like "::arr" is supported.
# A namespace relative scoped qualifier like $child::var can't be
# cached and is not added to the compiled local table.
# The key argument is the array key to be looked up, if
# key_is_string is true it will be a literal string.

TJC::command compileproc_emit_array_variable_set tjc.CompileprocEmitArrayVariableSetCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Determine a word value at runtime and emit code
# to assign the value of a TclObject result to
# a local indicated by tmpsymbol. The tmpsymbol
# can't be {} but it can be declared by this
# method if declare_flag is true.
# In the special case where the caller wants
# the evaluation result as a String, the
# string_symbol can be passed.

TJC::command compileproc_emit_word tjc.CompileprocEmitWordCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to either assign a value to or append to tmpsymbol.
# This code will append to a StringBuffer tmpsymbol if the
# append flag is true. By default, a TclObject local variable
# will be declared. If declare_flag is false, then the variable
# will be assigned but it is up to the caller to declare it
# before hand.

TJC::command compileproc_emit_word_element tjc.CompileprocEmitWordElementCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Reset the counter used to generate temp variable names in the scope
# of a command. We don't want to have to deal with any issues related to
# reuse of variable names in different scoped blocks, so number all tmp
# variables in the cmdProc scope.

TJC::command compileproc_tmpvar_reset tjc.CompileprocTmpvarResetCmd
#
#
#

# Return the next temp var name

TJC::command compileproc_tmpvar_next tjc.CompileprocTmpvarNextCmd
#
#
#
#
#

# Return true if the key corresponds to a container command.
# This type of command contains other commands and can be
# inlined so that logic tests and looping can be done in Java.

TJC::command compileproc_is_container_command tjc.CompileprocIsContainerCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the key indicates a container command
# that explicitly resets the interp result after running
# contained commands. The compiler can generate optimized
# code in some cases when it is known that the commands
# inside a block do not need to set the interp result
# because the command will always explicitly reset
# the interp result after running commands in the block.

TJC::command compileproc_is_result_reset_container_command tjc.CompileprocIsResultResetContainerCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the container keys list for a
# given container command is a flat list. Only
# the "catch" and "foreach" commands make use
# of a flat list of container commands.

TJC::command compileproc_is_container_command_keys_flat tjc.CompileprocIsContainerCommandKeysFlatCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if this container command can be inlined.
# Typically, a container command that is staticly
# defined and has the correct number of arguments
# can be inlined. For example, a while loop where
# the body code is contained in a braced string and
# the expr test is in a braced string can be inlined.

TJC::command compileproc_can_inline_container tjc.CompileprocCanInlineContainerCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the command identified by key is
# a break, continue, or return command that can
# be inlined. The break and continue commands
# can be inlined inside a loop context. A return
# command can be inlined in a procedure unless
# it is contained inside a catch block. This
# method is invoked as code is emitted.

TJC::command compileproc_can_inline_control tjc.CompileprocCanInlineControlCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the key corresponds to a built-in Tcl command
# that can be inlined. Container commands are handled elsewhere,
# inlined commands are single commands like "set" that can
# be replaced with optimized code.

TJC::command compileproc_can_inline_command tjc.CompileprocCanInlineCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return code to inline a specific built-in Tcl command.

TJC::command compileproc_emit_inline_command tjc.CompileprocEmitInlineCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoke to emit code for a specific type of container
# command.

TJC::command compileproc_emit_container tjc.CompileprocEmitContainerCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code for an inlined if container.

TJC::command compileproc_emit_container_if tjc.CompileprocEmitContainerIfCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# This method is invoked when a container command that
# has a boolean expr block wants to evaluate the expr
# as a boolean value. A tuple of {tmpsymbol buffer is_constant}
# is returned by this method.

TJC::command compileproc_expr_evaluate_boolean_emit tjc.CompileprocExprEvaluateBooleanEmitCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Evaluate an expression and return the parse tree
# for the expression. This method is used by a
# compile expr command and container commands
# like if and while.

TJC::command compileproc_expr_evaluate tjc.CompileprocExprEvaluateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Map expr argument index to an index into the
# container command list. Every container command
# except the "if" command has a trivial mapping.
# This method returns the name of the command and
# the index into the container command list that
# the expr index would be found at. For the "expr"
# command, the index -1 is returned since there
# is no mapping.

TJC::command compileproc_expr_container_index tjc.CompileprocExprContainerIndexCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked as expr is iterated over.

TJC::command compileproc_expr_evaluate_callback tjc.CompileprocExprEvaluateCallbackCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked to query module file flags and set flags in the compileproc module
# that depend on these flags. This method is invoked dynamically inside
# compileproc_compile after compileproc_init has been invoked so that
# the compileproc module can be tested without depending on other modules.

TJC::command compileproc_query_module_flags tjc.CompileprocQueryModuleFlagsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Generate fake key that we can pass to compileproc_emit_invoke
# so that a named method with a constant argument type will
# be emitted. The argl list is a list of constant strings.
# The inargl list is a list of instrs (original quoted arguments)
# for the key

TJC::command compileproc_generate_key tjc.CompileprocGenerateKeyCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code for an inlined while container.

TJC::command compileproc_emit_container_while tjc.CompileprocEmitContainerWhileCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code for an inlined for container.

TJC::command compileproc_emit_container_for tjc.CompileprocEmitContainerForCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


# Emit code for an inlined catch container.

TJC::command compileproc_emit_container_catch tjc.CompileprocEmitContainerCatchCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# The next two methods are used to close a catch block.
# The first is invoked when no variable is passed to
# the catch command.

TJC::command compileproc_container_catch_handler_novar tjc.CompileprocContainerCatchHandlerNovarCmd
#
#
#
#
#
#
#
#
#
#
#
#
#

TJC::command compileproc_container_catch_handler_var tjc.CompileprocContainerCatchHandlerVarCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return tuple if {IS_CATCH IS_RESULT_USED} for the
# given command key. The IS_CATCH element will be
# true if the command is "catch". The IS_RESULT_USED
# element will be true when a variable name argument
# is passed to the catch command and false otherwise.

TJC::command compileproc_container_catch_with_varname tjc.CompileprocContainerCatchWithVarnameCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code for an inlined foreach container.

TJC::command compileproc_emit_container_foreach tjc.CompileprocEmitContainerForeachCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Start foreach loop. Pass a list of the varlist arguments
# to the foreach command and a list of the evaluated symbols
# that contain list values.

TJC::command compileproc_container_foreach_loop_start tjc.CompileprocContainerForeachLoopStartCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# End foreach loop end logic

TJC::command compileproc_container_foreach_loop_end tjc.CompileprocContainerForeachLoopEndCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code for an inlined switch container. This container
# has two flavors. In the general case, use the switch
# command at runtime to search for a body to execute.
# If the mode is exact matching and each of the patterns
# is a constant string then an optimized search is used.

TJC::command compileproc_emit_container_switch tjc.CompileprocEmitContainerSwitchCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit inlined constant string switch code. This is a faster
# version that is only used when the mode is exact and the
# patterns are all constant strings.

TJC::command compileproc_emit_container_switch_constant tjc.CompileprocEmitContainerSwitchConstantCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Generate code to set a variable to a value and assign
# the result to a tmpsymbol of type TclObject. If no
# result assignment is needed, pass {} as tmpsymbol.
# This method assumes that a variable name is statically
# defined. This method will emit different code for scalar
# vs array variables.

TJC::command compileproc_set_variable tjc.CompileprocSetVariableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Generate code to get a variable value and assign
# the result to the passed in tmpsymbol. This
# method assumes that a variable name is static.
# This method will emit different code for scalar vs
# array variables.

TJC::command compileproc_get_variable tjc.CompileprocGetVariableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Push a controls context. The default controls context is the whole
# procedure. A new context is pushed when a loop is entered or
# a catch command is encountered. The controls context is used
# to determine when a control command like break, continue, and
# return can be inlined. The error command is a control command
# but it is never inlined.

TJC::command compileproc_push_controls_context tjc.CompileprocPushControlsContextCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Pop a controls context off the stack.

TJC::command compileproc_pop_controls_context tjc.CompileprocPopControlsContextCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit an inlined control statement. The control commands
# are break, continue, and return. The error command is
# always raised via a normal command invocation.

TJC::command compileproc_emit_control tjc.CompileprocEmitControlCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit an inlined return command. This is used for
# a return command that has either 0 or 1 arguments.
# A return command that appears inside a catch
# block is not inlined.

TJC::command compileproc_emit_control_return tjc.CompileprocEmitControlReturnCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit a container expr command. Note that other container
# commands that have an expr block will use the command
# compileproc_expr_evaluate_boolean_emit to evaluate an
# expression as a boolean.

TJC::command compileproc_emit_container_expr tjc.CompileprocEmitContainerExprCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# This method is invoked when an expr command wants
# to evaluate an expression string and set the interp
# result to the value of the expression. A buffer
# containing the code to set the interp result is
# returned by this method.

TJC::command compileproc_expr_evaluate_result_emit tjc.CompileprocExprEvaluateResultEmitCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit a unary operator after evaluating a value.
# Return a tuple of {EXPRVALUE BUFFER EV_TYPES}
#
# EXPRVALUE : symbol of type ExprValue
# BUFFER : Buffer that will evaluate EXPRVALUE
# EV_TYPES : List of possible result types
#     Can be {} if types are not known at compile time
#     Can be 1 or more of {int double String}
#     Can be {boolean} for logical unary not operator

TJC::command compileproc_expr_evaluate_emit_unary_operator tjc.CompileprocExprEvaluateEmitUnaryOperatorCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit an inlined unary not operator. This method
# is invoked only when inlined expr operators
# are enabled and the operand has not been
# evaluated as a compile time constant.
# This method will generate an inlined operator
# implementation that depends on the type
# op the operand and will return a tuple of:
#
# {EXPRVALUE BUFFER EV_TYPES}
#
# EXPRVALUE : symbol of type ExprValue
# BUFFER : Buffer that will evaluate EXPRVALUE
# EV_TYPES : Type of operand to unary operator

TJC::command compileproc_expr_evaluate_emit_inlined_unary_not_operator tjc.CompileprocExprEvaluateEmitInlinedUnaryNotOperatorCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit a binary operator after evaluating a left
# and right value.
# Return a tuple of {EXPRVALUE BUFFER EV_TYPES}
#
# EXPRVALUE : symbol of type ExprValue
# BUFFER : Buffer that will evaluate EXPRVALUE
# EV_TYPES : List of possible result types
#     Can be {} if types are not known at compile time
#     Can be 1 or more of {int double String}
#     Can be {boolean} for logical operators

TJC::command compileproc_expr_evaluate_emit_binary_operator tjc.CompileprocExprEvaluateEmitBinaryOperatorCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# FIXME: Cleanup binary operator function by moving logic
# related to emitting of special cases into operator
# specific function. Then, these operator specific
# functions can be invoked on a per-operator basis.

if {0} {

MATH (* / + -) (no strings allowed)

MATH (%) (only int)

BIT (<< >> & ^ |) (only int)

COMPARE (< > <= >=) (any, operands converted)

EQUALS (== != eq ne) (any, eq ne not converted)

LOGIC (&& ||) (no strings, no conversion)

}

# Emit code for the ==, !=, eq, and ne operators.
# These equals operators accept any type.
# The == and != operators will convert operands
# so that the types match. 
# Return a tuple of {EXPRVALUE BUFFER}
# or {} if the default binary operator method
# should be invoked.
#
# EXPRVALUE : symbol of type ExprValue
# BUFFER : Buffer that will evaluate EXPRVALUE

TJC::command compileproc_expr_evaluate_emit_binary_equals_operator tjc.CompileprocExprEvaluateEmitBinaryEqualsOperatorCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code for the || and && operators.
# These operators evaluate operands as
# booleans and can be used for short
# circut logic.
# Return a tuple of {EXPRVALUE BUFFER}
# or {} if the default binary operator method
# should be invoked.
#
# EXPRVALUE : symbol of type ExprValue
# BUFFER : Buffer that will evaluate EXPRVALUE

TJC::command compileproc_expr_evaluate_emit_binary_logic_operator tjc.CompileprocExprEvaluateEmitBinaryLogicOperatorCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit a ternary operator like ($b ? 1 : 0)
# Return a tuple of {EXPRVALUE BUFFER EV_TYPES}
#
# EXPRVALUE : symbol of type ExprValue
# BUFFER : Buffer that will evaluate EXPRVALUE
# EV_TYPES : List of possible result types
#     Can be {} if types are not known at compile time
#     Can be 1 or more of {int double String}
#     Can be {boolean} if both values are boolean values

TJC::command compileproc_expr_evaluate_emit_ternary_operator tjc.CompileprocExprEvaluateEmitTernaryOperatorCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit a math function like pow(2,2).
# Return a tuple of {EXPRVALUE BUFFER EV_TYPES}
#
# EXPRVALUE : symbol of type ExprValue
# BUFFER : Buffer that will evaluate EXPRVALUE
# EV_TYPES : List of possible result types {int double String} or {boolean}

TJC::command compileproc_expr_evaluate_emit_math_function tjc.CompileprocExprEvaluateEmitMathFunctionCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Determine information about an expr operand by peeking
# at the toplevel of a exprvalue tuple. For example,
# the utility can be used to determine if an operand
# is a constant int literal before emitting code.

TJC::command compileproc_expr_peek_operand tjc.CompileprocExprPeekOperandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# This method is invoked to emit code that will evaluate
# an expr value. This evaluation could result in a
# a simple value, evaluation of a subexpression,
# evaluation of nested commands, and so on. Typically,
# the caller will invoke this method and then operate
# on the result symbol of type ExprValue. It is also
# possible to indicate the preferred return value
# by passing flags in the genflags tuple.

# tuple : An expr value tuple
#
# genflags : A tuple containing {KEY VALUE} pairs
#     that control how this method functions and
#     what the evaluation buffer returns. The
#     possible flag values are:
#
#     peek : A boolean value that indicates a peek operation.
#            A peek operation does not generate code,
#            it examines the tuple and returns
#            information about the operand.
#
#     rtype : Indicates the preferred result type. Type can
#             be either ExprValue (the default) or TclObject.
#
#     nostr : Indicates that string value for an ExprValue should
#             not be generated. For example, an int literal 0x1
#             would normally have a value of 1 and a string
#             value of "0x1". If nostr is set then the string
#             value will be null.
#
# Return tuple {INFOSTR SYMBOL BUFFER RESULT_INFO}

TJC::command compileproc_expr_evaluate_emit_exprvalue tjc.CompileprocExprEvaluateEmitExprvalueCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# This method will return a buffer that declares a symbol
# of type ExprValue and allocates an ExprValue object
# initialized to the passed in value. Pass the empty string
# in the value argument to get an uninitialized ExprValue.

# symbol: The ExprValue symbol to be declared
# value_type: Type of next argument, either int, double,
#     boolean, TclObject, String, or "" (for no init)
# value:  A value of type indicated by value_type, or ""
# srep:   String rep of value (can be null), or "".

TJC::command compileproc_emit_exprvalue_get tjc.CompileprocEmitExprvalueGetCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# This method is invoked to generate code that should
# be evaluated when the expr logic is done with an
# ExprValue. If the expr values are being grabbed
# from the stack then the values don't need to be
# released and this method return the empty string.

# symbol: ExprValue symbol that may be released

TJC::command compileproc_emit_exprvalue_release tjc.CompileprocEmitExprvalueReleaseCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the given string can be
# represented as a Java integer type.
# This means it fits into a 32bit int
# type.

TJC::command compileproc_string_is_java_integer tjc.CompileprocStringIsJavaIntegerCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the given string can be
# represented as a Java double type. If
# the string could be an integer then
# this method will return 0.

TJC::command compileproc_string_is_java_double tjc.CompileprocStringIsJavaDoubleCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return a tuple of {MATCHES PARSED PRINTED} that indicates if a
# parsed value exactly matches the string rep of the passed in
# value. The PARSED value is the format of the number used by Tcl.
# The PRINTED value is the preferred output format that a Java
# literal would be printed as. For example, the integer literal
# "100" would exactly match the string rep of "100" so there is
# no reason to save the string rep. The integer literal "0xFF"
# would have a parsed value of "255" so it would not exactly match
# the string rep. In integer cases, the PARSED and PRINTED values
# will be the same. For floating point numbers like "1.0e16", the
# PARSED value would be "1e+016" and the PRINTED value would be "1e16".

TJC::command compileproc_parse_value tjc.CompileprocParseValueCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if append command can be inlined.

TJC::command compileproc_can_inline_command_append tjc.CompileprocCanInlineCommandAppendCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to implement inlined append command. The
# inlined append command would have already been validated
# to have 3 or more arguments and a constant variable
# name or a constant array name with a non-constant key.
# The inlined append command is a bit more tricky than
# other commands because it must emit special code when
# cache variables is enabled.

TJC::command compileproc_emit_inline_command_append tjc.CompileprocEmitInlineCommandAppendCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked to emit code for inlined TJC.appendVar() call
# inside try block.

TJC::command compileproc_emit_append_call_impl tjc.CompileprocEmitAppendCallImplCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if global command can be inlined.

TJC::command compileproc_can_inline_command_global tjc.CompileprocCanInlineCommandGlobalCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to implement inlined global command invocation.

TJC::command compileproc_emit_inline_command_global tjc.CompileprocEmitInlineCommandGlobalCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if incr command can be inlined.

TJC::command compileproc_can_inline_command_incr tjc.CompileprocCanInlineCommandIncrCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to implement inlined incr command invocation. The
# inlined incr command would have already been validated
# to have a constant variable name and 2 or 3 arguments
# when this method is invoked. The inlined incr command
# is a bit more tricky that then other commands because
# it must emit special code when cache variables is
# enabled.

TJC::command compileproc_emit_inline_command_incr tjc.CompileprocEmitInlineCommandIncrCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if lappend command can be inlined.

TJC::command compileproc_can_inline_command_lappend tjc.CompileprocCanInlineCommandLappendCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to implement inlined lappend command. The
# inlined lappend command would have already been validated
# to have 3 arguments and a constant variable name or
# a constant array name with a non-constant key. The inlined
# lappend command is tricky as compared to other commands
# because it needs to emit special code when cached variables
# are enabled.

TJC::command compileproc_emit_inline_command_lappend tjc.CompileprocEmitInlineCommandLappendCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked to emit code for inlined TJC.lappendVar() call
# inside try block. This method is called after all
# of the arguments have been evaluated and have
# been assigned to the array.
#
# key : dkey for command
# arraysym : symbol for TclObject[] array
# tmpsymbol : symbol of type TclObject, can be used inside try/finally blocks
# userdata : user defined data passed to compileproc_emit_objv_assignment

TJC::command compileproc_emit_lappend_call_impl tjc.CompileprocEmitLappendCallImplCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if lindex command can be inlined.

TJC::command compileproc_can_inline_command_lindex tjc.CompileprocCanInlineCommandLindexCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to implement inlined lindex command invocation
# that has 3 arguments.

TJC::command compileproc_emit_inline_command_lindex tjc.CompileprocEmitInlineCommandLindexCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if list command can be inlined.
# The list command accepts 0 to N arguments
# of any type, so it can always be inlined.

TJC::command compileproc_can_inline_command_list tjc.CompileprocCanInlineCommandListCmd
#
#

# Emit code to implement inlined list command invocation.
# This code generates a "pure" Tcl list, that is a list
# without a string rep.

TJC::command compileproc_emit_inline_command_list tjc.CompileprocEmitInlineCommandListCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Evaluate argument append statement and return buffer 

TJC::command compileproc_emit_inline_command_list_argument tjc.CompileprocEmitInlineCommandListArgumentCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if llength command can be inlined.

TJC::command compileproc_can_inline_command_llength tjc.CompileprocCanInlineCommandLlengthCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to implement inlined llength command invocation.

TJC::command compileproc_emit_inline_command_llength tjc.CompileprocEmitInlineCommandLlengthCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if set command can be inlined.

TJC::command compileproc_can_inline_command_set tjc.CompileprocCanInlineCommandSetCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to implement inlined set command invocation. The
# inlined set command would have already been validated
# to have a constant variable name and 2 or 3 arguments
# when this method is invoked.

TJC::command compileproc_emit_inline_command_set tjc.CompileprocEmitInlineCommandSetCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if string command can be inlined.

TJC::command compileproc_can_inline_command_string tjc.CompileprocCanInlineCommandStringCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to implement inlined string command invocation.
# The inlined string command would have already been validated
# at this point.

TJC::command compileproc_emit_inline_command_string tjc.CompileprocEmitInlineCommandStringCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the command argument at the given index
# is a statically defined variable name that can be
# set with inlined code. For example, a scalar varname
# like "s" or an array varname like "a(k)". The tricky
# bit is that this method will also return true for
# a static array name with a non-static array key
# like "a($k)".

TJC::command compileproc_can_inline_variable_access tjc.CompileprocCanInlineVariableAccessCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Emit code to get or set the value of a non-constant array variable
# that has a statically defined array name. The command
# compileproc_can_inline_variable_access returns true for
# these array variables. This methods should not be invoked
# for constant variable names or for non-constant array names.
# This method returns two buffers, the first will get the
# value of the array key. The second method will set the
# value of the array object using the passed in tmpsymbol
# as the array key. The second buffer will result in an
# assignable value of type TclObject.
#
# key : descend key for the command
# index : array variable argument index
# getset : either "get" or "set"
# tmpsymbol : symbol of type TclObject that a get or set result
#     can be assigned to.
# assign_tmpsymbol : defaults to true for a get operation. For
#     a set operation, will assign result of array set to tmpsymbol.
# value : (optional) set variable to value (can be TclObject or String)

TJC::command compileproc_get_set_nonconstant_array_variable tjc.CompileprocGetSetNonconstantArrayVariableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Util method used to evaluate the word elements in a
# non-constant array variable name. This method
# returns a tuple of:
#
# {ARRAYNAME KEYSYM WORD_BUFFER}
#
# ARRAYNAME : array variable name as constant String
# KEYSM : array element key as String symbol
# WORD_BUFFER : code to evaluate KEYSYM

TJC::command compileproc_setup_nonconstant_array_variable tjc.CompileprocSetupNonconstantArrayVariableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true when a setResult() operation can be
# omitted for the given command key.

TJC::command compileproc_omit_set_result tjc.CompileprocOmitSetResultCmd
#
#
#
#
#


