/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.FatalErrorKind;
import org.ocamljava.runtime.values.Value;

final class ReflectionDispatcher
implements Dispatcher {
    private int size;
    private String[] names;
    private Method[] implementations;

    ReflectionDispatcher(String[] nams, Method[] impls) {
        assert (nams != null) : "null nams";
        assert (impls != null) : "null impls";
        assert (nams.length == impls.length) : "nams and impls should have the same length";
        this.size = nams.length;
        this.names = Arrays.copyOf(nams, nams.length);
        this.implementations = Arrays.copyOf(impls, impls.length);
    }

    @Override
    public String[] getNames() {
        return this.names;
    }

    @Override
    public Method[] getMethods() {
        return this.implementations;
    }

    @Override
    public String getName(int prim) {
        if (prim >= 0 && prim < this.size) {
            return this.names[prim];
        }
        return null;
    }

    @Override
    public Method getMethod(int prim) {
        if (prim >= 0 && prim < this.size) {
            return this.implementations[prim];
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Value invoke(int prim, Value[] params) throws FatalError, FailException, FalseExit {
        assert (params != null) : "null params";
        if (prim >= 0 && prim < this.size) {
            try {
                return (Value)this.implementations[prim].invoke(null, (Object[])params);
            }
            catch (IllegalAccessException iae) {
                Fatal.raise(FatalErrorKind.PRIMITIVE_ILLEGAL_ACCESS, this.getName(prim));
                return null;
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                if (cause instanceof FailException) {
                    throw (FailException)cause;
                }
                if (cause instanceof FatalError) {
                    throw (FatalError)cause;
                }
                if (cause instanceof FalseExit) {
                    throw (FalseExit)cause;
                }
                t.printStackTrace();
                StringWriter sw = new StringWriter();
                sw.append(this.getName(prim));
                sw.append(":\n");
                if (cause != null) {
                    cause.printStackTrace(new PrintWriter(sw));
                }
                Fatal.raise(FatalErrorKind.PRIMITIVE_ERROR, sw.toString());
                return null;
            }
        }
        Fatal.raise(FatalErrorKind.UNDEFINED_PRIMITIVE, Integer.toString(prim));
        return null;
    }

    @Override
    public Value invoke(int prim, Value p0) throws FatalError, FailException, FalseExit {
        assert (p0 != null) : "null p0";
        return this.invoke(prim, new Value[]{p0});
    }

    @Override
    public Value invoke(int prim, Value p0, Value p1) throws FatalError, FailException, FalseExit {
        assert (p0 != null) : "null p0";
        assert (p1 != null) : "null p1";
        return this.invoke(prim, new Value[]{p0, p1});
    }

    @Override
    public Value invoke(int prim, Value p0, Value p1, Value p2) throws FatalError, FailException, FalseExit {
        assert (p0 != null) : "null p0";
        assert (p1 != null) : "null p1";
        assert (p2 != null) : "null p2";
        return this.invoke(prim, new Value[]{p0, p1, p2});
    }

    @Override
    public Value invoke(int prim, Value p0, Value p1, Value p2, Value p3) throws FatalError, FailException, FalseExit {
        assert (p0 != null) : "null p0";
        assert (p1 != null) : "null p1";
        assert (p2 != null) : "null p2";
        assert (p3 != null) : "null p3";
        return this.invoke(prim, new Value[]{p0, p1, p2, p3});
    }

    @Override
    public Value invoke(int prim, Value p0, Value p1, Value p2, Value p3, Value p4) throws FatalError, FailException, FalseExit {
        assert (p0 != null) : "null p0";
        assert (p1 != null) : "null p1";
        assert (p2 != null) : "null p2";
        assert (p3 != null) : "null p3";
        assert (p4 != null) : "null p4";
        return this.invoke(prim, new Value[]{p0, p1, p2, p3, p4});
    }

    @Override
    public int addPrimitive(String name, Method impl) {
        assert (name != null) : "null name";
        assert (impl != null) : "null impl";
        int oldSize = this.size++;
        Method[] impls = new Method[this.size];
        System.arraycopy(this.implementations, 0, impls, 0, oldSize);
        impls[oldSize] = impl;
        this.implementations = impls;
        String[] nams = new String[this.size];
        System.arraycopy(this.names, 0, nams, 0, oldSize);
        nams[oldSize] = name;
        this.names = nams;
        return oldSize;
    }
}

