(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

(** Printing of jar graph. *)

BARISTA_ERROR =
  | Cannot_process_archive of UTF8.t

val print_to_buffer : UTF8Buffer.t -> Graph.format -> UTF8.t list -> unit
(** [print_to_stream buff cl fmt l] appends to the passed buffer [buff]
    the graph of the classes appearing in archives from [l], using [fmt]
    as the output format, and [cl] as the classloader.

    Raises [Exception] is an archive cannot be opened. *)

val print_to_stream : OutputStream.t -> Graph.format -> UTF8.t list -> unit
(** [print_to_stream st cl fmt l] prints onto the passed stream the
    graph of the classes appearing in archives from [l], using [fmt] as
    the output format, and [cl] as the classloader.

    Raises [Exception] is an archive cannot be opened. *)

val print : Graph.format -> UTF8.t list -> unit
(** [print fmt l] prints onto the standard output the graph of the
    classes appearing in archives from [l], using [fmt] as the output
    format, and [cl] as the classloader.

    Raises [Exception] is an archive cannot be opened. *)
