(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

IFNDEF USE_JDK THEN

type t = string

let empty = ""

let make_of_size sz =
  if sz < 0 then
    raise (Invalid_argument "BaristaLibrary.Bytes.make_of_size");
  String.create sz

let make_of_string str =
  String.copy str

let length bytes =
  String.length bytes

let as_string bytes =
  String.copy bytes

let to_string bytes =
  String.copy bytes

ELSE (* USE_JDK *)

let (|>) x f = f x

type t = int JavaByteArray.t

external byte_array_of_string : string -> int JavaByteArray.t =
  "byte_array_of_string"

external string_of_byte_array : int JavaByteArray.t -> string =
  "string_of_byte_array"

let empty = Java.make_array "byte[]" 0l

let make_of_size sz =
  if sz < 0 then
    raise (Invalid_argument "BaristaLibrary.Bytes.make_of_size");
  sz
  |> Int32.of_int
  |> Java.make_array "byte[]"

let make_of_string str =
  str
  |> byte_array_of_string

let length bytes =
  bytes
  |> JavaByteArray.length
  |> Int32.to_int

let as_string bytes =
  bytes
  |> string_of_byte_array

let to_string bytes =
  bytes
  |> Java.call "java.util.Arrays.toString(byte[])"
  |> JavaString.to_string

END
