/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/strofaddr.c")
public final class Strofaddr {
    private Strofaddr() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.inet_addr"}, returnType="string")
    public static Value unix_string_of_inet_addr(Value value) throws FailException {
        try {
            InetAddress inetAddress = InetAddress.getByAddress(value.getBytes());
            return Value.createString(inetAddress.getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            Unix.fail("string_of_inet_addr", unknownHostException);
            return Value.UNIT;
        }
    }
}

