/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.io.File;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.context.DebuggerState;
import org.ocamljava.runtime.context.FilesState;
import org.ocamljava.runtime.context.FinalizersState;
import org.ocamljava.runtime.context.GCState;
import org.ocamljava.runtime.context.PredefinedExceptions;
import org.ocamljava.runtime.context.SignalsState;
import org.ocamljava.runtime.context.ThreadsState;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.parameters.CommonParameters;

public abstract class Context {
    private final boolean backtraceRequest;
    private final CommonParameters parameters;
    private final CodeState codeState;
    private final ThreadsState threadsState;
    private final FilesState filesState;
    private final GCState gcState;
    private final FinalizersState finalizersState;
    private final DebuggerState debuggerState;
    private final SignalsState signalsState;
    private PredefinedExceptions predefinedExceptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Context(CommonParameters commonParameters, boolean bl, File file) {
        assert (commonParameters != null) : "null p";
        assert (file != null) : "null dir";
        this.backtraceRequest = commonParameters.isBacktraceRequested();
        this.parameters = commonParameters;
        this.codeState = new CodeState(this, commonParameters, bl);
        this.threadsState = new ThreadsState(bl);
        this.filesState = new FilesState(commonParameters, file);
        this.gcState = new GCState();
        this.finalizersState = new FinalizersState(this);
        this.debuggerState = new DebuggerState();
        this.signalsState = new SignalsState(this);
        this.predefinedExceptions = bl ? new PredefinedExceptions() : null;
        Class<CurrentContext> clazz = CurrentContext.class;
        synchronized (CurrentContext.class) {
            CurrentContext.CONTEXT = this;
            CurrentContext.PARAMETERS = this.parameters;
            CurrentContext.CODE_STATE = this.codeState;
            CurrentContext.THREADS_STATE = this.threadsState;
            CurrentContext.FILES_STATE = this.filesState;
            CurrentContext.GC_STATE = this.gcState;
            CurrentContext.FINALIZERS_STATE = this.finalizersState;
            CurrentContext.DEBUGGER_STATE = this.debuggerState;
            CurrentContext.SIGNALS_STATE = this.signalsState;
            CurrentContext.PREDEFINED_EXCEPTIONS = this.predefinedExceptions;
            CurrentContext.BACKTRACE_REQUESTED = this.backtraceRequest;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public final boolean isBacktraceRequested() {
        return this.backtraceRequest;
    }

    public final CommonParameters getParameters() {
        return this.parameters;
    }

    public abstract void enterBlockingSection();

    public abstract void leaveBlockingSection() throws FalseExit, FailException;

    public abstract boolean tryLeaveBlockingSection();

    public abstract boolean isRuntimeBusy();

    public final CodeState getCodeState() {
        return this.codeState;
    }

    public final ThreadsState getThreadsState() {
        return this.threadsState;
    }

    public final FilesState getFilesState() {
        return this.filesState;
    }

    public final GCState getGCState() {
        return this.gcState;
    }

    public final FinalizersState getFinalizersState() {
        return this.finalizersState;
    }

    public final DebuggerState getDebuggerState() {
        return this.debuggerState;
    }

    public final SignalsState getSignalsState() {
        return this.signalsState;
    }

    public final PredefinedExceptions getPredefinedExceptions() {
        return this.predefinedExceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPredefinedExceptions(PredefinedExceptions predefinedExceptions) {
        this.predefinedExceptions = predefinedExceptions;
        Class<CurrentContext> clazz = CurrentContext.class;
        synchronized (CurrentContext.class) {
            CurrentContext.PREDEFINED_EXCEPTIONS = predefinedExceptions;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

