/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.GetValueOnEventThread;
import com.onemoonscientific.swank.ResourceObject;
import com.onemoonscientific.swank.Result;
import com.onemoonscientific.swank.SwkJTextField;
import com.onemoonscientific.swank.UpdateOnEventThread;
import com.onemoonscientific.swank.Widgets;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

class SwkJTextFieldWidgetCmd
implements Command {
    private static final String[] validCmds = new String[]{"cget", "configure", "delete", "get", "index", "insert", "scan", "selection", "xview"};
    private static final int OPT_CGET = 0;
    private static final int OPT_CONFIGURE = 1;
    private static final int OPT_DELETE = 2;
    private static final int OPT_GET = 3;
    private static final int OPT_INDEX = 4;
    private static final int OPT_INSERT = 5;
    private static final int OPT_SCAN = 6;
    private static final int OPT_SELECTION = 7;
    private static final int OPT_XVIEW = 8;
    static boolean gotDefaults = false;
    int index;
    Interp interp = null;

    SwkJTextFieldWidgetCmd() {
    }

    public static String[] getValidCmds() {
        return validCmds;
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        this.interp = interp;
        int opt = TclIndex.get(interp, argv[1], validCmds, "option", 0);
        TclObject tObj = (TclObject)Widgets.getWidget(interp, argv[0].toString());
        if (tObj == null) {
            throw new TclException(interp, "bad window path name \"" + argv[0].toString() + "\"");
        }
        final SwkJTextField swkjtextfield = (SwkJTextField)ReflectObject.get((Interp)interp, (TclObject)tObj);
        switch (opt) {
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "option");
                }
                interp.setResult(swkjtextfield.jget(interp, argv[2]));
                break;
            }
            case 1: {
                if (!gotDefaults) {
                    swkjtextfield.setResourceDefaults();
                    gotDefaults = true;
                }
                if (argv.length == 2) {
                    swkjtextfield.jgetAll(interp);
                    break;
                }
                if (argv.length == 3) {
                    String result = swkjtextfield.jget(interp, argv[2]);
                    ResourceObject ro = (ResourceObject)SwkJTextField.resourceDB.get(argv[2].toString());
                    if (ro == null) {
                        throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\"");
                    }
                    TclObject list = TclList.newInstance();
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)argv[2].toString()));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.resource));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.className));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)ro.defaultVal));
                    TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)result));
                    interp.setResult(list);
                    break;
                }
                swkjtextfield.configure(interp, argv, 2);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                interp.setResult(swkjtextfield.getText());
                break;
            }
            case 4: {
                this.getIndex(interp, swkjtextfield, argv, 0);
                break;
            }
            case 5: {
                this.insert(interp, swkjtextfield, argv);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                if (argv.length == 2) {
                    new ViewValues().exec(swkjtextfield);
                    break;
                }
                if (argv.length == 3) {
                    this.index = this.getIndex2(interp, swkjtextfield, argv, -1);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BoundedRangeModel brm = swkjtextfield.getHorizontalVisibility();
                            int maxSize = swkjtextfield.getText().length();
                            double fx1 = 1.0 * (double)SwkJTextFieldWidgetCmd.this.index / (double)maxSize;
                            if (fx1 < 0.0) {
                                fx1 = 0.0;
                            }
                            int x = (int)(fx1 * (double)(brm.getMaximum() - brm.getMinimum()) + (double)brm.getMinimum());
                            swkjtextfield.setScrollOffset(x);
                        }
                    });
                    break;
                }
                if (argv[2].toString().equals("moveto")) {
                    if (argv.length != 4) {
                        throw new TclNumArgsException(interp, 2, argv, "option ?arg arg ...?");
                    }
                    final double fx1 = TclDouble.get((Interp)interp, (TclObject)argv[3]);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BoundedRangeModel brm = swkjtextfield.getHorizontalVisibility();
                            double fx = fx1;
                            if (fx1 < 0.0) {
                                fx = 0.0;
                            }
                            int x = (int)(fx * (double)(brm.getMaximum() - brm.getMinimum()) + (double)brm.getMinimum());
                            swkjtextfield.setScrollOffset(x);
                        }
                    });
                    break;
                }
                if (argv[2].toString().equals("scroll")) {
                    if (argv.length != 5) {
                        throw new TclNumArgsException(interp, 2, argv, "option ?arg arg ...?");
                    }
                    if (argv[4].toString().equals("units")) {
                        final int units = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                int x = swkjtextfield.getScrollOffset();
                                swkjtextfield.setScrollOffset(x + units);
                            }
                        });
                        break;
                    }
                    if (!argv[4].toString().equals("pages")) break;
                    final int units = TclInteger.get((Interp)interp, (TclObject)argv[3]);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            int x = swkjtextfield.getScrollOffset();
                            swkjtextfield.setScrollOffset(x + units);
                        }
                    });
                    break;
                }
                throw new TclException(interp, "unknown option \"" + argv[2].toString() + "\": must be moveto or scroll");
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }

    int getIndex2(Interp interp, SwkJTextField swkjtextfield, TclObject[] argv, int offset) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        int index = new Index().exec(swkjtextfield, argv[2].toString(), offset);
        return index;
    }

    void getIndex(Interp interp, SwkJTextField swkjtextfield, TclObject[] argv, int offset) throws TclException {
        if (argv.length != 3) {
            throw new TclNumArgsException(interp, 2, argv, "index");
        }
        int index = new Index().exec(swkjtextfield, argv[2].toString(), offset);
        interp.setResult(index);
    }

    void insert(Interp interp, SwkJTextField swkjtextfield, TclObject[] argv) throws TclException {
        if (argv.length != 4) {
            throw new TclNumArgsException(interp, 2, argv, "option");
        }
        new Insert().exec(swkjtextfield, argv[2].toString(), argv[3].toString());
    }

    class ViewValues
    extends GetValueOnEventThread {
        SwkJTextField swkjtextfield = null;
        double fx1 = 0.0;
        double fx2 = 0.0;

        ViewValues() {
        }

        void exec(SwkJTextField swkjtextfield) throws TclException {
            this.swkjtextfield = swkjtextfield;
            this.execOnThread();
            TclObject list = TclList.newInstance();
            TclList.append((Interp)SwkJTextFieldWidgetCmd.this.interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)this.fx1));
            TclList.append((Interp)SwkJTextFieldWidgetCmd.this.interp, (TclObject)list, (TclObject)TclDouble.newInstance((double)this.fx2));
            SwkJTextFieldWidgetCmd.this.interp.setResult(list);
        }

        public void run() {
            BoundedRangeModel brm = this.swkjtextfield.getHorizontalVisibility();
            this.fx1 = 1.0 * (double)brm.getValue() / (double)(brm.getMaximum() - brm.getMinimum());
            this.fx2 = 1.0 * (double)(brm.getValue() + brm.getExtent()) / (double)(brm.getMaximum() - brm.getMinimum());
        }
    }

    class Insert
    extends UpdateOnEventThread {
        SwkJTextField swkjtextfield = null;
        String strIndex = null;
        String text = null;
        String errMessage = null;

        Insert() {
        }

        void exec(SwkJTextField swkjtextfield, String strIndex, String text) throws TclException {
            this.strIndex = strIndex;
            this.text = text;
            this.swkjtextfield = swkjtextfield;
            this.execOnThread();
        }

        public void run() {
            Result result = new Result();
            this.swkjtextfield.getIndex(this.strIndex, 0, result);
            if (!result.hasError()) {
                try {
                    this.swkjtextfield.getDocument().insertString(result.i, this.text, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    class Index
    extends GetValueOnEventThread {
        SwkJTextField swkjtextfield = null;
        String item = null;
        int index = 0;
        int endVal = 0;
        String errMessage = null;

        Index() {
        }

        int exec(SwkJTextField swkjtextfield, String item, int endVal) throws TclException {
            this.item = item;
            this.endVal = endVal;
            this.swkjtextfield = swkjtextfield;
            this.execOnThread();
            if (this.errMessage != null) {
                throw new TclException(SwkJTextFieldWidgetCmd.this.interp, this.errMessage);
            }
            return this.index;
        }

        public void run() {
            Result result = new Result();
            this.swkjtextfield.getIndex(this.item, this.endVal, result);
            if (result.hasError()) {
                this.errMessage = result.getErrorMsg();
                return;
            }
            this.index = result.i;
        }
    }
}

