/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import tcl.lang.InternalRep;
import tcl.lang.TclDouble;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

abstract class TclObjectBase {
    protected InternalRep internalRep;
    protected int refCount;
    protected String stringRep;
    static final boolean saveObjRecords = false;
    static Hashtable objRecordMap = null;
    static final boolean validate = false;
    int ivalue;
    protected static final RuntimeException DEALLOCATED = new TclRuntimeError("TclObject has been deallocated");

    public final boolean isIntType() {
        return this.internalRep == TclInteger.dummy;
    }

    final boolean isStringType() {
        return this.internalRep instanceof TclString;
    }

    public final boolean isDoubleType() {
        return this.internalRep instanceof TclDouble;
    }

    final boolean isListType() {
        return this.internalRep instanceof TclList;
    }

    protected TclObjectBase(InternalRep rep) {
        this.internalRep = rep;
    }

    protected TclObjectBase(TclString rep, String s) {
        this.internalRep = rep;
        this.stringRep = s;
    }

    protected TclObjectBase(int ivalue) {
        this.internalRep = TclInteger.dummy;
        this.ivalue = ivalue;
    }

    public final InternalRep getInternalRep() {
        return this.internalRep;
    }

    public void setInternalRep(InternalRep rep) {
        if (this.internalRep == null) {
            this.disposedError();
        }
        if (rep == null) {
            throw new TclRuntimeError("null InternalRep");
        }
        if (rep == this.internalRep) {
            return;
        }
        this.internalRep.dispose();
        this.internalRep = rep;
        this.ivalue = 0;
    }

    public final String toString() {
        if (this.stringRep == null) {
            if (this.internalRep == null) {
                this.disposedError();
            }
            this.stringRep = this.isIntType() ? Integer.toString(this.ivalue) : this.internalRep.toString();
        }
        return this.stringRep;
    }

    public final void invalidateStringRep() throws TclRuntimeError {
        if (this.internalRep == null) {
            this.disposedError();
        }
        if (this.refCount > 1) {
            throw new TclRuntimeError("string representation of object \"" + this.toString() + "\" cannot be invalidated: refCount = " + this.refCount);
        }
        this.stringRep = null;
    }

    public final boolean isShared() {
        return this.refCount > 1;
    }

    public final TclObject duplicate() {
        TclObject newObj;
        if (this.isStringType() && this.stringRep == null) {
            this.stringRep = this.internalRep.toString();
        }
        if (this.isIntType()) {
            newObj = new TclObject((InternalRep)TclInteger.dummy);
            newObj.ivalue = this.ivalue;
        } else {
            newObj = new TclObject(this.internalRep.duplicate());
        }
        if (this.stringRep != null) {
            newObj.stringRep = this.stringRep;
        }
        return newObj;
    }

    public final TclObject takeExclusive() throws TclRuntimeError {
        if (this.internalRep == null) {
            this.disposedError();
        }
        if (this.refCount == 1) {
            return (TclObject)this;
        }
        if (this.refCount > 1) {
            TclObject newObj;
            if (this.isStringType() && this.stringRep == null) {
                this.stringRep = this.internalRep.toString();
            }
            if (this.isIntType()) {
                newObj = new TclObject((InternalRep)TclInteger.dummy);
                newObj.ivalue = this.ivalue;
            } else {
                newObj = new TclObject(this.internalRep.duplicate());
            }
            newObj.stringRep = this.stringRep;
            newObj.refCount = 1;
            --this.refCount;
            return newObj;
        }
        throw new TclRuntimeError("takeExclusive() called on object \"" + this.toString() + "\" with: refCount = 0");
    }

    final int getRefCount() {
        return this.refCount;
    }

    protected final void disposeObject() {
        if (this.internalRep == null) {
            throw DEALLOCATED;
        }
        this.internalRep.dispose();
        this.internalRep = null;
        this.stringRep = null;
        this.refCount = -1;
    }

    protected final void disposedError() {
        throw DEALLOCATED;
    }

    static String getObjRecords() {
        return "";
    }

    final boolean hasNoStringRep() {
        return this.stringRep == null;
    }
}

