/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/sleep.c")
public final class Sleep {
    private Sleep() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="unit")
    public static Value unix_sleep(Value t) throws FalseExit, FailException {
        CurrentContext.enterBlockingSection();
        try {
            Thread.sleep(t.asLong() * 1000L);
        }
        catch (InterruptedException ie) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        CurrentContext.leaveBlockingSection();
        return Value.UNIT;
    }
}

