/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractCodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Obj", source="byterun/obj.c")
public final class Obj {
    private static final Value LONG_TAG = Value.createLong(1000L);
    private static final Value NON_BLOCK_TAG = Value.createLong(1001L);
    private static final Value UNALIGNED_TAG = Value.createLong(1002L);

    private Obj() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Returns a string block."}, parameterTypes={"int"}, returnType="'a")
    public static Value caml_static_alloc(Value size) {
        return Value.createString(size.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Does nothing."}, parameterTypes={"'a"}, returnType="unit")
    public static Value caml_static_free(Value blk) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Does nothing."}, parameterTypes={"string", "int"}, returnType="unit")
    public static Value caml_static_release_bytecode(Value blk, Value size) throws FailException {
        if (OCamlJavaThread.getCodeRunner().isNative()) {
            Fail.failWith("Meta.static_release_bytecode impossible with native code");
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Treats parameter as a string and returns another one."}, parameterTypes={"string", "int"}, returnType="string")
    public static Value caml_static_resize(Value blk, Value size) {
        int sz = size.asCastedInt();
        byte[] res = new byte[sz];
        byte[] src = blk.getBytes();
        System.arraycopy(src, 0, res, 0, Math.min(src.length, sz));
        return Value.createString(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="bool")
    public static Value caml_obj_is_block(Value arg) {
        return arg.isBlock() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Obj.t"}, returnType="int")
    public static Value caml_obj_tag(Value arg) {
        if (arg.isLong()) {
            return LONG_TAG;
        }
        if (arg.isBlock()) {
            return Value.createLong(arg.getTag());
        }
        return NON_BLOCK_TAG;
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Subsequent use of block may fail if tag change", "implies representation shift."}, parameterTypes={"Obj.t", "int"}, returnType="unit")
    public static Value caml_obj_set_tag(Value arg, Value newTag) {
        arg.setTag(newTag.asCastedInt());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int"}, returnType="Obj.t")
    public static Value caml_obj_block(Value tag, Value size) {
        int tg = tag.asCastedInt();
        long sz = size.asLong();
        if (sz == 0L) {
            return CurrentContext.getCodeState().getAtom(tg);
        }
        return Value.createBlock(tg, sz);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Obj.t"}, returnType="Obj.t")
    public static Value caml_obj_dup(Value arg) {
        if (arg.getWoSize() == 0L) {
            return arg;
        }
        return arg.asBlock().duplicate();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Obj.t", "int"}, returnType="unit")
    public static Value caml_obj_truncate(Value v, Value newSize) throws FailException {
        v.asBlock().truncate(newSize.asLong());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Obj.t", "int32"}, returnType="Obj.t")
    public static Value caml_obj_add_offset(Value v, Value offset) {
        return v.offset(offset.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="'a")
    public static Value caml_lazy_follow_forward(Value v) {
        if (v.isBlock() && v.getTag() == 250) {
            return v.get0();
        }
        return v;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="'a lazy_t")
    public static Value caml_lazy_make_forward(Value v) {
        return Value.createBlock(250, v);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"CamlinternalOO.obj", "CamlinternalOO.tag"}, returnType="CamlinternalOO.closure")
    public static Value caml_get_public_method(Value obj, Value tag) {
        return AbstractCodeRunner.getMethod(obj, tag.getRawValue());
    }
}

