/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class SubstCmd
implements Command {
    private static final String[] validCmds = new String[]{"-nobackslashes", "-nocommands", "-novariables"};
    static final int OPT_NOBACKSLASHES = 0;
    static final int OPT_NOCOMMANDS = 1;
    static final int OPT_NOVARS = 2;

    SubstCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        int currentObjIndex;
        int objc = argv.length - 1;
        boolean doBackslashes = true;
        boolean doCmds = true;
        boolean doVars = true;
        StringBuffer result = new StringBuffer();
        block7: for (currentObjIndex = 1; currentObjIndex < objc && argv[currentObjIndex].toString().startsWith("-"); ++currentObjIndex) {
            int opt = TclIndex.get((Interp)interp, (TclObject)argv[currentObjIndex], (String[])validCmds, (String)"switch", (int)0);
            switch (opt) {
                case 0: {
                    doBackslashes = false;
                    continue block7;
                }
                case 1: {
                    doCmds = false;
                    continue block7;
                }
                case 2: {
                    doVars = false;
                    continue block7;
                }
                default: {
                    throw new TclException(interp, "SubstCmd.cmdProc: bad option " + opt + " index to cmds");
                }
            }
        }
        if (currentObjIndex != objc) {
            throw new TclNumArgsException(interp, currentObjIndex, argv, "?-nobackslashes? ?-nocommands? ?-novariables? string");
        }
        String s = argv[currentObjIndex].toString();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '[' && doCmds) {
                ParseResult res;
                try {
                    interp.evalFlags = 1;
                    interp.eval(s.substring(i + 1, len));
                    TclObject interp_result = interp.getResult();
                    interp_result.preserve();
                    res = new ParseResult(interp_result, i + interp.termOffset);
                }
                catch (TclException e) {
                    i = e.errIndex + 1;
                    throw e;
                }
                i = res.nextIndex + 2;
                result.append(res.value.toString());
                res.release();
                continue;
            }
            if (c == '$' && doVars) {
                ParseResult vres = Parser.parseVar(interp, s.substring(i, len));
                i += vres.nextIndex;
                result.append(vres.value.toString());
                vres.release();
                continue;
            }
            if (c == '\\' && doBackslashes) {
                BackSlashResult bs = Interp.backslash(s, i, len);
                i = bs.nextIndex;
                if (bs.isWordSep) break;
                result.append(bs.c);
                continue;
            }
            result.append(c);
            ++i;
        }
        interp.setResult(result.toString());
    }
}

