/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

class LindexCmd
implements Command {
    LindexCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length < 2) {
            throw new TclNumArgsException(interp, 1, objv, "list ?index...?");
        }
        TclObject elem = objv.length == 3 ? LindexCmd.TclLindexList(interp, objv[1], objv, 2) : LindexCmd.TclLindexFlat(interp, objv[1], objv.length - 2, objv, 2);
        if (elem == null) {
            throw new TclRuntimeError("unexpected null result");
        }
        interp.setResult(elem);
        elem.release();
    }

    static TclObject TclLindexList(Interp interp, TclObject list, TclObject[] objv, int argIndex) throws TclException {
        int index;
        TclObject arg = objv[argIndex];
        boolean isListType = arg.isListType();
        boolean isValidIndex = false;
        if (!isListType) {
            try {
                index = Util.getIntForIndex(null, arg, 0);
                isValidIndex = true;
            }
            catch (TclException ex) {
                // empty catch block
            }
        }
        if (!isListType && isValidIndex) {
            return LindexCmd.TclLindexFlat(interp, list, 1, objv, argIndex);
        }
        TclObject[] indices = null;
        try {
            indices = TclList.getElements(null, arg);
        }
        catch (TclException ex) {
            // empty catch block
        }
        if (indices == null) {
            return LindexCmd.TclLindexFlat(interp, list, 1, objv, argIndex);
        }
        list.preserve();
        for (int i = 0; i < indices.length; ++i) {
            int listLen;
            try {
                listLen = TclList.getLength(interp, list);
            }
            catch (TclException te) {
                list.release();
                throw te;
            }
            try {
                index = Util.getIntForIndex(interp, indices[i], listLen - 1);
            }
            catch (TclException te) {
                list.release();
                throw te;
            }
            if (index < 0 || index >= listLen) {
                list.release();
                list = interp.checkCommonString(null);
                list.preserve();
                return list;
            }
            TclObject oldList = list;
            list = TclList.index(interp, oldList, index);
            list.preserve();
            oldList.release();
        }
        return list;
    }

    static TclObject TclLindexFlat(Interp interp, TclObject list, int indexCount, TclObject[] indexArray, int indexArrayOffset) throws TclException {
        list.preserve();
        int endIndex = indexArrayOffset + indexCount;
        for (int i = indexArrayOffset; i < endIndex; ++i) {
            int index;
            int listLen;
            try {
                listLen = TclList.getLength(interp, list);
            }
            catch (TclException te) {
                list.release();
                throw te;
            }
            try {
                index = Util.getIntForIndex(interp, indexArray[i], listLen - 1);
            }
            catch (TclException te) {
                list.release();
                throw te;
            }
            if (index < 0 || index >= listLen) {
                list.release();
                list = interp.checkCommonString(null);
                list.preserve();
                return list;
            }
            try {
                listLen = TclList.getLength(interp, list);
            }
            catch (TclException te) {
                list.release();
                throw te;
            }
            TclObject oldList = list;
            list = TclList.index(interp, oldList, index);
            list.preserve();
            oldList.release();
        }
        return list;
    }
}

