/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/select.c")
public final class Select {
    private Select() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Does wait for given time if all descriptor lists are empty (as used by threads to emulate delay)."}, parameterTypes={"Unix.file_descr list", "Unix.file_descr list", "Unix.file_descr list", "float"}, returnType="Unix.file_descr list * Unix.file_descr list * Unix.file_descr list")
    public static Value unix_select(Value value, Value value2, Value value3, Value value4) throws FalseExit, FailException {
        double d;
        Context context = CurrentContext.CONTEXT;
        if (value == Value.EMPTY_LIST && value2 == Value.EMPTY_LIST && value3 == Value.EMPTY_LIST && (d = value4.asDouble()) > 0.0) {
            try {
                Thread.sleep((long)(d * 1000.0));
            }
            catch (InterruptedException interruptedException) {
                FalseExit falseExit = FalseExit.createFromContext(context);
                falseExit.fillInStackTrace();
                throw falseExit;
            }
        }
        return Value.createBlock(0, value, value2, value3);
    }
}

