/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.bigarray;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.primitives.otherlibs.bigarray.MemArray;
import org.ocamljava.runtime.primitives.stdlib.Hash;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.AbstractCustomOperations;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

final class CustomBigArray
extends AbstractCustomOperations {
    static final CustomOperations OPS = new CustomBigArray();
    private static final long FLAG_MASK = 511L;

    private CustomBigArray() {
        super("_bigarray", true, true, false, true, true);
    }

    @Override
    public void finalize(Value value) {
        MemArray memArray = (MemArray)value.asCustom();
        switch ((int)(memArray.getFlags() & 0x600L)) {
            case 512: {
                assert (false) : "unsupported";
                break;
            }
            case 1024: {
                memArray.unMap();
                break;
            }
            default: {
                assert (false) : "invalid bigarray kind";
                break;
            }
            case 0: 
        }
    }

    @Override
    public int compare(Value value, Value value2, AtomicBoolean atomicBoolean) {
        int n;
        MemArray memArray = (MemArray)value.asCustom();
        MemArray memArray2 = (MemArray)value2.asCustom();
        long l = memArray.getFlags() & 0x1FFL;
        long l2 = memArray2.getFlags() & 0x1FFL;
        int[] nArray = memArray.getDims();
        int[] nArray2 = memArray2.getDims();
        if (l != l2) {
            return (int)(l2 - l);
        }
        if (nArray.length != nArray2.length) {
            return nArray2.length - nArray.length;
        }
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            int n3 = nArray2[n];
            if (n2 == n3) continue;
            return n2 < n3 ? -1 : 1;
        }
        n = (int)memArray.getNumElems();
        ByteBuffer byteBuffer = memArray.getData();
        ByteBuffer byteBuffer2 = memArray2.getData();
        switch ((int)(l & 0xFFL)) {
            case 0: 
            case 10: {
                int n4 = (l & 0xFFL) == 10L ? 2 : 1;
                for (int i = 0; i < n * n4; ++i) {
                    float f;
                    float f2 = byteBuffer.getFloat(i * 4);
                    if (f2 < (f = byteBuffer2.getFloat(i * 4))) {
                        return -1;
                    }
                    if (f2 > f) {
                        return 1;
                    }
                    if (f2 == f) continue;
                    atomicBoolean.set(true);
                    if (f2 == f2) {
                        return 1;
                    }
                    if (f != f) continue;
                    return -1;
                }
                return 0;
            }
            case 1: 
            case 11: {
                int n5 = (l & 0xFFL) == 11L ? 2 : 1;
                for (int i = 0; i < n * n5; ++i) {
                    double d;
                    double d2 = byteBuffer.getDouble(i * 8);
                    if (d2 < (d = byteBuffer2.getDouble(i * 8))) {
                        return -1;
                    }
                    if (d2 > d) {
                        return 1;
                    }
                    if (d2 == d) continue;
                    atomicBoolean.set(true);
                    if (d2 == d2) {
                        return 1;
                    }
                    if (d != d) continue;
                    return -1;
                }
                return 0;
            }
            case 2: {
                for (int i = 0; i < n; ++i) {
                    byte by;
                    byte by2 = byteBuffer.get(i * 1);
                    if (by2 < (by = byteBuffer2.get(i * 1))) {
                        return -1;
                    }
                    if (by2 <= by) continue;
                    return 1;
                }
                return 0;
            }
            case 3: {
                for (int i = 0; i < n; ++i) {
                    int n6;
                    int n7 = IntegerUtils.signedToUnsignedByte(byteBuffer.get(i * 1));
                    if (n7 < (n6 = IntegerUtils.signedToUnsignedByte(byteBuffer2.get(i * 1)))) {
                        return -1;
                    }
                    if (n7 <= n6) continue;
                    return 1;
                }
                return 0;
            }
            case 4: {
                for (int i = 0; i < n; ++i) {
                    short s;
                    short s2 = byteBuffer.getShort(i * 2);
                    if (s2 < (s = byteBuffer2.getShort(i * 2))) {
                        return -1;
                    }
                    if (s2 <= s) continue;
                    return 1;
                }
                return 0;
            }
            case 5: {
                for (int i = 0; i < n; ++i) {
                    int n8;
                    int n9 = IntegerUtils.signedToUnsignedShort(byteBuffer.getShort(i * 2));
                    if (n9 < (n8 = IntegerUtils.signedToUnsignedShort(byteBuffer2.getShort(i * 2)))) {
                        return -1;
                    }
                    if (n9 <= n8) continue;
                    return 1;
                }
                return 0;
            }
            case 7: 
            case 9: {
                for (int i = 0; i < n; ++i) {
                    long l3;
                    long l4 = byteBuffer.getLong(i * 8);
                    if (l4 < (l3 = byteBuffer2.getLong(i * 8))) {
                        return -1;
                    }
                    if (l4 <= l3) continue;
                    return 1;
                }
                return 0;
            }
            case 6: 
            case 8: {
                for (int i = 0; i < n; ++i) {
                    int n10;
                    int n11 = byteBuffer.getInt(i * 4);
                    if (n11 < (n10 = byteBuffer2.getInt(i * 4))) {
                        return -1;
                    }
                    if (n11 <= n10) continue;
                    return 1;
                }
                return 0;
            }
        }
        assert (false) : "invalid elements kind";
        return 0;
    }

    @Override
    public long hash(Value value) {
        MemArray memArray = (MemArray)value.asCustom();
        ByteBuffer byteBuffer = memArray.getData();
        int n = (int)memArray.getNumElems();
        int n2 = 0;
        int n3 = (int)(memArray.getFlags() & 0xFFL);
        block0 : switch (n3) {
            case 2: 
            case 3: {
                int n4;
                if (n > 256) {
                    n = 256;
                }
                int n5 = 0;
                while (n5 + 4 <= n) {
                    n4 = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 0) * 1)) | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 1) * 1)) << 8 | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 2) * 1)) << 16 | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 3) * 1)) << 24;
                    n2 = Hash.caml_hash_mix_uint32(n2, n4);
                    n5 += 4;
                }
                switch (n & 3) {
                    case 0: {
                        n4 = 0;
                        break block0;
                    }
                    case 1: {
                        n4 = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 0) * 1));
                        break block0;
                    }
                    case 2: {
                        n4 = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 0) * 1)) | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 1) * 1)) << 8;
                        break block0;
                    }
                    case 3: {
                        n4 = IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 0) * 1)) | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 1) * 1)) << 8 | IntegerUtils.signedToUnsignedByte(byteBuffer.get((n5 + 2) * 1)) << 16;
                        break block0;
                    }
                }
                assert (false) : "should not happen";
                break;
            }
            case 4: 
            case 5: {
                if (n > 128) {
                    n = 128;
                }
                int n6 = 0;
                while (n6 + 2 <= n) {
                    int n7 = IntegerUtils.signedToUnsignedShort(byteBuffer.getShort(n6 * 2)) | IntegerUtils.signedToUnsignedShort(byteBuffer.getShort((n6 + 1) * 2)) << 16;
                    n2 = Hash.caml_hash_mix_uint32(n2, n7);
                    n6 += 2;
                }
                if ((n & 1) == 0) break;
                n2 = Hash.caml_hash_mix_uint32(n2, IntegerUtils.signedToUnsignedShort(byteBuffer.getShort(n6 * 2)));
                break;
            }
            case 6: {
                if (n > 64) {
                    n = 64;
                }
                for (int i = 0; i < n; ++i) {
                    n2 = Hash.caml_hash_mix_uint32(n2, byteBuffer.getInt(i * 4));
                }
                break;
            }
            case 8: 
            case 9: {
                if (n > 64) {
                    n = 64;
                }
                for (int i = 0; i < n; ++i) {
                    n2 = Hash.caml_hash_mix_intnat(n2, byteBuffer.getLong(i * 8));
                }
                break;
            }
            case 7: {
                if (n > 32) {
                    n = 32;
                }
                for (int i = 0; i < n; ++i) {
                    n2 = Hash.caml_hash_mix_int64(n2, byteBuffer.getLong(i * 8));
                }
                break;
            }
            case 0: 
            case 10: {
                if (n3 == 10) {
                    n *= 2;
                }
                if (n > 64) {
                    n = 64;
                }
                for (int i = 0; i < n; ++i) {
                    n2 = Hash.caml_hash_mix_float(n2, byteBuffer.getFloat(i * 4));
                }
                break;
            }
            case 1: 
            case 11: {
                if (n3 == 11) {
                    n *= 2;
                }
                if (n > 32) {
                    n = 32;
                }
                for (int i = 0; i < n; ++i) {
                    n2 = Hash.caml_hash_mix_double(n2, byteBuffer.getDouble(i * 8));
                }
                break;
            }
            default: {
                assert (false) : "invalid bigarray kind";
                break;
            }
        }
        return n2;
    }

    @Override
    public CustomOperations.SerializationSizes serialize(DataOutput dataOutput, Value value) throws IOException {
        int n;
        int n2;
        MemArray memArray = (MemArray)value.asCustom();
        ByteBuffer byteBuffer = memArray.getData();
        int[] nArray = memArray.getDims();
        IO.write32s(dataOutput, nArray.length);
        IO.write32s(dataOutput, (int)(memArray.getFlags() & 0x1FFL));
        int n3 = 1;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            IO.write32s(dataOutput, n);
            n3 *= n;
        }
        switch ((int)(memArray.getFlags() & 0xFFL)) {
            case 2: 
            case 3: {
                for (n2 = 0; n2 < n3; ++n2) {
                    IO.write8s(dataOutput, byteBuffer.get(n2 * 1));
                }
                break;
            }
            case 4: 
            case 5: {
                for (n2 = 0; n2 < n3; ++n2) {
                    IO.write16s(dataOutput, byteBuffer.getShort(n2 * 2));
                }
                break;
            }
            case 0: 
            case 6: {
                for (n2 = 0; n2 < n3; ++n2) {
                    IO.write32s(dataOutput, byteBuffer.getInt(n2 * 4));
                }
                break;
            }
            case 10: {
                for (n2 = 0; n2 < n3 * 2; ++n2) {
                    IO.write32s(dataOutput, byteBuffer.getInt(n2 * 4));
                }
                break;
            }
            case 1: 
            case 7: {
                for (n2 = 0; n2 < n3; ++n2) {
                    IO.write64s(dataOutput, byteBuffer.getLong(n2 * 8));
                }
                break;
            }
            case 11: {
                for (n2 = 0; n2 < n3 * 2; ++n2) {
                    IO.write64s(dataOutput, byteBuffer.getLong(n2 * 8));
                }
                break;
            }
            case 8: {
                for (n2 = 0; n2 < n3 && byteBuffer.getLong(n2 * 8) >= -4611686018427387904L && byteBuffer.getLong(n2 * 8) <= 0x3FFFFFFFFFFFFFFFL; ++n2) {
                }
                if (n2 == n3) {
                    IO.write8u(dataOutput, 0);
                    for (n = 0; n < n3; ++n) {
                        IO.write32s(dataOutput, (int)byteBuffer.getLong(n2 * 8));
                    }
                } else {
                    IO.write8u(dataOutput, 1);
                    for (n = 0; n < n3; ++n) {
                        IO.write64s(dataOutput, byteBuffer.getLong(n2 * 8));
                    }
                }
                break;
            }
            case 9: {
                for (n2 = 0; n2 < n3 && byteBuffer.getLong(n2 * 8) >= Integer.MIN_VALUE && byteBuffer.getLong(n2 * 8) <= Integer.MAX_VALUE; ++n2) {
                }
                if (n2 == n3) {
                    IO.write8u(dataOutput, 0);
                    for (n = 0; n < n3; ++n) {
                        IO.write32s(dataOutput, (int)byteBuffer.getLong(n2 * 8));
                    }
                } else {
                    IO.write8u(dataOutput, 1);
                    for (n = 0; n < n3; ++n) {
                        IO.write64s(dataOutput, byteBuffer.getLong(n2 * 8));
                    }
                }
                break;
            }
            default: {
                assert (false) : "invalid bigarray kind";
                break;
            }
        }
        return new CustomOperations.SerializationSizes(4 + nArray.length * 4, 4 + nArray.length * 8);
    }

    @Override
    public CustomOperations.DeserializedValue deserialize(DataInput dataInput) throws FailException, FatalError, IOException {
        int n;
        int n2 = IntegerUtils.ensure32s(IO.read32u(dataInput));
        int n3 = IO.read32s(dataInput);
        int[] nArray = new int[n2];
        long l = 1L;
        for (int i = 0; i < n2; ++i) {
            int n4;
            nArray[i] = n4 = IntegerUtils.ensure32s(IO.read32u(dataInput));
            l *= (long)n4;
        }
        if ((n3 & 0xFF) > 11) {
            Fail.failWith("input_value: bad bigarray kind");
        }
        MemArray memArray = new MemArray(n3, nArray, null);
        ByteBuffer byteBuffer = memArray.getData();
        switch ((int)(memArray.getFlags() & 0xFFL)) {
            case 2: 
            case 3: {
                n = 0;
                while ((long)n < l) {
                    byteBuffer.put(n * 1, (byte)IO.read8s(dataInput));
                    ++n;
                }
                break;
            }
            case 4: 
            case 5: {
                n = 0;
                while ((long)n < l) {
                    byteBuffer.putShort(n * 2, (short)IO.read16s(dataInput));
                    ++n;
                }
                break;
            }
            case 0: 
            case 6: {
                n = 0;
                while ((long)n < l) {
                    byteBuffer.putInt(n * 4, IO.read32s(dataInput));
                    ++n;
                }
                break;
            }
            case 10: {
                n = 0;
                while ((long)n < l * 2L) {
                    byteBuffer.putInt(n * 4, IO.read32s(dataInput));
                    ++n;
                }
                break;
            }
            case 1: 
            case 7: {
                n = 0;
                while ((long)n < l) {
                    byteBuffer.putLong(n * 8, IO.read64s(dataInput));
                    ++n;
                }
                break;
            }
            case 11: {
                n = 0;
                while ((long)n < l * 2L) {
                    byteBuffer.putLong(n * 8, IO.read64s(dataInput));
                    ++n;
                }
                break;
            }
            case 8: 
            case 9: {
                if (IO.read8u(dataInput) == 0) {
                    n = 0;
                    while ((long)n < l) {
                        byteBuffer.putLong(n * 8, IO.read32s(dataInput));
                        ++n;
                    }
                } else {
                    n = 0;
                    while ((long)n < l) {
                        byteBuffer.putLong(n * 8, IO.read64s(dataInput));
                        ++n;
                    }
                }
                break;
            }
            default: {
                assert (false) : "invalid elements kind";
                break;
            }
        }
        n = 20 + (memArray.getNumDims() - 1) * 8;
        Value value = Value.createCustom(OPS, n, memArray);
        return new CustomOperations.DeserializedValue(value, n);
    }
}

