/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.Graphics;
import java.awt.Graphics2D;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/fill.c")
public final class Fill {
    private Fill() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_fill_rect(Value value, Value value2, Value value3, Value value4) throws FailException {
        Graphics2D graphics2D;
        GraphSlot graphSlot = GraphSlot.checkGraph();
        int n = value3.asCastedInt();
        int n2 = value4.asCastedInt();
        int n3 = value.asCastedInt();
        int n4 = graphSlot.convertY(value2.asCastedInt()) - n2;
        Graphics2D graphics2D2 = graphSlot.createWindowGraphics();
        if (graphics2D2 != null) {
            graphics2D2.fillRect(n3, n4, n, n2);
            graphics2D2.dispose();
            graphSlot.repaint();
        }
        if ((graphics2D = graphSlot.createBackingStoreGraphics()) != null) {
            graphics2D.fillRect(n3, n4, n, n2);
            graphics2D.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"(int * int) array"}, returnType="unit")
    public static Value caml_gr_fill_poly(Value value) throws FailException {
        Object object;
        GraphSlot graphSlot = GraphSlot.checkGraph();
        int n = (int)value.sizeValues();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            object = value.get(i);
            nArray[i] = ((Value)object).get0().asCastedInt();
            nArray2[i] = graphSlot.convertY(((Value)object).get1().asCastedInt());
        }
        Graphics2D graphics2D = graphSlot.createWindowGraphics();
        if (graphics2D != null) {
            graphics2D.fillPolygon(nArray, nArray2, n);
            graphics2D.dispose();
            graphSlot.repaint();
        }
        if ((object = graphSlot.createBackingStoreGraphics()) != null) {
            ((Graphics)object).fillPolygon(nArray, nArray2, n);
            ((Graphics)object).dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_fill_arc(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws FailException {
        Graphics2D graphics2D;
        GraphSlot graphSlot = GraphSlot.checkGraph();
        int n = value3.asCastedInt();
        int n2 = value4.asCastedInt();
        int n3 = value.asCastedInt() - n;
        int n4 = graphSlot.convertY(value2.asCastedInt()) - n2;
        int n5 = n * 2;
        int n6 = n2 * 2;
        int n7 = value5.asCastedInt();
        int n8 = value6.asCastedInt() - n7;
        Graphics2D graphics2D2 = graphSlot.createWindowGraphics();
        if (graphics2D2 != null) {
            graphics2D2.fillArc(n3, n4, n5, n6, n7, n8);
            graphics2D2.dispose();
            graphSlot.repaint();
        }
        if ((graphics2D = graphSlot.createBackingStoreGraphics()) != null) {
            graphics2D.fillArc(n3, n4, n5, n6, n7, n8);
            graphics2D.dispose();
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "int", "int", "int"}, returnType="unit")
    public static Value caml_gr_fill_arc_nat(Value value, Value value2, Value value3, Value value4, Value value5, Value value6) throws FailException {
        return Fill.caml_gr_fill_arc(value, value2, value3, value4, value5, value6);
    }
}

