/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinSplitArrayTask;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinSplitListTask;
import org.ocamljava.runtime.primitives.javalibs.concurrent.ForkJoinSplitTask;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ForkJoin", source="")
public final class ForkJoin {
    private ForkJoin() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> ('a * 'a) option)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split(Value pool, Value fork, Value join, Value func, Value x) throws FailException, Throwable {
        ForkJoinPool p = (ForkJoinPool)pool.asCustom();
        ForkJoinSplitTask t = new ForkJoinSplitTask(fork, join, func, x);
        Value res = null;
        try {
            res = p.invoke(t);
        }
        catch (RejectedExecutionException ree) {
            Fail.invalidArgument("Concurrent.ForkJoin.split");
        }
        catch (Throwable th) {
            Throwable cause = th.getCause();
            throw new Throwable(cause);
        }
        if (res != null) {
            return res;
        }
        throw new Throwable(t.getException());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> 'a list)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split_list$(ForkJoinPool p, Value fork, Value join, Value func, Value x) throws FailException, Throwable {
        ForkJoinSplitListTask t = new ForkJoinSplitListTask(fork, join, func, x);
        Value res = null;
        try {
            res = p.invoke(t);
        }
        catch (RejectedExecutionException ree) {
            Fail.invalidArgument("Concurrent.ForkJoin.split_list");
        }
        catch (Throwable th) {
            Throwable cause = th.getCause();
            throw new Throwable(cause);
        }
        if (res != null) {
            return res;
        }
        throw new Throwable(t.getException());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> 'a list)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split_list(Value pool, Value fork, Value join, Value func, Value x) throws FailException, Throwable {
        return ForkJoin.ocamljava_forkjoin_split_list$((ForkJoinPool)pool.asCustom(), fork, join, func, x);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> 'a array)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split_array$(ForkJoinPool p, Value fork, Value join, Value func, Value x) throws FailException, Throwable {
        ForkJoinSplitArrayTask t = new ForkJoinSplitArrayTask(fork, join, func, x);
        Value res = null;
        try {
            res = p.invoke(t);
        }
        catch (RejectedExecutionException ree) {
            Fail.invalidArgument("Concurrent.ForkJoin.split_array");
        }
        catch (Throwable th) {
            Throwable cause = th.getCause();
            throw new Throwable(cause);
        }
        if (res != null) {
            return res;
        }
        throw new Throwable(t.getException());
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ForkJoinPool.t", "('a -> 'a array)", "('b -> 'b -> 'b)", "('a -> 'b)", "'a"}, returnType="'b")
    public static Value ocamljava_forkjoin_split_array(Value pool, Value fork, Value join, Value func, Value x) throws FailException, Throwable {
        return ForkJoin.ocamljava_forkjoin_split_array$((ForkJoinPool)pool.asCustom(), fork, join, func, x);
    }
}

