/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.ocamljava.runtime.gui.CopyThread;
import org.ocamljava.runtime.kernel.Executable;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.OCamlJavaException;

public final class InOutPanel
extends JPanel
implements Runnable {
    static final long serialVersionUID = 2411640127352426825L;
    private static final String OUTPUT_FONT = "Monospaced";
    private static final String SEND = "send";
    private static final String HISTORY = "history";
    private static final String SAVE = "save";
    private static final String CLOSE = "close";
    private static final String ERROR_TITLE = "Error";
    private static final String ERROR_MESSAGE = "Unable to write to file";
    private static final int BORDER = 16;
    private final transient Executable executable;
    private final JTextArea output;
    private final JScrollPane scroll;
    private final JTextArea source;
    private final List<String> history;
    private int position;
    private final transient PrintStream standardInput;
    private final transient InputStream standardOutput;
    private final transient InputStream standardError;
    private final Action sendAction = new AbstractAction(){
        static final long serialVersionUID = 3237743495969414638L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            String text = InOutPanel.this.source.getText();
            InOutPanel.this.standardInput.println(text);
            JTextArea jTextArea = InOutPanel.this.output;
            synchronized (jTextArea) {
                InOutPanel.this.output.append(text);
                InOutPanel.this.output.append("\n");
            }
            InOutPanel.this.source.setText("");
            InOutPanel.this.source.grabFocus();
            InOutPanel.this.history.add(0, text);
            InOutPanel.this.position = -1;
            InOutPanel.this.repaint();
        }
    };

    public InOutPanel(Executable exec, PrintStream in, InputStream out, InputStream err) {
        super(new BorderLayout());
        assert (exec != null) : "null exec";
        assert (in != null) : "null in";
        assert (out != null) : "null out";
        assert (err != null) : "null err";
        this.executable = exec;
        this.standardInput = in;
        this.standardOutput = out;
        this.standardError = err;
        this.history = new LinkedList<String>();
        this.position = -1;
        JPanel areasPanel = new JPanel(new GridLayout(2, 1, 4, 4));
        this.output = new JTextArea();
        this.output.setName("org.ocamljava.runtime.gui.InOutPanel.output");
        this.output.setFont(new Font(OUTPUT_FONT, 0, this.output.getFont().getSize()));
        this.output.setEditable(false);
        this.source = new JTextArea();
        this.source.setName("org.ocamljava.runtime.gui.InOutPanel.source");
        Object enterKey = new Object();
        this.source.getInputMap().put(KeyStroke.getKeyStroke(10, 2, true), enterKey);
        this.source.getActionMap().put(enterKey, this.sendAction);
        Object upKey = new Object();
        this.source.getInputMap().put(KeyStroke.getKeyStroke(38, 2, true), upKey);
        this.source.getActionMap().put(upKey, new HistoryNavigator(1));
        Object downKey = new Object();
        this.source.getInputMap().put(KeyStroke.getKeyStroke(40, 2, true), downKey);
        this.source.getActionMap().put(downKey, new HistoryNavigator(-1));
        this.scroll = new JScrollPane(this.output, 20, 30);
        areasPanel.add(this.scroll);
        areasPanel.add(new JScrollPane(this.source, 20, 30));
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        JButton historyButton = new JButton(HISTORY);
        historyButton.setName("org.ocamljava.runtime.gui.InOutPanel.history");
        historyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new HistoryDialog();
            }
        });
        JButton sendButton = new JButton(SEND);
        sendButton.setName("org.ocamljava.runtime.gui.InOutPanel.send");
        sendButton.addActionListener(this.sendAction);
        buttonsPanel.add((Component)historyButton, "West");
        buttonsPanel.add(Box.createHorizontalGlue(), "Center");
        buttonsPanel.add((Component)sendButton, "East");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)areasPanel, "Center");
        mainPanel.add((Component)buttonsPanel, "South");
        this.add(Box.createVerticalStrut(16), "North");
        this.add(Box.createVerticalStrut(16), "South");
        this.add(Box.createHorizontalStrut(16), "East");
        this.add(Box.createHorizontalStrut(16), "West");
        this.add((Component)mainPanel, "Center");
        this.source.requestFocus();
        new CopyThread(out, this.output, this.scroll).start();
        new CopyThread(err, this.output, this.scroll).start();
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block13: {
            try {
                this.executable.executeSilently();
            }
            catch (OCamlJavaException ie) {
                Throwable t = ie.getCause();
                if (t instanceof FailException || t instanceof FatalError) break block13;
                JTextArea jTextArea = this.output;
                synchronized (jTextArea) {
                    this.output.append("error: " + ie.getMessage());
                }
            }
            catch (Exception e) {
                JTextArea jTextArea = this.output;
                synchronized (jTextArea) {
                    this.output.append("internal error: " + e.getMessage());
                }
            }
            catch (Throwable t) {
                JTextArea jTextArea = this.output;
                synchronized (jTextArea) {
                    this.output.append("Java error: " + t.getMessage());
                }
            }
        }
    }

    private final class HistoryNavigator
    extends AbstractAction {
        static final long serialVersionUID = 123654288864806406L;
        private final int delta;

        private HistoryNavigator(int d) {
            this.delta = d;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            InOutPanel.this.position += this.delta;
            int len = InOutPanel.this.history.size();
            if (InOutPanel.this.position >= len) {
                InOutPanel.this.position = len - 1;
            }
            if (InOutPanel.this.position < 0) {
                InOutPanel.this.position = 0;
            }
            if (InOutPanel.this.position >= 0 && InOutPanel.this.position < len) {
                String s = (String)InOutPanel.this.history.get(InOutPanel.this.position);
                InOutPanel.this.source.setText(s);
                InOutPanel.this.repaint();
            }
        }
    }

    private final class HistoryDialog
    extends JDialog {
        static final long serialVersionUID = -1057305832727479511L;

        private HistoryDialog() {
            super((Frame)null, "History", true);
            this.setDefaultCloseOperation(2);
            int len = InOutPanel.this.history.size();
            String[] items = new String[len];
            InOutPanel.this.history.toArray(items);
            final JList<String> list = new JList<String>(items);
            list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getClickCount() == 2) {
                        int index = list.locationToIndex(me.getPoint());
                        Object item = list.getModel().getElementAt(index);
                        InOutPanel.this.source.setText(item.toString());
                    }
                }
            });
            JPanel buttonsPanel = new JPanel(new BorderLayout());
            JButton saveButton = new JButton(InOutPanel.SAVE);
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JFileChooser fc = new JFileChooser();
                    if (fc.showSaveDialog(HistoryDialog.this) == 0) {
                        try {
                            FileWriter out = new FileWriter(fc.getSelectedFile());
                            ListIterator it = InOutPanel.this.history.listIterator(InOutPanel.this.history.size());
                            while (it.hasPrevious()) {
                                out.write((String)it.previous());
                                out.write("\n\n");
                            }
                            out.close();
                        }
                        catch (IOException ioe) {
                            JOptionPane.showMessageDialog(HistoryDialog.this, InOutPanel.ERROR_MESSAGE, InOutPanel.ERROR_TITLE, 0);
                        }
                    }
                }
            });
            JButton closeButton = new JButton(InOutPanel.CLOSE);
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    HistoryDialog.this.setVisible(false);
                }
            });
            buttonsPanel.add((Component)saveButton, "West");
            buttonsPanel.add(Box.createHorizontalGlue(), "Center");
            buttonsPanel.add((Component)closeButton, "East");
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)new JScrollPane(list, 20, 31), "Center");
            mainPanel.add((Component)buttonsPanel, "South");
            this.add(Box.createVerticalStrut(16), "North");
            this.add(Box.createVerticalStrut(16), "South");
            this.add(Box.createHorizontalStrut(16), "East");
            this.add(Box.createHorizontalStrut(16), "West");
            this.add((Component)mainPanel, "Center");
            this.setSize(400, 300);
            this.setResizable(false);
            this.setVisible(true);
        }
    }
}

