/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank.canvas3D;

import com.onemoonscientific.swank.SwankUtil;
import com.onemoonscientific.swank.SwkException;
import com.onemoonscientific.swank.canvas3D.NvBranchGroup;
import com.onemoonscientific.swank.canvas3D.SwkCanvasType;
import com.onemoonscientific.swank.canvas3D.SwkShape;
import com.onemoonscientific.swank.canvas3D.Transformer;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.SwingUtilities;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

public class SwkImageCanvas
implements SwkCanvasType {
    static Hashtable resourceDB = null;
    static String[] validCmds = new String[]{"-alignmentx", "-alignmenty", "-anchor", "-autoscrolls", "-background", "-bd", "-bg", "-borderwidth", "-border", "-bounds", "-class", "-cursor", "-debuggraphicsoptions", "-doublebuffered", "-enabled", "-fg", "-focusable", "-focuscycleroot", "-focustraversalkeysenabled", "-font", "-foreground", "-height", "-highlightbackground", "-highlightcolor", "-highlightthickness", "-ignorerepaint", "-insertbackground", "-insertborderwidth", "-insertofftime", "-insertontime", "-insertwidth", "-location", "-maximumsize", "-minimumsize", "-name", "-opaque", "-padx", "-pady", "-preferredsize", "-relief", "-requestfocusenabled", "-scrollregion", "-size", "-tooltiptext", "-verifyinputwhenfocustarget", "-visible", "-width", "-xscrollcommand", "-yscrollcommand"};
    private static final int OPT_ALIGNMENTX = 0;
    private static final int OPT_ALIGNMENTY = 1;
    private static final int OPT_ANCHOR = 2;
    private static final int OPT_AUTOSCROLLS = 3;
    private static final int OPT_BACKGROUND = 4;
    private static final int OPT_BD = 5;
    private static final int OPT_BG = 6;
    private static final int OPT_BORDERWIDTH = 7;
    private static final int OPT_BORDER = 8;
    private static final int OPT_BOUNDS = 9;
    private static final int OPT_CLASS = 10;
    private static final int OPT_CURSOR = 11;
    private static final int OPT_DEBUGGRAPHICSOPTIONS = 12;
    private static final int OPT_DOUBLEBUFFERED = 13;
    private static final int OPT_ENABLED = 14;
    private static final int OPT_FG = 15;
    private static final int OPT_FOCUSABLE = 16;
    private static final int OPT_FOCUSCYCLEROOT = 17;
    private static final int OPT_FOCUSTRAVERSALKEYSENABLED = 18;
    private static final int OPT_FONT = 19;
    private static final int OPT_FOREGROUND = 20;
    private static final int OPT_HEIGHT = 21;
    private static final int OPT_HIGHLIGHTBACKGROUND = 22;
    private static final int OPT_HIGHLIGHTCOLOR = 23;
    private static final int OPT_HIGHLIGHTTHICKNESS = 24;
    private static final int OPT_IGNOREREPAINT = 25;
    private static final int OPT_INSERTBACKGROUND = 26;
    private static final int OPT_INSERTBORDERWIDTH = 27;
    private static final int OPT_INSERTOFFTIME = 28;
    private static final int OPT_INSERTONTIME = 29;
    private static final int OPT_INSERTWIDTH = 30;
    private static final int OPT_LOCATION = 31;
    private static final int OPT_MAXIMUMSIZE = 32;
    private static final int OPT_MINIMUMSIZE = 33;
    private static final int OPT_NAME = 34;
    private static final int OPT_OPAQUE = 35;
    private static final int OPT_PADX = 36;
    private static final int OPT_PADY = 37;
    private static final int OPT_PREFERREDSIZE = 38;
    private static final int OPT_RELIEF = 39;
    private static final int OPT_REQUESTFOCUSENABLED = 40;
    private static final int OPT_SCROLLREGION = 41;
    private static final int OPT_SIZE = 42;
    private static final int OPT_TOOLTIPTEXT = 43;
    private static final int OPT_VERIFYINPUTWHENFOCUSTARGET = 44;
    private static final int OPT_VISIBLE = 45;
    private static final int OPT_WIDTH = 46;
    private static final int OPT_XSCROLLCOMMAND = 47;
    private static final int OPT_YSCROLLCOMMAND = 48;
    String name = null;
    String className = null;
    LinkedList children = null;
    Vector virtualBindings = null;
    int active = 0;
    boolean created = false;
    TclObject tclObject = null;
    final Interp interp;
    boolean isCreated = false;
    Insets emptyBorderInsets = new Insets(0, 0, 0, 0);
    Vector tagList = new Vector();
    Color insertBackground;
    int insertWidth = 0;
    int insertBorderWidth = 0;
    int insertOffTime = 0;
    int insertOnTime = 0;
    int[][] scrollRegion = new int[2][2];
    float[] anchor = new float[]{0.0f, 0.0f};
    double borderWidth = 0.0;
    Color highlightBackground = Color.white;
    Color highlightColor = Color.red;
    int highlightThickness;
    int padx;
    int pady;
    String relief = null;
    String xScrollCommand = null;
    String yScrollCommand = null;
    Graphics g1 = null;
    BasicStroke stroke = new BasicStroke();
    double zoom = 1.0;
    AffineTransform canvasTransform = new AffineTransform();
    Hashtable transformerHash = new Hashtable();
    Point2D transMouse = new Point2D.Double();
    Point2D origMouse = new Point2D.Double();
    FontRenderContext fRC = null;
    Hashtable swkShapes = new Hashtable(16);
    int lastShapeId = 0;
    SwkShape firstShape = null;
    SwkShape lastShape = null;
    SwkShape eventCurrentShape = null;
    SwkShape lastShapeScanned = null;
    Point currentPt = new Point(0, 0);
    String currentTag = null;
    String previousTag = null;
    TclObject[] currentTags = null;
    TclObject[] previousTags = null;
    Hashtable focusHash = null;
    Hashtable mouseHash = null;
    Hashtable mouseMotionHash = null;
    Hashtable keyHash = null;
    Hashtable tagHash = new Hashtable();
    Vector tagVec = new Vector();
    int swkwidth = 1;
    int swkheight = 1;
    int mouseX = 0;
    int mouseY = 0;
    Component component = null;
    SimpleUniverse universe = null;
    View view = null;
    TransformGroup objTransM = null;
    TransformGroup objTrans = null;
    Point3d eyePosition = new Point3d(0.0, 0.0, 100.0);
    Point3d viewCenter = new Point3d(0.0, 0.0, 0.0);
    Vector3d upDirection = new Vector3d(0.0, 1.0, 0.0);
    Vector3f center = new Vector3f(0.0f, 0.0f, 0.0f);
    Transform3D centerTrans = new Transform3D();
    Appearance defaultAppearance = null;
    Background bg = null;
    Color3f color3f = new Color3f();
    Canvas3D c3D;

    public SwkImageCanvas(Interp interp, String name, String className) {
        this.name = name.intern();
        this.interp = interp;
        this.defaultAppearance = new Appearance();
        Material material = new Material();
        material.setAmbientColor(0.0f, 1.0f, 0.0f);
        material.setEmissiveColor(0.0f, 1.0f, 0.0f);
        material.setDiffuseColor(0.0f, 1.0f, 0.0f);
        material.setSpecularColor(0.0f, 1.0f, 0.0f);
        material.setShininess(100.0f);
        this.defaultAppearance.setMaterial(material);
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.c3D = new Canvas3D(config);
        this.universe = new SimpleUniverse(this.c3D);
        this.universe.getViewingPlatform().setNominalViewingTransform();
        this.universe.getViewer().getView().setBackClipDistance(300.0);
        this.universe.getViewer().getView().setFrontClipDistance(3.0);
        this.setEyePosition(0.0f, 0.0f, 100.0f);
        this.addBranchGraph(this.createSceneGraph2());
        this.isCreated = true;
        this.tagList.add(name);
        this.tagList.add("swank");
        this.tagList.add("all");
    }

    public Canvas3D getCanvas3D() {
        return this.c3D;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public void setCreated(boolean state) {
        this.isCreated = state;
    }

    public Vector getTagList() {
        return this.tagList;
    }

    public void setTagList(Interp interp, TclObject tagListObj) throws TclException {
        TclObject[] tagObjs = TclList.getElements((Interp)interp, (TclObject)tagListObj);
        this.tagList.setSize(0);
        for (int i = 0; i < tagObjs.length; ++i) {
            this.tagList.add(tagObjs[i].toString());
        }
    }

    public void setVirtualBindings(Vector bindings) {
        this.virtualBindings = bindings;
    }

    public Vector getVirtualBindings() {
        return this.virtualBindings;
    }

    public Insets getEmptyBorderInsets() {
        return this.emptyBorderInsets;
    }

    public LinkedList getChildrenList() {
        return this.children;
    }

    public void initChildrenList() {
        this.children = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public void setInsertBackground(Color insertBackground) {
        this.insertBackground = insertBackground;
    }

    public Color getInsertBackground() {
        return this.insertBackground;
    }

    public void setInsertWidth(int insertWidth) {
        this.insertWidth = insertWidth;
    }

    public int getInsertWidth() {
        return this.insertWidth;
    }

    public void setInsertBorderWidth(int insertBorderWidth) {
        this.insertBorderWidth = insertBorderWidth;
    }

    public int getInsertBorderWidth() {
        return this.insertBorderWidth;
    }

    public void setInsertOffTime(int insertOffTime) {
        this.insertOffTime = insertOffTime;
    }

    public int getInsertOffTime() {
        return this.insertOffTime;
    }

    public void setInsertOnTime(int insertOnTime) {
        this.insertOnTime = insertOnTime;
    }

    public int getInsertOnTime() {
        return this.insertOnTime;
    }

    public void setAnchor(float[] anchor) {
        this.anchor = anchor;
    }

    public float[] getAnchor() {
        return this.anchor;
    }

    public void setEventCurrentShape(SwkShape shape) {
        this.eventCurrentShape = shape;
    }

    public SwkShape getLastShapeScanned() {
        return this.lastShapeScanned;
    }

    public Transformer setTransformer(String transformerName, SwkShape shape) {
        Transformer transformer = null;
        transformer = (Transformer)this.transformerHash.get(transformerName);
        if (transformer == null) {
            transformer = new Transformer(transformerName);
            this.transformerHash.put(transformerName, transformer);
        }
        if (shape != null) {
            shape.transformer = transformer;
        }
        return transformer;
    }

    public Transformer getTransformer(String name) {
        return (Transformer)this.transformerHash.get(name);
    }

    void removeTransformer(Interp interp, SwkShape shape) throws TclException {
        shape.transformer = null;
    }

    public void setZoom(double newZoom) {
        this.zoom = newZoom;
    }

    public double getZoom() {
        return this.zoom;
    }

    String getTagOrIDFromTagID(String tagID) {
        int spacePos = tagID.indexOf(" ");
        if (spacePos == -1) {
            return tagID;
        }
        return tagID.substring(0, spacePos);
    }

    public void addShape(SwkShape shape) throws SwkException {
        shape.previous = this.lastShape;
        if (this.firstShape == null) {
            this.firstShape = shape;
        }
        if (this.lastShape != null) {
            this.lastShape.next = shape;
        }
        this.lastShape = shape;
        this.swkShapes.put(new Integer(shape.id), shape);
        if (shape.tagNames != null) {
            this.setTags(shape.tagNames, shape);
        }
        this.addChild(shape.bG);
    }

    public SwkShape getShape(String arg) throws SwkException {
        SwkShape swkShape = null;
        if (arg.equals("current")) {
            if (this.eventCurrentShape != null) {
                swkShape = this.eventCurrentShape;
            } else {
                throw new SwkException("tag doesn't exist");
            }
        }
        if (swkShape == null && SwankUtil.looksLikeInt((String)arg)) {
            try {
                int iElem = Integer.parseInt(arg);
                if (iElem < 0 || iElem >= this.lastShapeId) {
                    throw new SwkException("Invalid canvas item id " + iElem + " " + this.lastShapeId);
                }
                swkShape = (SwkShape)this.swkShapes.get(new Integer(iElem));
                if (swkShape == null) {
                    throw new SwkException("Invalid canvas item id null" + iElem);
                }
            }
            catch (NumberFormatException nfeE) {
                // empty catch block
            }
        }
        if (swkShape == null) {
            Tag tag = (Tag)this.tagHash.get(arg.toString());
            if (tag == null) {
                throw new SwkException("tag doesn't exist");
            }
            if (tag.tagShapes.size() != 1) {
                throw new SwkException("more than one shape for this tag");
            }
            Enumeration e = tag.tagShapes.elements();
            swkShape = (SwkShape)e.nextElement();
        }
        return swkShape;
    }

    void unlinkShape(SwkShape swkShape) {
        if (this.firstShape == swkShape) {
            this.firstShape = swkShape.next;
        }
        if (this.lastShape == swkShape) {
            this.lastShape = swkShape.previous;
        }
        if (swkShape.previous != null) {
            swkShape.previous.next = swkShape.next;
        }
        if (swkShape.next != null) {
            swkShape.next.previous = swkShape.previous;
        }
    }

    SwkShape linkShapeAfter(SwkShape swkShape, SwkShape afterShape) {
        SwkShape nextShape = afterShape.next;
        swkShape.previous = afterShape;
        swkShape.next = nextShape;
        if (nextShape != null) {
            nextShape.previous = swkShape;
        }
        afterShape.next = swkShape;
        if (afterShape == this.lastShape) {
            this.lastShape = swkShape;
        }
        return swkShape;
    }

    void linkShapeBefore(SwkShape swkShape, SwkShape beforeShape) {
    }

    void delete(String[] tags) throws SwkException {
        Vector shapes = this.getShapesWithTags(tags);
        SwkShape swkShape = null;
        for (int i = 0; i < shapes.size(); ++i) {
            swkShape = (SwkShape)shapes.elementAt(i);
            this.swkShapes.remove(new Integer(swkShape.id));
            Enumeration e = swkShape.tags.elements();
            while (e.hasMoreElements()) {
                Tag tag = (Tag)e.nextElement();
                tag.tagShapes.remove(swkShape);
            }
            this.removeChild(swkShape.bG.iChild);
            this.unlinkShape(swkShape);
        }
    }

    void raise(String raiseTag, String afterObj) throws SwkException {
        Vector shapes = this.getShapesWithTags(raiseTag);
        SwkShape swkShape = null;
        Object nextShape = null;
        SwkShape afterShape = this.lastShape;
        if (afterObj != null) {
            afterShape = this.getShape(afterObj);
        }
        for (int i = 0; i < shapes.size(); ++i) {
            swkShape = (SwkShape)shapes.elementAt(i);
            if (swkShape == afterShape) continue;
            this.unlinkShape(swkShape);
            afterShape = this.linkShapeAfter(swkShape, afterShape);
        }
    }

    void lower(String lowerTag, String beforeObj) throws SwkException {
        Vector shapes = this.getShapesWithTags(lowerTag);
        SwkShape swkShape = null;
        SwkShape nextShape = null;
        SwkShape beforeShape = this.firstShape;
        if (beforeObj != null) {
            beforeShape = this.getShape(beforeObj);
        }
        for (int i = shapes.size() - 1; i >= 0; --i) {
            swkShape = (SwkShape)shapes.elementAt(i);
            if (swkShape == beforeShape) continue;
            if (swkShape.next != null) {
                swkShape.next.previous = swkShape.previous;
            }
            if (swkShape.previous != null) {
                swkShape.previous.next = swkShape.next;
            }
            if ((nextShape = beforeShape.previous) != null) {
                nextShape.next = swkShape;
            }
            if (beforeShape == this.firstShape) {
                this.firstShape = swkShape;
            }
            beforeShape.previous = swkShape;
            if (swkShape == this.lastShape) {
                this.lastShape = swkShape.previous;
            }
            swkShape.next = beforeShape;
            swkShape.previous = nextShape;
            beforeShape = swkShape;
        }
    }

    Rectangle2D getShapeBounds(String[] tagNames) throws SwkException {
        Rectangle2D.Double unionRect = new Rectangle2D.Double();
        boolean gotRect = false;
        if (gotRect) {
            return unionRect;
        }
        return null;
    }

    Vector getShapesWithTags(String tag) throws SwkException {
        String[] tags = new String[]{tag};
        return this.getShapesWithTags(tags, 0);
    }

    Vector getShapesWithTags(String[] tags) throws SwkException {
        return this.getShapesWithTags(tags, 0);
    }

    Vector getShapesWithTags(String[] tagList, int start) throws SwkException {
        int i;
        Vector<SwkShape> shapeList = new Vector<SwkShape>();
        Hashtable<SwkShape, SwkShape> shapeHash = new Hashtable<SwkShape, SwkShape>();
        Tag tag = null;
        for (i = start; i < tagList.length; ++i) {
            if (!tagList[i].equals("all")) continue;
            Enumeration e = this.swkShapes.elements();
            while (e.hasMoreElements()) {
                SwkShape shape = (SwkShape)e.nextElement();
                shapeList.add(shape);
            }
            return shapeList;
        }
        for (i = 0; i < tagList.length; ++i) {
            boolean intValid = true;
            if (SwankUtil.looksLikeInt((String)tagList[i])) {
                int iElem = 0;
                try {
                    iElem = Integer.parseInt(tagList[i]);
                }
                catch (NumberFormatException iE) {
                    intValid = false;
                }
                if (intValid) {
                    SwkShape swkShape = (SwkShape)this.swkShapes.get(new Integer(iElem));
                    if (swkShape == null) {
                        throw new SwkException("Invalid canvas item id (null) " + iElem);
                    }
                    shapeHash.put(swkShape, swkShape);
                }
            } else {
                intValid = false;
            }
            if (intValid) continue;
            if (tagList[i].equals("current")) {
                if (this.eventCurrentShape == null) continue;
                shapeHash.put(this.eventCurrentShape, this.eventCurrentShape);
                continue;
            }
            tag = (Tag)this.tagHash.get(tagList[i]);
            if (tag == null) continue;
            Enumeration e = tag.tagShapes.elements();
            while (e.hasMoreElements()) {
                SwkShape shape = (SwkShape)e.nextElement();
                shapeHash.put(shape, shape);
            }
        }
        Enumeration e = shapeHash.elements();
        while (e.hasMoreElements()) {
            shapeList.addElement((SwkShape)e.nextElement());
        }
        return shapeList;
    }

    public void setTags(String[] tagList, SwkShape shape) throws SwkException {
        this.setTags(tagList, true, shape);
    }

    public void addTags(String[] tagList, SwkShape shape) throws SwkException {
        this.setTags(tagList, false, shape);
    }

    public void setTags(String[] tagList, boolean clearFirst, SwkShape shape) throws SwkException {
        int i;
        Tag tag = null;
        for (i = 0; i < tagList.length; ++i) {
            if (!SwankUtil.looksLikeInt((String)tagList[i])) continue;
            throw new SwkException("tag cannot be an integer");
        }
        if (clearFirst) {
            Enumeration e = shape.tags.elements();
            while (e.hasMoreElements()) {
                tag = (Tag)e.nextElement();
                tag.tagShapes.remove(shape);
            }
            shape.tags.clear();
        }
        for (i = 0; i < tagList.length; ++i) {
            tag = (Tag)this.tagHash.get(tagList[i].toString());
            if (tag == null) {
                tag = new Tag(tagList[i]);
                this.tagHash.put(tagList[i], tag);
            }
            tag.tagShapes.put(shape, shape);
            shape.tags.put(tag, tag);
        }
    }

    void removeTags(String[] tagList, boolean clearFirst, SwkShape shape) {
        Tag tag = null;
        for (int i = 0; i < tagList.length; ++i) {
            tag = (Tag)this.tagHash.get(tagList[i]);
            if (tag == null) continue;
            tag.tagShapes.remove(shape);
            shape.tags.remove(tag);
        }
    }

    public String itemGet(Interp interp, TclObject argv, SwkShape swkshape) throws TclException {
        return "";
    }

    public ArrayList getTags(SwkShape shape) {
        Object tagString = null;
        ArrayList<String> list = new ArrayList<String>();
        Enumeration e = shape.tags.elements();
        while (e.hasMoreElements()) {
            Tag tag = (Tag)e.nextElement();
            list.add(tag.name);
        }
        return list;
    }

    public void transformMouse(MouseEvent mEvent) {
        double x = mEvent.getX();
        double y = mEvent.getY();
        this.origMouse.setLocation(x, y);
        this.transMouse.setLocation(x, y);
        try {
            this.transMouse = this.canvasTransform.inverseTransform(this.origMouse, this.transMouse);
        }
        catch (NoninvertibleTransformException ntE) {
            // empty catch block
        }
        mEvent.translatePoint((int)(this.transMouse.getX() - x), (int)(this.transMouse.getY() - y));
    }

    public TclObject[] scanCanvasForTags(double x1, double y1) {
        return null;
    }

    FontRenderContext getFontRenderContext() {
        return this.fRC;
    }

    public void setSize(Dimension newSize) {
        this.swkwidth = newSize.width;
        this.swkheight = newSize.height;
    }

    Dimension getSize() {
        return new Dimension(this.swkwidth, this.swkheight);
    }

    Color getBackground() {
        return this.component.getBackground();
    }

    void setBackground(Color background) {
        this.component.setBackground(background);
    }

    public void resetTransform() {
        Transform3D t3 = new Transform3D();
        this.objTransM.setTransform(t3);
    }

    public void setEyePosition(float x, float y, float z) {
        this.eyePosition.x = x;
        this.eyePosition.y = y;
        this.eyePosition.z = z;
        Transform3D t3 = new Transform3D();
        t3.lookAt(this.eyePosition, this.viewCenter, this.upDirection);
        t3.invert();
        TransformGroup tG = this.universe.getViewingPlatform().getViewPlatformTransform();
        tG.setTransform(t3);
    }

    public void setViewCenter(float x, float y, float z) {
        this.viewCenter.x = x;
        this.viewCenter.y = y;
        this.viewCenter.z = z;
        Transform3D t3 = new Transform3D();
        t3.lookAt(this.eyePosition, this.viewCenter, this.upDirection);
        t3.invert();
        TransformGroup tG = this.universe.getViewingPlatform().getViewPlatformTransform();
        tG.setTransform(t3);
    }

    public void setUpDirection(float x, float y, float z) {
        this.upDirection.x = x;
        this.upDirection.y = y;
        this.upDirection.z = z;
        Transform3D t3 = new Transform3D();
        t3.lookAt(this.eyePosition, this.viewCenter, this.upDirection);
        t3.invert();
        TransformGroup tG = this.universe.getViewingPlatform().getViewPlatformTransform();
        tG.setTransform(t3);
    }

    public void setCenter(float x, float y, float z) {
        this.center.x = x;
        this.center.y = y;
        this.center.z = z;
        this.centerTrans.setTranslation(this.center);
        this.objTrans.setTransform(this.centerTrans);
    }

    public Color getBackground3D() {
        this.bg.getColor(this.color3f);
        return this.color3f.get();
    }

    public void setBackground3D(Color bgColor) {
        try {
            this.bg.setColor((float)bgColor.getRed(), (float)bgColor.getGreen(), (float)bgColor.getBlue());
        }
        catch (Exception e) {
            System.out.println("e is " + e.toString());
        }
    }

    public BranchGroup createSceneGraph2() {
        BranchGroup objRoot = new BranchGroup();
        this.objTransM = new TransformGroup();
        this.objTransM.setCapability(18);
        this.objTransM.setCapability(17);
        this.objTransM.setCapability(12);
        this.objTransM.setCapability(13);
        this.objTransM.setCapability(14);
        objRoot.addChild((Node)this.objTransM);
        this.objTrans = new TransformGroup();
        this.objTrans.setCapability(18);
        this.objTrans.setCapability(17);
        this.objTrans.setCapability(12);
        this.objTrans.setCapability(13);
        this.objTrans.setCapability(14);
        this.objTransM.addChild((Node)this.objTrans);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 300.0);
        AmbientLight aL = new AmbientLight();
        aL.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)aL);
        this.bg = new Background(0.1f, 0.1f, 0.2f);
        this.bg.setCapability(17);
        this.bg.setCapability(16);
        this.bg.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)this.bg);
        Transform3D yAxis = new Transform3D();
        Alpha rotationAlpha = new Alpha(-1, 1, 0L, 0L, 4000L, 0L, 0L, 0L, 0L, 0L);
        RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, this.objTransM, yAxis, 0.0f, (float)Math.PI * 2);
        rotator.setSchedulingBounds((Bounds)bounds);
        MouseRotate myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(this.objTransM);
        myMouseRotate.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)myMouseRotate);
        MouseZoom myMouseZoom = new MouseZoom();
        myMouseZoom.setTransformGroup(this.objTransM);
        myMouseZoom.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)myMouseZoom);
        MouseTranslate myMouseTranslate = new MouseTranslate();
        myMouseTranslate.setTransformGroup(this.objTransM);
        myMouseTranslate.setSchedulingBounds((Bounds)bounds);
        objRoot.addChild((Node)myMouseTranslate);
        PointLight lgt1 = new PointLight();
        lgt1.setPosition(new Point3f(100.0f, 100.0f, 100.0f));
        lgt1.setAttenuation(new Point3f(1.0f, 0.001f, 0.0f));
        lgt1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)lgt1);
        objRoot.compile();
        return objRoot;
    }

    public void addBranchGraph(BranchGroup scene) {
        if (this.universe != null && scene != null) {
            this.universe.addBranchGraph(scene);
        }
    }

    public int addChild(NvBranchGroup bG) {
        if (this.objTrans != null && bG != null) {
            int iChild;
            this.objTrans.addChild((Node)bG);
            bG.iChild = iChild = this.objTrans.numChildren() - 1;
            return bG.id;
        }
        return -1;
    }

    public int setChild(Shape3D shape, int iChild) {
        if (iChild >= 0 && iChild < this.objTrans.numChildren() && this.objTrans != null && shape != null) {
            NvBranchGroup newBG = new NvBranchGroup();
            newBG.addChild((Node)shape);
            this.objTrans.setChild((Node)newBG, iChild);
            newBG.iChild = iChild;
            return iChild;
        }
        return -1;
    }

    public int removeChild(int iChild) {
        if (iChild >= 0 && iChild < this.objTrans.numChildren() && this.objTrans != null) {
            this.objTrans.removeChild(iChild);
            int i = 0;
            while (i < this.objTrans.numChildren()) {
                NvBranchGroup nvBG = (NvBranchGroup)this.objTrans.getChild(i);
                nvBG.iChild = i++;
            }
            return this.objTrans.numChildren();
        }
        return -1;
    }

    public int numChildren() {
        if (this.objTrans != null) {
            return this.objTrans.numChildren();
        }
        return -1;
    }

    public int addSpheres(float[] coords, float[] colors, float[] radii) {
        Transform3D t3D = new Transform3D();
        Vector3d v3d = new Vector3d();
        int nSpheres = coords.length / 3;
        Color white = Color.WHITE;
        NvBranchGroup bG = new NvBranchGroup();
        for (int i = 0; i < nSpheres; ++i) {
            Appearance ap = new Appearance();
            v3d.x = coords[i * 3];
            v3d.y = coords[i * 3 + 1];
            v3d.z = coords[i * 3 + 2];
            t3D.setTranslation(v3d);
            TransformGroup tG = new TransformGroup(t3D);
            Sphere sphere = new Sphere(radii[i]);
            Material material = new Material();
            material.setAmbientColor(colors[i * 3], colors[i * 3 + 1], colors[i * 3 + 2]);
            material.setEmissiveColor(1.0f, 1.0f, 1.0f);
            material.setDiffuseColor(colors[i * 3], colors[i * 3 + 1], colors[i * 3 + 2]);
            material.setSpecularColor(1.0f, 1.0f, 1.0f);
            material.setShininess(30.0f);
            ap.setMaterial(material);
            ColoringAttributes colorAttr = new ColoringAttributes(colors[i * 3], colors[i * 3 + 1], colors[i * 3 + 2], 1);
            ap.setColoringAttributes(colorAttr);
            sphere.setAppearance(ap);
            tG.addChild((Node)sphere);
            bG.addChild((Node)tG);
        }
        bG.setCapability(17);
        bG.compile();
        return this.addChild(bG);
    }

    public int addLines2(float[] coords, float[] colors, int start, int nElem) {
        int nVertices = nElem / 3;
        LineArray lineArray = new LineArray(nVertices, 5);
        lineArray.setCoordinates(start, coords);
        lineArray.setColors(start, colors);
        Shape3D shape = new Shape3D((Geometry)lineArray);
        if (this.objTrans != null && shape != null) {
            NvBranchGroup newBG = new NvBranchGroup();
            TransformGroup localTrans = new TransformGroup();
            localTrans.addChild((Node)shape);
            newBG.addChild((Node)localTrans);
            return this.addChild(newBG);
        }
        return -1;
    }

    public void repaint() {
        final Component component2 = this.component;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (component2 != null) {
                    component2.repaint();
                }
            }
        });
    }

    public void repaint(int delay) {
        final Component component2 = this.component;
        final int delay2 = delay;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (component2 != null) {
                    component2.repaint(delay2);
                }
            }
        });
    }

    public void paint(int width, int height, String fileName) {
        this.swkwidth = width;
        this.swkheight = height;
        BufferedImage bufferedImage = new BufferedImage(this.swkwidth, this.swkheight, 1);
        Graphics offgraphics = bufferedImage.getGraphics();
        this.paintComponent(offgraphics);
        offgraphics.dispose();
        if (fileName != null) {
            this.writeImage(bufferedImage, fileName);
        }
    }

    public void writeImage(BufferedImage rendImage, String fileName) {
        try {
            File file = new File(fileName);
            ImageIO.write((RenderedImage)rendImage, "png", file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void paintComponent(Graphics g) {
    }

    public void setClassName(String className) {
        this.className = className.intern();
    }

    public String getClassName() {
        return this.className;
    }

    public void close() throws TclException {
    }

    class Tag {
        int id = -1;
        String name = null;
        Hashtable tagShapes = new Hashtable();

        Tag(String name) {
            this.name = name.intern();
            SwkImageCanvas.this.tagVec.addElement(this);
            this.id = SwkImageCanvas.this.tagVec.size() - 1;
        }
    }
}

