/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.HashMap;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.LappendCmd;
import tcl.lang.LindexCmd;
import tcl.lang.Namespace;
import tcl.lang.Parser;
import tcl.lang.ProcCmd;
import tcl.lang.SwitchCmd;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Util;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

public class TJC {
    public static final int SWITCH_MODE_EXACT = 0;
    public static final int SWITCH_MODE_GLOB = 1;
    public static final int SWITCH_MODE_REGEXP = 2;
    public static final int EXPR_OP_MULT = 8;
    public static final int EXPR_OP_DIVIDE = 9;
    public static final int EXPR_OP_MOD = 10;
    public static final int EXPR_OP_PLUS = 11;
    public static final int EXPR_OP_MINUS = 12;
    public static final int EXPR_OP_LEFT_SHIFT = 13;
    public static final int EXPR_OP_RIGHT_SHIFT = 14;
    public static final int EXPR_OP_LESS = 15;
    public static final int EXPR_OP_GREATER = 16;
    public static final int EXPR_OP_LEQ = 17;
    public static final int EXPR_OP_GEQ = 18;
    public static final int EXPR_OP_EQUAL = 19;
    public static final int EXPR_OP_NEQ = 20;
    public static final int EXPR_OP_BIT_AND = 21;
    public static final int EXPR_OP_BIT_XOR = 22;
    public static final int EXPR_OP_BIT_OR = 23;
    public static final int EXPR_OP_STREQ = 28;
    public static final int EXPR_OP_STRNEQ = 29;
    public static final int EXPR_OP_UNARY_MINUS = 30;
    public static final int EXPR_OP_UNARY_PLUS = 31;
    public static final int EXPR_OP_UNARY_NOT = 32;
    public static final int EXPR_OP_UNARY_BIT_NOT = 33;
    public static final WrappedCommand INVALID_COMMAND_CACHE = new WrappedCommand();
    private static final boolean USE_OBJV_CACHE = true;
    private static final boolean USE_EXPR_CACHE = true;

    public static CallFrame pushLocalCallFrame(Interp interp, Namespace ns) {
        CallFrame frame = interp.newCallFrame();
        if (ns != null) {
            frame.ns = ns;
        }
        if (!frame.isProcCallFrame) {
            throw new TclRuntimeError("expected isProcCallFrame to be true");
        }
        frame.level = interp.varFrame == null ? 1 : interp.varFrame.level + 1;
        frame.caller = interp.frame;
        frame.callerVar = interp.varFrame;
        interp.frame = frame;
        interp.varFrame = frame;
        return frame;
    }

    public static void popLocalCallFrame(Interp interp, CallFrame frame) {
        if (interp.errInProgress) {
            frame.dispose();
            interp.errInProgress = true;
        } else {
            frame.dispose();
        }
    }

    public static Var[] initCompiledLocals(CallFrame frame, int size, String[] names) {
        frame.compiledLocalsNames = names;
        frame.compiledLocals = new Var[size];
        return frame.compiledLocals;
    }

    public static void evalProcBody(Interp interp, String body) throws TclException {
        interp.eval(body);
    }

    public static void checkTclException(Interp interp, TclException e, String procName) throws TclException {
        int code = e.getCompletionCode();
        if (code == 2) {
            int realCode = interp.updateReturnInfo();
            if (realCode != 0) {
                e.setCompletionCode(realCode);
                throw e;
            }
        } else {
            if (code == 1) {
                interp.addErrorInfo("\n    (procedure \"" + procName + "\" line 1)");
                throw e;
            }
            if (code == 3) {
                throw new TclException(interp, "invoked \"break\" outside of a loop");
            }
            if (code == 4) {
                throw new TclException(interp, "invoked \"continue\" outside of a loop");
            }
            throw e;
        }
    }

    public static void createCommand(Interp interp, String cmdName, CompiledCommand cmd) throws TclException {
        ProcCmd.FindCommandNamespaceResult result = ProcCmd.FindCommandNamespace((Interp)interp, (String)cmdName);
        interp.createCommand(result.cmdFullName, (Command)cmd);
        cmd.wcmd = Namespace.findCommand((Interp)interp, (String)result.cmdName, (Namespace)result.ns, (int)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sourceInitFile(Interp interp, String init_file, String[] files, String prefix) throws TclException {
        interp.eval("package require TJC");
        interp.eval("rename ::source ::TJC::source");
        interp.createCommand("::source", (Command)new InitSourceCmd(init_file, files, prefix));
        TclException tex = null;
        try {
            try {
                interp.evalResource(prefix + init_file);
            }
            catch (TclException ex) {
                tex = ex;
                Object var7_6 = null;
                interp.eval("rename ::source {}");
                interp.eval("rename ::TJC::source ::source");
                if (tex == null) return;
                interp.setResult(tex.getMessage());
                throw tex;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            interp.eval("rename ::source {}");
            interp.eval("rename ::TJC::source ::source");
            if (tex == null) throw throwable;
            interp.setResult(tex.getMessage());
            throw tex;
        }
        interp.eval("rename ::source {}");
        interp.eval("rename ::TJC::source ::source");
        if (tex == null) return;
        interp.setResult(tex.getMessage());
        throw tex;
    }

    public static WrappedCommand resolveCmd(Interp interp, String cmdName) throws TclException {
        return Namespace.findCommand((Interp)interp, (String)cmdName, null, (int)0);
    }

    static final void setVarScalar(Var var, TclObject newValue) {
        TclObject oldValue = var.tobj;
        if (oldValue != newValue) {
            var.tobj = newValue;
            newValue.preserve();
            if (oldValue != null) {
                oldValue.release();
            }
        }
    }

    public static final TclObject incrVar(Interp interp, String part1, String part2, int incrAmount) throws TclException {
        return Var.incrVar((Interp)interp, (String)part1, (String)part2, (int)incrAmount, (int)512);
    }

    public static TclObject[] grabObjv(Interp interp, int size) {
        return Parser.grabObjv((Interp)interp, (int)size);
    }

    public static void releaseObjv(Interp interp, TclObject[] objv, int size) {
        Parser.releaseObjv((Interp)interp, (TclObject[])objv, (int)size);
    }

    public static void releaseObjvElems(Interp interp, TclObject[] objv, int size) {
        for (int i = 0; i < size; ++i) {
            TclObject tobj = objv[i];
            if (tobj == null) continue;
            tobj.release();
        }
        Parser.releaseObjv((Interp)interp, (TclObject[])objv, (int)size);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void invoke(Interp interp, Command cmd, TclObject[] objv, int flags) throws TclException {
        CallFrame savedVarFrame;
        block18: {
            boolean grabbed_objv = false;
            savedVarFrame = interp.varFrame;
            if (cmd == null) {
                String cmdName;
                WrappedCommand wcmd;
                int fflags = 0;
                if ((flags & 0x20000) != 0) {
                    fflags |= 1;
                }
                if ((wcmd = Namespace.findCommand((Interp)interp, (String)(cmdName = objv[0].toString()), null, (int)fflags)) != null) {
                    cmd = wcmd.cmd;
                }
                if (cmd == null) {
                    wcmd = Namespace.findCommand((Interp)interp, (String)"unknown", null, (int)1);
                    if (wcmd != null) {
                        cmd = wcmd.cmd;
                    }
                    if (cmd == null) {
                        throw new TclException(interp, "invalid command name \"" + cmdName + "\"");
                    }
                    int len = objv.length;
                    if (len == 0) {
                        throw new TclRuntimeError("zero length objv array");
                    }
                    TclObject[] newObjv = TJC.grabObjv(interp, len + 1);
                    newObjv[0] = TclString.newInstance((String)"unknown");
                    newObjv[0].preserve();
                    for (int i = len - 1; i >= 0; --i) {
                        newObjv[i + 1] = objv[i];
                    }
                    objv = newObjv;
                    grabbed_objv = true;
                }
            }
            try {
                try {
                    interp.preserve();
                    interp.allowExceptions();
                    interp.ready();
                    ++interp.nestLevel;
                    ++interp.cmdCount;
                    if ((flags & 0x20000) != 0) {
                        interp.varFrame = null;
                    }
                    cmd.cmdProc(interp, objv);
                }
                catch (TclException ex) {
                    if (ex.getCompletionCode() != 1) throw ex;
                    if (interp.errAlreadyLogged) throw ex;
                    StringBuffer cmd_strbuf = new StringBuffer(64);
                    int len = objv.length;
                    if (len == 0) {
                        throw new TclRuntimeError("zero length objv array");
                    }
                    int i = 0;
                    while (true) {
                        if (i >= len) {
                            String cmd_str = cmd_strbuf.toString();
                            char[] script_array = cmd_str.toCharArray();
                            int script_index = 0;
                            int command_start = 0;
                            int command_length = cmd_str.length();
                            Parser.logCommandInfo((Interp)interp, (char[])script_array, (int)script_index, (int)command_start, (int)command_length, (TclException)ex);
                            throw ex;
                        }
                        Util.appendElement((Interp)interp, (StringBuffer)cmd_strbuf, (String)objv[i].toString());
                        ++i;
                    }
                }
                Object var15_16 = null;
                if (!grabbed_objv) break block18;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (grabbed_objv) {
                    objv[0].release();
                    TJC.releaseObjv(interp, objv, objv.length);
                }
                --interp.nestLevel;
                interp.varFrame = savedVarFrame;
                interp.release();
                interp.checkInterrupted();
                throw throwable;
            }
            objv[0].release();
            TJC.releaseObjv(interp, objv, objv.length);
        }
        --interp.nestLevel;
        interp.varFrame = savedVarFrame;
        interp.release();
        interp.checkInterrupted();
    }

    public static boolean getBoolean(Interp interp, TclObject obj) throws TclException {
        if (obj.isIntType()) {
            return obj.ivalue != 0;
        }
        if (obj.isDoubleType()) {
            return TJC.exprGetKnownDouble(obj) != 0.0;
        }
        ExprValue value = interp.expr.grabExprValue();
        Expression.ExprParseString((Interp)interp, (TclObject)obj, (ExprValue)value);
        boolean b = value.getBooleanValue(interp);
        interp.expr.releaseExprValue(value);
        return b;
    }

    public static int invokeSwitch(Interp interp, TclObject[] pbObjv, int pbStart, String string, int mode) throws TclException {
        int offset = SwitchCmd.getBodyOffset((Interp)interp, (TclObject[])pbObjv, (int)pbStart, (String)string, (int)mode);
        return offset;
    }

    public static void switchStringIsNotOption(Interp interp, String str) throws TclException {
        if (str.startsWith("-")) {
            TclObject[] objv = new TclObject[]{TclString.newInstance((String)"switch")};
            throw new TclNumArgsException(interp, 1, objv, "?switches? string pattern body ... ?default body?");
        }
    }

    public static void catchVarErr(Interp interp) throws TclException {
        throw new TclException(interp, "couldn't save command result in variable");
    }

    public static void foreachVarErr(Interp interp, String varname) throws TclException {
        throw new TclException(interp, "couldn't set loop variable: \"" + varname + "\"");
    }

    public static void exprReleaseValue(Interp interp, ExprValue value) {
        interp.expr.releaseExprValue(value);
    }

    public static ExprValue exprGetValue(Interp interp, int ival, String srep) throws TclException {
        ExprValue value = interp.expr.grabExprValue();
        value.setIntValue(ival, srep);
        return value;
    }

    public static ExprValue exprGetValue(Interp interp, double dval, String srep) throws TclException {
        ExprValue value = interp.expr.grabExprValue();
        value.setDoubleValue(dval, srep);
        return value;
    }

    public static ExprValue exprGetValue(Interp interp, String srep) throws TclException {
        ExprValue value = interp.expr.grabExprValue();
        value.setStringValue(srep);
        return value;
    }

    public static ExprValue exprGetValue(Interp interp, boolean bval) throws TclException {
        ExprValue value = interp.expr.grabExprValue();
        value.setIntValue(bval);
        return value;
    }

    public static ExprValue exprGetValue(Interp interp, TclObject tobj) throws TclException {
        ExprValue value = interp.expr.grabExprValue();
        Expression.ExprParseObject((Interp)interp, (TclObject)tobj, (ExprValue)value);
        return value;
    }

    public static void exprInitValue(Interp interp, ExprValue value, TclObject tobj) throws TclException {
        Expression.ExprParseObject((Interp)interp, (TclObject)tobj, (ExprValue)value);
    }

    public static ExprValue exprGetValue(Interp interp) {
        return interp.expr.grabExprValue();
    }

    public static int exprGetKnownInt(TclObject tobj) {
        return tobj.ivalue;
    }

    public static double exprGetKnownDouble(TclObject tobj) {
        return ((TclDouble)tobj.getInternalRep()).value;
    }

    public static void exprUnaryOperator(Interp interp, int op, ExprValue value) throws TclException {
        Expression.evalUnaryOperator((Interp)interp, (int)op, (ExprValue)value);
    }

    public static void exprBinaryOperator(Interp interp, int op, ExprValue value, ExprValue value2) throws TclException {
        Expression.evalBinaryOperator((Interp)interp, (int)op, (ExprValue)value, (ExprValue)value2);
    }

    public static void exprMathFunction(Interp interp, String funcName, ExprValue[] values, ExprValue result) throws TclException {
        interp.expr.evalMathFunction(interp, funcName, values, false, result);
    }

    public static void exprSetResult(Interp interp, ExprValue value) throws TclException {
        switch (value.getType()) {
            case 0: {
                interp.setResult(value.getIntValue());
                break;
            }
            case 1: {
                interp.setResult(value.getDoubleValue());
                break;
            }
            case 2: {
                interp.setResult(value.getStringValue());
                break;
            }
            default: {
                throw new TclRuntimeError("internal error: expression, unknown");
            }
        }
    }

    public static void exprEqualsEmptyString(ExprValue value, TclObject obj, boolean negate) throws TclException {
        boolean isEmptyString;
        if (obj.hasNoStringRep() && obj.isListType()) {
            isEmptyString = TclList.getLength(null, (TclObject)obj) == 0;
        } else {
            String s = obj.toString();
            boolean bl = isEmptyString = s == "" || s.length() == 0;
        }
        if (negate) {
            isEmptyString = !isEmptyString;
        }
        value.setIntValue(isEmptyString);
    }

    public static void exprIntMathFunction(Interp interp, ExprValue value) throws TclException {
        switch (value.getType()) {
            case 0: {
                break;
            }
            case 1: {
                double d = value.getDoubleValue();
                if (d < 0.0 && d < -2.147483648E9 || d > 0.0 && d > 2.147483647E9) {
                    Expression.IntegerTooLarge((Interp)interp);
                }
                value.setIntValue((int)d);
                break;
            }
            case 2: {
                throw new TclException(interp, "argument to math function didn't have numeric value");
            }
        }
    }

    public static void exprDoubleMathFunction(Interp interp, ExprValue value) throws TclException {
        if (value.isStringType()) {
            throw new TclException(interp, "argument to math function didn't have numeric value");
        }
        if (value.isIntType()) {
            value.setDoubleValue((double)value.getIntValue());
        }
    }

    public static void exprUnaryNotOperator(Interp interp, ExprValue value) throws TclException {
        if (value.isDoubleType()) {
            value.setIntValue(value.getDoubleValue() == 0.0);
        } else {
            Expression.evalUnaryOperator((Interp)interp, (int)32, (ExprValue)value);
        }
    }

    public static void exprUnaryNotOperator(Interp interp, ExprValue value, TclObject tobj) throws TclException {
        if (tobj.isDoubleType()) {
            value.setIntValue(TJC.exprGetKnownDouble(tobj) == 0.0);
            return;
        }
        Expression.ExprParseString((Interp)interp, (TclObject)tobj, (ExprValue)value);
        if (value.isIntType()) {
            value.optIntUnaryNot();
        } else if (value.isDoubleType()) {
            value.setIntValue(value.getDoubleValue() == 0.0);
        } else {
            Expression.evalUnaryOperator((Interp)interp, (int)32, (ExprValue)value);
        }
    }

    public static void exprUnaryNotOperatorKnownInt(ExprValue value, TclObject tobj) {
        value.setIntValue(tobj.ivalue == 0);
    }

    public static int exprUnaryNotOperatorKnownInt(TclObject tobj) {
        return tobj.ivalue == 0 ? 1 : 0;
    }

    public static boolean exprUnaryNotOperatorKnownIntAsBoolean(TclObject tobj) {
        return tobj.ivalue == 0;
    }

    public static final void makeGlobalLinkVar(Interp interp, String varName, String varTail, int localIndex) throws TclException {
        Var.makeUpvar((Interp)interp, null, (String)varName, null, (int)1, (String)varTail, (int)0, (int)localIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void lindexNonconst(Interp interp, TclObject listObj, TclObject indexValue) throws TclException {
        if (indexValue.isIntType()) {
            TclObject result = TclList.index((Interp)interp, (TclObject)listObj, (int)indexValue.ivalue);
            if (result == null) {
                interp.resetResult();
            } else {
                interp.setResult(result);
            }
            return;
        }
        TclObject[] objv = TJC.grabObjv(interp, 3);
        try {
            objv[1] = listObj;
            objv[2] = indexValue;
            indexValue.preserve();
            TclObject elem = LindexCmd.TclLindexList((Interp)interp, (TclObject)listObj, (TclObject[])objv, (int)2);
            interp.setResult(elem);
            elem.release();
        }
        finally {
            objv[2].release();
            TJC.releaseObjv(interp, objv, 3);
        }
    }

    public static final TclObject lappendVar(Interp interp, String varName, String key, TclObject[] values) throws TclException {
        if (key == null) {
            return LappendCmd.lappendVar((Interp)interp, (String)varName, (TclObject[])values, (int)0);
        }
        String avName = varName + "(" + key + ")";
        return LappendCmd.lappendVar((Interp)interp, (String)avName, (TclObject[])values, (int)0);
    }

    public static final TclObject appendVar(Interp interp, String varName, String key, TclObject[] values) throws TclException {
        TclObject varValue = null;
        int len = values.length;
        if (key != null) {
            varName = varName + "(" + key + ")";
        }
        for (int i = 0; i < len; ++i) {
            varValue = interp.setVar(varName, values[i], 4);
        }
        if (varValue == null) {
            varValue = interp.checkCommonString(null);
        }
        return varValue;
    }

    public static final TclObject stringIndex(Interp interp, String str, TclObject indObj) throws TclException {
        int len = str.length();
        int i = indObj.isIntType() ? indObj.ivalue : Util.getIntForIndex((Interp)interp, (TclObject)indObj, (int)(len - 1));
        if (i >= 0 && i < len) {
            TclObject obj = interp.checkCommonCharacter((int)str.charAt(i));
            if (obj == null) {
                obj = TclString.newInstance((String)str.substring(i, i + 1));
            }
            return obj;
        }
        return interp.checkCommonString(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TclObject stringRange(Interp interp, String str, TclObject firstObj, TclObject lastObj) throws TclException {
        int last;
        int first;
        int len = str.length();
        try {
            first = firstObj.isIntType() ? firstObj.ivalue : Util.getIntForIndex((Interp)interp, (TclObject)firstObj, (int)(len - 1));
            if (first < 0) {
                first = 0;
            }
            if ((last = lastObj.isIntType() ? lastObj.ivalue : Util.getIntForIndex((Interp)interp, (TclObject)lastObj, (int)(len - 1))) >= len) {
                last = len - 1;
            }
        }
        finally {
            firstObj.release();
        }
        if (first > last) {
            return interp.checkCommonString(null);
        }
        String substr = str.substring(first, last + 1);
        return TclString.newInstance((String)substr);
    }

    public static final TclObject stringFirst(Interp interp, String substr, String str, TclObject startObj) throws TclException {
        int index;
        int start;
        int substrLen = substr.length();
        int strLen = str.length();
        if (startObj == null) {
            start = 0;
        } else {
            start = Util.getIntForIndex((Interp)interp, (TclObject)startObj, (int)(strLen - 1));
            if (start >= strLen) {
                return interp.checkCommonInteger(-1);
            }
        }
        if (substrLen == 0) {
            index = -1;
        } else if (substrLen == 1) {
            char c = substr.charAt(0);
            index = str.indexOf(c, start);
        } else {
            index = str.indexOf(substr, start);
        }
        return interp.checkCommonInteger(index);
    }

    public static final TclObject stringLast(Interp interp, String substr, String str, TclObject lastObj) throws TclException {
        int index;
        int substrLen = substr.length();
        int strLen = str.length();
        if (lastObj == null) {
            boolean last = false;
        } else {
            int last = Util.getIntForIndex((Interp)interp, (TclObject)lastObj, (int)(strLen - 1));
            if (last < 0) {
                return interp.checkCommonInteger(-1);
            }
            if (last < strLen) {
                str = str.substring(0, last + 1);
            }
        }
        if (substrLen == 0) {
            index = -1;
        } else if (substrLen == 1) {
            char c = substr.charAt(0);
            index = str.lastIndexOf(c);
        } else {
            index = str.lastIndexOf(substr);
        }
        return interp.checkCommonInteger(index);
    }

    static {
        TJC.INVALID_COMMAND_CACHE.deleted = true;
        TJC.INVALID_COMMAND_CACHE.cmdEpoch = -1;
    }

    static class InitSourceCmd
    implements Command {
        String init_file;
        String[] files;
        String prefix;
        HashMap filesTable;

        InitSourceCmd(String init_file, String[] files, String prefix) {
            this.init_file = init_file;
            this.files = files;
            this.prefix = prefix;
            this.filesTable = new HashMap();
            for (int i = 0; i < files.length; ++i) {
                this.filesTable.put(files[i], "");
            }
        }

        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            boolean handled = false;
            if (objv.length == 2) {
                String filepath = objv[1].toString();
                interp.eval("file tail {" + filepath + "}");
                String filename = interp.getResult().toString();
                if (this.filesTable.containsKey(filename)) {
                    handled = true;
                    interp.evalResource(this.prefix + filename);
                }
            }
            if (!handled) {
                Command cmd = interp.getCommand("TJC::source");
                cmd.cmdProc(interp, objv);
            }
        }
    }

    public static abstract class CompiledCommand
    implements Command {
        public WrappedCommand wcmd = null;
        protected boolean inlineCmds = false;
        protected boolean initCmd = false;

        protected void initCmd(Interp interp) throws TclException {
            if (this.initCmd) {
                throw new TclRuntimeError("initCmd already invoked");
            }
            this.builtinCommandsCheck(interp);
            this.initConstants(interp);
            this.initCmd = true;
        }

        protected void initConstants(Interp interp) throws TclException {
        }

        protected void builtinCommandsCheck(Interp interp) throws TclException {
            if (this.wcmd.ns.fullName.equals("::")) {
                return;
            }
            String[] containers = new String[]{"break", "catch", "continue", "expr", "for", "foreach", "if", "return", "switch", "while"};
            String[] containers_and_inlines = new String[]{"break", "catch", "continue", "expr", "for", "foreach", "global", "if", "list", "llength", "return", "set", "switch", "while"};
            String[] builtin = this.inlineCmds ? containers_and_inlines : containers;
            for (int i = 0; i < builtin.length; ++i) {
                String cmdName = builtin[i];
                WrappedCommand cmd = Namespace.findCommand((Interp)interp, (String)cmdName, (Namespace)this.wcmd.ns, (int)2);
                if (cmd == null) continue;
                throw new TclException(interp, "TJC compiled command can't be loaded into the namespace " + this.wcmd.ns.fullName + " as it defines the builtin Tcl command \"" + cmdName + "\" (" + cmd.toString() + ")");
            }
        }

        protected final void initVarScoped(Interp interp, String varname, Var[] compiledLocals, int localIndex) throws TclException {
            if (compiledLocals[localIndex] == null) {
                Var.makeUpvar((Interp)interp, null, (String)varname, null, (int)1, (String)varname, (int)4096, (int)localIndex);
            }
        }

        protected final TclObject getVarScalar(Interp interp, String varname, Var[] compiledLocals, int localIndex) throws TclException {
            Var var = compiledLocals[localIndex];
            if (var == null || (var = Var.resolveScalar((Var)var)) == null) {
                return Var.getVarCompiledLocalScalarInvalid((Interp)interp, (String)varname);
            }
            return var.tobj;
        }

        protected final TclObject getVarArray(Interp interp, String varname, String key, Var[] compiledLocals, int localIndex) throws TclException {
            Var var = compiledLocals[localIndex];
            if (var == null || (var = Var.resolveArray((Var)var)) == null) {
                return Var.getVarCompiledLocalArrayInvalid((Interp)interp, (String)varname, (String)key);
            }
            return Var.getVarCompiledLocalArray((Interp)interp, (String)varname, (String)key, (Var)var, (boolean)true);
        }

        protected final TclObject setVarScalar(Interp interp, String varname, TclObject value, Var[] compiledLocals, int localIndex) throws TclException {
            Var var = compiledLocals[localIndex];
            if (var == null) {
                return Var.initVarCompiledLocalScalar((Interp)interp, (String)varname, (TclObject)value, (Var[])compiledLocals, (int)localIndex);
            }
            if ((var = Var.resolveScalar((Var)var)) == null) {
                return Var.setVarCompiledLocalScalarInvalid((Interp)interp, (String)varname, (TclObject)value);
            }
            TJC.setVarScalar(var, value);
            return value;
        }

        protected final TclObject setVarScalar(Interp interp, String varname, String value, Var[] compiledLocals, int localIndex) throws TclException {
            TclObject tobj = interp.checkCommonString(value);
            return this.setVarScalar(interp, varname, tobj, compiledLocals, localIndex);
        }

        protected final TclObject setVarArray(Interp interp, String varname, String key, TclObject value, Var[] compiledLocals, int localIndex) throws TclException {
            Var var = compiledLocals[localIndex];
            if (var == null) {
                return Var.initVarCompiledLocalArray((Interp)interp, (String)varname, (String)key, (TclObject)value, (Var[])compiledLocals, (int)localIndex);
            }
            if ((var = Var.resolveArray((Var)var)) == null) {
                return Var.setVarCompiledLocalArrayInvalid((Interp)interp, (String)varname, (String)key, (TclObject)value);
            }
            return Var.setVarCompiledLocalArray((Interp)interp, (String)varname, (String)key, (TclObject)value, (Var)var);
        }

        protected final TclObject setVarArray(Interp interp, String varname, String key, String value, Var[] compiledLocals, int localIndex) throws TclException {
            TclObject tobj = interp.checkCommonString(value);
            return this.setVarArray(interp, varname, key, tobj, compiledLocals, localIndex);
        }

        protected final TclObject incrVarScalar(Interp interp, String varname, int incrAmount, Var[] compiledLocals, int localIndex) throws TclException {
            Var var = compiledLocals[localIndex];
            if (var == null || (var = Var.resolveScalar((Var)var)) == null) {
                return TJC.incrVar(interp, varname, null, incrAmount);
            }
            TclObject varValue = var.tobj;
            boolean createdNewObj = false;
            if (varValue.isShared()) {
                varValue = varValue.duplicate();
                createdNewObj = true;
            }
            try {
                TclInteger.incr((Interp)interp, (TclObject)varValue, (int)incrAmount);
            }
            catch (TclException ex) {
                if (createdNewObj) {
                    varValue.release();
                }
                throw ex;
            }
            if (createdNewObj) {
                TJC.setVarScalar(var, varValue);
            }
            return varValue;
        }

        protected final TclObject incrVarArray(Interp interp, String varname, String key, int incrAmount, Var[] compiledLocals, int localIndex) throws TclException {
            Var var = compiledLocals[localIndex];
            if (var == null || (var = Var.resolveArray((Var)var)) == null) {
                return TJC.incrVar(interp, varname, key, incrAmount);
            }
            TclObject varValue = Var.getVarCompiledLocalArray((Interp)interp, (String)varname, (String)key, (Var)var, (boolean)true);
            boolean createdNewObj = false;
            if (varValue.isShared()) {
                varValue = varValue.duplicate();
                createdNewObj = true;
            }
            try {
                TclInteger.incr((Interp)interp, (TclObject)varValue, (int)incrAmount);
            }
            catch (TclException ex) {
                if (createdNewObj) {
                    varValue.release();
                }
                throw ex;
            }
            return Var.setVarCompiledLocalArray((Interp)interp, (String)varname, (String)key, (TclObject)varValue, (Var)var);
        }

        protected final TclObject lappendVarScalar(Interp interp, String varname, TclObject[] values, Var[] compiledLocals, int localIndex) throws TclException {
            int len;
            Var var = compiledLocals[localIndex];
            if (var == null || (var = Var.resolveScalar((Var)var)) == null) {
                return TJC.lappendVar(interp, varname, null, values);
            }
            TclObject varValue = var.tobj;
            boolean createdNewObj = false;
            if (varValue.isShared()) {
                varValue = varValue.duplicate();
                createdNewObj = true;
            }
            if ((len = values.length) == 1) {
                TclList.append((Interp)interp, (TclObject)varValue, (TclObject)values[0]);
            } else {
                TclList.append((Interp)interp, (TclObject)varValue, (TclObject[])values, (int)0, (int)len);
            }
            if (createdNewObj) {
                TJC.setVarScalar(var, varValue);
            }
            return varValue;
        }

        protected final TclObject lappendVarArray(Interp interp, String varname, String key, TclObject[] values, Var[] compiledLocals, int localIndex) throws TclException {
            Var var = compiledLocals[localIndex];
            if (var == null || (var = Var.resolveArray((Var)var)) == null) {
                return TJC.lappendVar(interp, varname, key, values);
            }
            TclObject varValue = Var.getVarCompiledLocalArray((Interp)interp, (String)varname, (String)key, (Var)var, (boolean)false);
            if (varValue == null) {
                varValue = TclList.newInstance();
            } else if (varValue.isShared()) {
                varValue = varValue.duplicate();
            }
            int len = values.length;
            if (len == 1) {
                TclList.append((Interp)interp, (TclObject)varValue, (TclObject)values[0]);
            } else {
                TclList.append((Interp)interp, (TclObject)varValue, (TclObject[])values, (int)0, (int)len);
            }
            return Var.setVarCompiledLocalArray((Interp)interp, (String)varname, (String)key, (TclObject)varValue, (Var)var);
        }

        protected final TclObject appendVarScalar(Interp interp, String varname, TclObject[] values, Var[] compiledLocals, int localIndex) throws TclException {
            int len;
            Var var = compiledLocals[localIndex];
            if (var == null || (var = Var.resolveScalar((Var)var)) == null) {
                return TJC.appendVar(interp, varname, null, values);
            }
            TclObject varValue = var.tobj;
            boolean createdNewObj = false;
            if (varValue.isShared()) {
                varValue = TclString.newInstance((String)varValue.toString());
                createdNewObj = true;
            }
            if ((len = values.length) == 1) {
                TclString.append((TclObject)varValue, (String)values[0].toString());
            } else {
                TclString.append((TclObject)varValue, (TclObject[])values, (int)0, (int)len);
            }
            if (createdNewObj) {
                TJC.setVarScalar(var, varValue);
            }
            return varValue;
        }

        protected final TclObject appendVarArray(Interp interp, String varname, String key, TclObject[] values, Var[] compiledLocals, int localIndex) throws TclException {
            return TJC.appendVar(interp, varname, key, values);
        }
    }
}

