/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TJC;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class TJCBench
extends TJC.CompiledCommand {
    static int RESULT_INT = 0;
    static Object RESULT_OBJ = null;

    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, "testname");
        }
        String testname = objv[1].toString();
        if (testname.equals("InternalTclObjectPreserve")) {
            this.InternalTclObjectPreserve(interp);
        } else if (testname.equals("InternalTclObjectPreserveRelease")) {
            this.InternalTclObjectPreserveRelease(interp);
        } else if (testname.equals("InternalExprParseIntValue")) {
            this.InternalExprParseIntValue(interp);
        } else if (testname.equals("InternalExprParseDoubleValue")) {
            this.InternalExprParseDoubleValue(interp);
        } else if (testname.equals("InternalExprGetBooleanInt")) {
            this.InternalExprGetBooleanInt(interp);
        } else if (testname.equals("InternalExprGetBooleanDouble")) {
            this.InternalExprGetBooleanDouble(interp);
        } else if (testname.equals("InternalExprGetBooleanString")) {
            this.InternalExprGetBooleanString(interp);
        } else if (testname.equals("InternalIncr")) {
            this.InternalIncr(interp);
        } else if (testname.equals("InternalTclListAppend")) {
            this.InternalTclListAppend(interp);
        } else if (testname.equals("InternalTclListLength")) {
            this.InternalTclListLength(interp);
        } else if (testname.equals("InternalTclListLindex")) {
            this.InternalTclListLindex(interp);
        } else if (testname.equals("InternalTclStringNewInstance")) {
            this.InternalTclStringNewInstance(interp);
        } else if (testname.equals("InternalTclIntegerNewInstance")) {
            this.InternalTclIntegerNewInstance(interp);
        } else if (testname.equals("InternalTclDoubleNewInstance")) {
            this.InternalTclDoubleNewInstance(interp);
        } else if (testname.equals("InternalTclListNewInstance")) {
            this.InternalTclListNewInstance(interp);
        } else if (testname.equals("InternalTclStringDuplicate")) {
            this.InternalTclStringDuplicate(interp);
        } else if (testname.equals("InternalTclIntegerDuplicate")) {
            this.InternalTclIntegerDuplicate(interp);
        } else if (testname.equals("InternalTclDoubleDuplicate")) {
            this.InternalTclDoubleDuplicate(interp);
        } else if (testname.equals("InternalTclListDuplicate")) {
            this.InternalTclListDuplicate(interp);
        } else if (testname.equals("InternalTclIntegerType")) {
            this.InternalTclIntegerType(interp);
        } else if (testname.equals("InternalTclDoubleType")) {
            this.InternalTclDoubleType(interp);
        } else if (testname.equals("InternalTclStringType")) {
            this.InternalTclStringType(interp);
        } else if (testname.equals("InternalTclListType")) {
            this.InternalTclListType(interp);
        } else if (testname.equals("InternalTclIntegerGet")) {
            this.InternalTclIntegerGet(interp);
        } else if (testname.equals("InternalExprGetKnownInt")) {
            this.InternalExprGetKnownInt(interp);
        } else if (testname.equals("InternalExprInlineGetInt")) {
            this.InternalExprInlineGetInt(interp);
        } else if (testname.equals("InternalTclDoubleGet")) {
            this.InternalTclDoubleGet(interp);
        } else if (testname.equals("InternalExprGetKnownDouble")) {
            this.InternalExprGetKnownDouble(interp);
        } else if (testname.equals("InternalExprInlinedIntNotOperator")) {
            this.InternalExprInlinedIntNotOperator(interp);
        } else if (testname.equals("InternalExprInlinedIntNotBitwiseOperator")) {
            this.InternalExprInlinedIntNotBitwiseOperator(interp);
        } else if (testname.equals("InternalExprValueIntNotOperator")) {
            this.InternalExprValueIntNotOperator(interp);
        } else if (testname.equals("InternalExprValueIntNotNstrOperator")) {
            this.InternalExprValueIntNotNstrOperator(interp);
        } else if (testname.equals("InternalSetTclObjectResult")) {
            this.InternalSetTclObjectResult(interp);
        } else if (testname.equals("InternalSetSameTclObjectResult")) {
            this.InternalSetSameTclObjectResult(interp);
        } else if (testname.equals("InternalResetResult")) {
            this.InternalResetResult(interp);
        } else if (testname.equals("InternalSetBooleanResult")) {
            this.InternalSetBooleanResult(interp);
        } else if (testname.equals("InternalSetIntResult")) {
            this.InternalSetIntResult(interp);
        } else if (testname.equals("InternalSetUncommonIntResult")) {
            this.InternalSetUncommonIntResult(interp);
        } else if (testname.equals("InternalSetUncommonDoubleResult")) {
            this.InternalSetUncommonDoubleResult(interp);
        } else if (testname.equals("InternalSetUncommonStringResult")) {
            this.InternalSetUncommonStringResult(interp);
        } else if (testname.equals("InternalSetIntResultViaExprValue")) {
            this.InternalSetIntResultViaExprValue(interp);
        } else if (testname.equals("InternalExprSetIntResult")) {
            this.InternalExprSetIntResult(interp);
        } else if (testname.equals("InternalExprOpIntNot")) {
            this.InternalExprOpIntNot(interp);
        } else if (testname.equals("InternalExprOpIntNotGrabReleaseResult")) {
            this.InternalExprOpIntNotGrabReleaseResult(interp);
        } else if (testname.equals("InternalExprOpIntNotStackValueResult")) {
            this.InternalExprOpIntNotStackValueResult(interp);
        } else if (testname.equals("InternalExprOpIntNotStackValueIntResult")) {
            this.InternalExprOpIntNotStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntNotStackValueBooleanResult")) {
            this.InternalExprOpIntNotStackValueBooleanResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotStackValueResult")) {
            this.InternalExprOpIntInlinedNotStackValueResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrStackValueResult")) {
            this.InternalExprOpIntInlinedNotNstrStackValueResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrStackValueIntResult")) {
            this.InternalExprOpIntInlinedNotNstrStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrStackValueBooleanResult")) {
            this.InternalExprOpIntInlinedNotNstrStackValueBooleanResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotKnownIntResult")) {
            this.InternalExprOpIntInlinedNotKnownIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotKnownIntInlineResult")) {
            this.InternalExprOpIntInlinedNotKnownIntInlineResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotKnownIntInlineBooleanResult")) {
            this.InternalExprOpIntInlinedNotKnownIntInlineBooleanResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrAsBoolean")) {
            this.InternalExprOpIntInlinedNotNstrAsBoolean(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrKnownIntAsBoolean")) {
            this.InternalExprOpIntInlinedNotNstrKnownIntAsBoolean(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrLocalAsBoolean")) {
            this.InternalExprOpIntInlinedNotNstrLocalAsBoolean(interp);
        } else if (testname.equals("InternalExprOpIntPlus")) {
            this.InternalExprOpIntPlus(interp);
        } else if (testname.equals("InternalExprOpIntPlusGrabReleaseResult")) {
            this.InternalExprOpIntPlusGrabReleaseResult(interp);
        } else if (testname.equals("InternalExprOpIntPlusStackValueResult")) {
            this.InternalExprOpIntPlusStackValueResult(interp);
        } else if (testname.equals("InternalExprOpIntPlusStackValueIntResult")) {
            this.InternalExprOpIntPlusStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedPlusStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedPlusNBStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusNBStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedPlusIMStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusIMStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedPlusIMRStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusIMRStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpDoublePlus")) {
            this.InternalExprOpDoublePlus(interp);
        } else if (testname.equals("InternalExprOpLogicalOrResult")) {
            this.InternalExprOpLogicalOrResult(interp);
        } else if (testname.equals("InternalExprOpInlinedLogicalOrResult")) {
            this.InternalExprOpInlinedLogicalOrResult(interp);
        } else if (testname.equals("InternalExprOpInlinedIntLogicalOrResult")) {
            this.InternalExprOpInlinedIntLogicalOrResult(interp);
        } else if (testname.equals("InternalExprOpInlinedNoExprLogicalOrResult")) {
            this.InternalExprOpInlinedNoExprLogicalOrResult(interp);
        } else if (testname.equals("InternalObjvInvoke")) {
            this.InternalObjvInvoke(interp);
        } else if (testname.equals("InternalObjvInvokeOnStack")) {
            this.InternalObjvInvokeOnStack(interp);
        } else if (testname.equals("InternalObjvInvokeOnStackAssigned")) {
            this.InternalObjvInvokeOnStackAssigned(interp);
        } else if (testname.equals("InternalObjvInvokeOnStackAssignedIndex")) {
            this.InternalObjvInvokeOnStackAssignedIndex(interp);
        } else if (testname.equals("InternalObjvInvokeOnStackStack")) {
            this.InternalObjvInvokeOnStackStack(interp);
        } else if (testname.equals("InternalObjvInvokeOnStackTryStack")) {
            this.InternalObjvInvokeOnStackTryStack(interp);
        } else {
            throw new TclException(interp, "unknown test name \"" + testname + "\"");
        }
    }

    void InternalTclObjectPreserve(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance((int)1);
        for (int i = 0; i < 5000; ++i) {
            tobj.preserve();
        }
        RESULT_INT = tobj.getRefCount();
    }

    void InternalTclObjectPreserveRelease(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance((int)1);
        tobj.preserve();
        tobj.preserve();
        for (int i = 0; i < 5000; ++i) {
            tobj.preserve();
            tobj.release();
        }
        RESULT_INT = tobj.getRefCount();
    }

    void InternalExprParseIntValue(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance((int)1);
        ExprValue value = new ExprValue(0, null);
        for (int i = 0; i < 5000; ++i) {
            Expression.ExprParseObject((Interp)interp, (TclObject)tobj, (ExprValue)value);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)tobj);
    }

    void InternalExprParseDoubleValue(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance((double)1.0);
        ExprValue value = new ExprValue(0, null);
        for (int i = 0; i < 5000; ++i) {
            Expression.ExprParseObject((Interp)interp, (TclObject)tobj, (ExprValue)value);
        }
        RESULT_INT = (int)TclDouble.get((Interp)interp, (TclObject)tobj);
    }

    void InternalExprGetBooleanInt(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance((int)1);
        boolean b = false;
        for (int i = 0; i < 5000; ++i) {
            b = TJC.getBoolean(interp, tobj);
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalExprGetBooleanDouble(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance((double)1.0);
        boolean b = false;
        for (int i = 0; i < 5000; ++i) {
            b = TJC.getBoolean(interp, tobj);
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalExprGetBooleanString(Interp interp) throws TclException {
        TclObject tobj = TclString.newInstance((String)"true");
        boolean b = false;
        for (int i = 0; i < 5000; ++i) {
            b = TJC.getBoolean(interp, tobj);
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalIncr(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance((int)0);
        for (int i = 0; i < 5000; ++i) {
            TclInteger.incr((Interp)interp, (TclObject)tobj, (int)1);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)tobj);
    }

    void InternalTclListLength(Interp interp) throws TclException {
        TclObject tlist = TclList.newInstance();
        TclObject tobj = interp.checkCommonString(null);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        int size = 0;
        for (int i = 0; i < 5000; ++i) {
            size += TclList.getLength((Interp)interp, (TclObject)tlist);
        }
        RESULT_INT = size;
    }

    void InternalTclListLindex(Interp interp) throws TclException {
        TclObject tlist = TclList.newInstance();
        TclObject tobj = interp.checkCommonString(null);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        for (int i = 0; i < 5000; ++i) {
            tobj = TclList.index((Interp)interp, (TclObject)tlist, (int)6);
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclListAppend(Interp interp) throws TclException {
        TclObject tlist = TclList.newInstance();
        TclObject tobj = interp.checkCommonString(null);
        for (int i = 0; i < 5000; ++i) {
            TclList.append((Interp)interp, (TclObject)tlist, (TclObject)tobj);
        }
        RESULT_OBJ = tlist;
    }

    void InternalTclStringNewInstance(Interp interp) throws TclException {
        TclObject tobj = null;
        for (int i = 0; i < 5000; ++i) {
            tobj = TclString.newInstance((String)"foo");
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclIntegerNewInstance(Interp interp) throws TclException {
        TclObject tobj = null;
        for (int i = 0; i < 5000; ++i) {
            tobj = TclInteger.newInstance((int)1);
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclDoubleNewInstance(Interp interp) throws TclException {
        TclObject tobj = null;
        for (int i = 0; i < 5000; ++i) {
            tobj = TclDouble.newInstance((double)1.0);
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclListNewInstance(Interp interp) throws TclException {
        TclObject tobj = null;
        for (int i = 0; i < 5000; ++i) {
            tobj = TclList.newInstance();
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclStringDuplicate(Interp interp) throws TclException {
        TclObject tobj = TclString.newInstance((String)"foo");
        for (int i = 0; i < 5000; ++i) {
            tobj = tobj.duplicate();
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclIntegerDuplicate(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance((int)1);
        for (int i = 0; i < 5000; ++i) {
            tobj = tobj.duplicate();
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclDoubleDuplicate(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance((double)1.0);
        for (int i = 0; i < 5000; ++i) {
            tobj = tobj.duplicate();
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclListDuplicate(Interp interp) throws TclException {
        TclObject tobj = TclList.newInstance();
        for (int i = 0; i < 5000; ++i) {
            tobj = tobj.duplicate();
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclIntegerType(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance((int)1);
        boolean b = false;
        for (int i = 0; i < 5000; ++i) {
            b = tobj.isIntType();
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalTclDoubleType(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance((double)1.0);
        boolean b = false;
        for (int i = 0; i < 5000; ++i) {
            b = tobj.isDoubleType();
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalTclStringType(Interp interp) throws TclException {
        TclObject tobj = TclString.newInstance((String)"foo");
        boolean b = false;
        for (int i = 0; i < 5000; ++i) {
            b = tobj.isStringType();
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalTclListType(Interp interp) throws TclException {
        TclObject tobj = TclList.newInstance();
        boolean b = false;
        for (int i = 0; i < 5000; ++i) {
            b = tobj.isListType();
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalTclIntegerGet(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance((int)1);
        int ivalue = 0;
        for (int i = 0; i < 5000; ++i) {
            ivalue = TclInteger.get((Interp)interp, (TclObject)tobj);
        }
        RESULT_INT = ivalue;
    }

    void InternalExprGetKnownInt(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance((int)1);
        int ivalue = 0;
        for (int i = 0; i < 5000; ++i) {
            ivalue = TJC.exprGetKnownInt(tobj);
        }
        RESULT_INT = ivalue;
    }

    void InternalExprInlineGetInt(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance((int)1);
        int ivalue = 0;
        for (int i = 0; i < 5000; ++i) {
            ivalue = tobj.ivalue;
        }
        RESULT_INT = ivalue;
    }

    void InternalTclDoubleGet(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance((double)1.0);
        double d = 0.0;
        for (int i = 0; i < 5000; ++i) {
            d = TclDouble.get((Interp)interp, (TclObject)tobj);
        }
        RESULT_INT = (int)d;
    }

    void InternalExprGetKnownDouble(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance((double)1.0);
        double d = 0.0;
        for (int i = 0; i < 5000; ++i) {
            d = TJC.exprGetKnownDouble(tobj);
        }
        RESULT_INT = (int)d;
    }

    void InternalExprInlinedIntNotOperator(Interp interp) throws TclException {
        int v = 1;
        for (int i = 0; i < 5000; ++i) {
            v = v == 0 ? 1 : 0;
        }
        RESULT_INT = v;
    }

    void InternalExprInlinedIntNotBitwiseOperator(Interp interp) throws TclException {
        int v = 1;
        for (int i = 0; i < 5000; ++i) {
            v = (v | -v) >>> 31 ^ 1;
        }
        RESULT_INT = v;
    }

    void InternalExprValueIntNotOperator(Interp interp) throws TclException {
        ExprValue ev = new ExprValue(1, null);
        for (int i = 0; i < 5000; ++i) {
            ev.optIntUnaryNot();
        }
        RESULT_INT = ev.getIntValue();
    }

    void InternalExprValueIntNotNstrOperator(Interp interp) throws TclException {
        ExprValue ev = new ExprValue(1, null);
        for (int i = 0; i < 5000; ++i) {
            ev.optIntUnaryNotNstr();
        }
        RESULT_INT = ev.getIntValue();
    }

    void InternalSetTclObjectResult(Interp interp) throws TclException {
        TclObject tobj1 = TclInteger.newInstance((int)1);
        TclObject tobj2 = TclInteger.newInstance((int)2);
        tobj1.preserve();
        tobj1.preserve();
        tobj2.preserve();
        tobj2.preserve();
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(tobj1);
            interp.setResult(tobj2);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalSetSameTclObjectResult(Interp interp) throws TclException {
        TclObject tobj1 = TclInteger.newInstance((int)1);
        tobj1.preserve();
        tobj1.preserve();
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(tobj1);
            interp.setResult(tobj1);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalResetResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            interp.resetResult();
            interp.resetResult();
        }
        RESULT_OBJ = interp.getResult();
    }

    void InternalSetBooleanResult(Interp interp) throws TclException {
        boolean b1 = true;
        boolean b2 = false;
        if (RESULT_INT == 0) {
            b1 = false;
            b2 = true;
        }
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(b1);
            interp.setResult(b2);
        }
        RESULT_INT = TclBoolean.get((Interp)interp, (TclObject)interp.getResult()) ? 1 : 0;
    }

    void InternalSetIntResult(Interp interp) throws TclException {
        int i1 = 1;
        int i2 = 0;
        if (RESULT_INT == 0) {
            i1 = 0;
            i2 = 1;
        }
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(i1);
            interp.setResult(i2);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalSetUncommonIntResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(i * 2);
            interp.setResult(i * 3);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalSetUncommonDoubleResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            interp.setResult((double)i * 2.0);
            interp.setResult((double)i * 3.0);
        }
        RESULT_INT = (int)TclDouble.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalSetUncommonStringResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            interp.setResult("2" + i);
            interp.setResult("3" + i);
        }
        RESULT_OBJ = interp.getResult();
    }

    void InternalSetIntResultViaExprValue(Interp interp) throws TclException {
        int i1 = 1;
        int i2 = 0;
        if (RESULT_INT == 0) {
            i1 = 0;
            i2 = 1;
        }
        ExprValue value1 = TJC.exprGetValue(interp, i1, null);
        ExprValue value2 = TJC.exprGetValue(interp, i2, null);
        for (int i = 0; i < 5000; ++i) {
            interp.setResult(value1.getIntValue());
            interp.setResult(value2.getIntValue());
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprSetIntResult(Interp interp) throws TclException {
        int i1 = 1;
        int i2 = 0;
        if (RESULT_INT == 0) {
            i1 = 0;
            i2 = 1;
        }
        ExprValue value1 = TJC.exprGetValue(interp, i1, null);
        ExprValue value2 = TJC.exprGetValue(interp, i2, null);
        for (int i = 0; i < 5000; ++i) {
            TJC.exprSetResult(interp, value1);
            TJC.exprSetResult(interp, value2);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntNot(Interp interp) throws TclException {
        ExprValue value = new ExprValue(1, null);
        for (int i = 0; i < 5000; ++i) {
            Expression.evalUnaryOperator((Interp)interp, (int)32, (ExprValue)value);
        }
        RESULT_INT = value.getIntValue();
    }

    void InternalExprOpIntNotGrabReleaseResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = TJC.exprGetValue(interp, 1, null);
            TJC.exprUnaryOperator(interp, 32, tmp0);
            TJC.exprSetResult(interp, tmp0);
            TJC.exprReleaseValue(interp, tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntNotStackValueResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            TJC.exprUnaryOperator(interp, 32, tmp0);
            TJC.exprSetResult(interp, tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntNotStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            TJC.exprUnaryOperator(interp, 32, tmp0);
            interp.setResult(tmp0.getIntValue());
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntNotStackValueBooleanResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            TJC.exprUnaryOperator(interp, 32, tmp0);
            interp.setResult(tmp0.getIntValue() != 0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedNotStackValueResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            if (!tmp0.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.optIntUnaryNot();
            TJC.exprSetResult(interp, tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrStackValueResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            if (!tmp0.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.optIntUnaryNotNstr();
            TJC.exprSetResult(interp, tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            if (!tmp0.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.optIntUnaryNotNstr();
            interp.setResult(tmp0.getIntValue());
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrStackValueBooleanResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(0);
            if (!tmp0.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.optIntUnaryNotNstr();
            interp.setResult(tmp0.getIntValue() != 0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedNotKnownIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        TclObject tobj = TclInteger.newInstance((int)1);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            if (!tobj.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            TJC.exprUnaryNotOperatorKnownInt(tmp0, tobj);
            interp.setResult(tmp0.getIntValue() != 0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedNotKnownIntInlineResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        TclObject tobj = TclInteger.newInstance((int)1);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            if (!tobj.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.setIntValue(TJC.exprGetKnownInt(tobj) == 0 ? 1 : 0);
            interp.setResult(tmp0.getIntValue() != 0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedNotKnownIntInlineBooleanResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        TclObject tobj = TclInteger.newInstance((int)1);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            if (!tobj.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.setIntValue(TJC.exprGetKnownInt(tobj) == 0);
            interp.setResult(tmp0.getIntValue() != 0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrAsBoolean(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            tmp0.optIntUnaryNotNstr();
            boolean tmp1 = tmp0.getBooleanValue(interp);
            RESULT_INT = tmp1 ? 1 : 0;
        }
    }

    void InternalExprOpIntInlinedNotNstrKnownIntAsBoolean(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            tmp0.optIntUnaryNotNstr();
            boolean tmp1 = tmp0.getIntValue() != 0;
            RESULT_INT = tmp1 ? 1 : 0;
        }
    }

    void InternalExprOpIntInlinedNotNstrLocalAsBoolean(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp1 = evs0;
            tmp1.setIntValue(1);
            boolean result0 = tmp1.getIntValue() != 0;
            RESULT_INT = result0 ? 1 : 0;
        }
    }

    void InternalExprOpIntPlus(Interp interp) throws TclException {
        ExprValue value1 = new ExprValue(1, null);
        ExprValue value2 = new ExprValue(2, null);
        for (int i = 0; i < 5000; ++i) {
            Expression.evalBinaryOperator((Interp)interp, (int)11, (ExprValue)value1, (ExprValue)value2);
        }
        RESULT_INT = value1.getIntValue();
    }

    void InternalExprOpIntPlusGrabReleaseResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = TJC.exprGetValue(interp, 1, null);
            ExprValue tmp1 = TJC.exprGetValue(interp, 2, null);
            TJC.exprBinaryOperator(interp, 11, tmp0, tmp1);
            TJC.exprReleaseValue(interp, tmp1);
            TJC.exprSetResult(interp, tmp0);
            TJC.exprReleaseValue(interp, tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntPlusStackValueResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        ExprValue evs1 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            ExprValue tmp1 = evs1;
            tmp1.setIntValue(2);
            TJC.exprBinaryOperator(interp, 11, tmp0, tmp1);
            TJC.exprSetResult(interp, tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntPlusStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        ExprValue evs1 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            ExprValue tmp1 = evs1;
            tmp1.setIntValue(2);
            TJC.exprBinaryOperator(interp, 11, tmp0, tmp1);
            interp.setResult(tmp0.getIntValue());
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedPlusStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        ExprValue evs1 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            ExprValue tmp1 = evs1;
            tmp1.setIntValue(2);
            if (!tmp0.isIntType() || !tmp1.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.optIntPlus(tmp1);
            interp.setResult(tmp0.getIntValue());
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedPlusNBStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        ExprValue evs1 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1);
            ExprValue tmp1 = evs1;
            tmp1.setIntValue(2);
            tmp0.optIntPlus(tmp1);
            interp.setResult(tmp0.getIntValue());
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedPlusIMStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(3);
            interp.setResult(tmp0.getIntValue());
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpIntInlinedPlusIMRStackValueIntResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            int tmp0 = 3;
            interp.setResult(tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpDoublePlus(Interp interp) throws TclException {
        ExprValue value1 = new ExprValue(1.0, null);
        ExprValue value2 = new ExprValue(2.0, null);
        for (int i = 0; i < 5000; ++i) {
            Expression.evalBinaryOperator((Interp)interp, (int)11, (ExprValue)value1, (ExprValue)value2);
        }
        RESULT_INT = (int)value1.getDoubleValue();
    }

    void InternalExprOpLogicalOrResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        ExprValue evs1 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(0);
            if (!tmp0.getBooleanValue(interp)) {
                ExprValue tmp1 = evs1;
                tmp1.setIntValue(1);
                tmp0.setIntValue(tmp1.getBooleanValue(interp));
            } else {
                tmp0.setIntValue(1);
            }
            TJC.exprSetResult(interp, tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpInlinedLogicalOrResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            ExprValue tmp1 = evs0;
            tmp1.setIntValue(0);
            boolean tmp0 = tmp1.getBooleanValue(interp);
            if (!tmp0) {
                ExprValue tmp2 = evs0;
                tmp2.setIntValue(1);
                tmp0 = tmp2.getBooleanValue(interp);
            }
            interp.setResult(tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpInlinedIntLogicalOrResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        for (int i = 0; i < 5000; ++i) {
            boolean tmp0;
            ExprValue tmp1 = evs0;
            tmp1.setIntValue(0);
            boolean bl = tmp0 = tmp1.getIntValue() != 0;
            if (!tmp0) {
                ExprValue tmp2 = evs0;
                tmp2.setIntValue(1);
                tmp0 = tmp2.getIntValue() != 0;
            }
            interp.setResult(tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    void InternalExprOpInlinedNoExprLogicalOrResult(Interp interp) throws TclException {
        for (int i = 0; i < 5000; ++i) {
            boolean tmp0;
            boolean value = false;
            boolean bl = tmp0 = value;
            if (!tmp0) {
                value = true;
                tmp0 = value;
            }
            interp.setResult(tmp0);
        }
        RESULT_INT = TclInteger.get((Interp)interp, (TclObject)interp.getResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvoke(Interp interp) throws TclException {
        TclObject const0 = TclString.newInstance((String)"cmd");
        TclObject var1 = TclString.newInstance((String)"value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance((String)"const1");
        TclObject var2 = TclString.newInstance((String)"value2");
        var2.preserve();
        for (int i = 0; i < 5000; ++i) {
            Object var10_9;
            TclObject tmp1;
            TclObject[] objv0 = TJC.grabObjv(interp, 4);
            try {
                objv0[0] = const0;
                tmp1 = var1;
                tmp1.preserve();
                objv0[1] = tmp1;
                objv0[2] = const1;
                tmp1 = var2;
                tmp1.preserve();
                objv0[3] = tmp1;
                RESULT_OBJ = objv0;
                var10_9 = null;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                tmp1 = objv0[1];
                if (tmp1 != null) {
                    tmp1.release();
                }
                if ((tmp1 = objv0[3]) != null) {
                    tmp1.release();
                }
                TJC.releaseObjv(interp, objv0, 4);
                throw throwable;
            }
            tmp1 = objv0[1];
            if (tmp1 != null) {
                tmp1.release();
            }
            if ((tmp1 = objv0[3]) != null) {
                tmp1.release();
            }
            TJC.releaseObjv(interp, objv0, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvokeOnStack(Interp interp) throws TclException {
        TclObject[] objvOnStack = TJC.grabObjv(interp, 4);
        TclObject const0 = TclString.newInstance((String)"cmd");
        TclObject var1 = TclString.newInstance((String)"value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance((String)"const1");
        TclObject var2 = TclString.newInstance((String)"value2");
        var2.preserve();
        for (int i = 0; i < 5000; ++i) {
            Object var11_10;
            TclObject tmp1;
            TclObject[] objv0 = objvOnStack;
            try {
                objv0[0] = const0;
                tmp1 = var1;
                tmp1.preserve();
                objv0[1] = tmp1;
                objv0[2] = const1;
                tmp1 = var2;
                tmp1.preserve();
                objv0[3] = tmp1;
                RESULT_OBJ = objv0;
                var11_10 = null;
                objv0[0] = null;
            }
            catch (Throwable throwable) {
                var11_10 = null;
                objv0[0] = null;
                tmp1 = objv0[1];
                if (tmp1 != null) {
                    tmp1.release();
                }
                objv0[1] = null;
                objv0[2] = null;
                tmp1 = objv0[3];
                if (tmp1 != null) {
                    tmp1.release();
                }
                objv0[3] = null;
                throw throwable;
            }
            tmp1 = objv0[1];
            if (tmp1 != null) {
                tmp1.release();
            }
            objv0[1] = null;
            objv0[2] = null;
            tmp1 = objv0[3];
            if (tmp1 != null) {
                tmp1.release();
            }
            objv0[3] = null;
        }
        TJC.releaseObjv(interp, objvOnStack, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvokeOnStackAssigned(Interp interp) throws TclException {
        TclObject[] objvOnStack = TJC.grabObjv(interp, 4);
        TclObject const0 = TclString.newInstance((String)"cmd");
        TclObject var1 = TclString.newInstance((String)"value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance((String)"const1");
        TclObject var2 = TclString.newInstance((String)"value2");
        var2.preserve();
        TclObject ASSIGNED = TclString.newInstance((String)"");
        for (int i = 0; i < 5000; ++i) {
            TclObject[] objv0;
            block9: {
                Object var12_11;
                objv0 = objvOnStack;
                TclObject tmp1 = null;
                try {
                    objv0[0] = const0;
                    tmp1 = var1;
                    tmp1.preserve();
                    objv0[1] = tmp1;
                    objv0[2] = const1;
                    tmp1 = var2;
                    tmp1.preserve();
                    objv0[3] = tmp1;
                    tmp1 = ASSIGNED;
                    RESULT_OBJ = objv0;
                    var12_11 = null;
                    objv0[0] = null;
                    objv0[2] = null;
                    if (tmp1 == ASSIGNED) break block9;
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    objv0[0] = null;
                    objv0[2] = null;
                    if (tmp1 != ASSIGNED) {
                        tmp1 = objv0[1];
                        if (tmp1 != null) {
                            tmp1.release();
                        }
                        objv0[1] = null;
                        tmp1 = objv0[3];
                        if (tmp1 != null) {
                            tmp1.release();
                        }
                        objv0[3] = null;
                    } else {
                        objv0[1].release();
                        objv0[1] = null;
                        objv0[3].release();
                        objv0[3] = null;
                    }
                    throw throwable;
                }
                tmp1 = objv0[1];
                if (tmp1 != null) {
                    tmp1.release();
                }
                objv0[1] = null;
                tmp1 = objv0[3];
                if (tmp1 != null) {
                    tmp1.release();
                }
                objv0[3] = null;
                continue;
            }
            objv0[1].release();
            objv0[1] = null;
            objv0[3].release();
            objv0[3] = null;
            {
                continue;
            }
        }
        TJC.releaseObjv(interp, objvOnStack, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvokeOnStackAssignedIndex(Interp interp) throws TclException {
        TclObject[] objvOnStack = TJC.grabObjv(interp, 4);
        TclObject const0 = TclString.newInstance((String)"cmd");
        TclObject var1 = TclString.newInstance((String)"value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance((String)"const1");
        TclObject var2 = TclString.newInstance((String)"value2");
        var2.preserve();
        TclObject ASSIGNED = TclString.newInstance((String)"");
        for (int i = 0; i < 5000; ++i) {
            TclObject[] objv0;
            block7: {
                int j;
                Object var13_12;
                TclObject tmp1;
                objv0 = objvOnStack;
                int assignedIndex = -1;
                try {
                    objv0[0] = const0;
                    assignedIndex = 0;
                    tmp1 = var1;
                    tmp1.preserve();
                    objv0[1] = tmp1;
                    assignedIndex = 1;
                    objv0[2] = const1;
                    assignedIndex = 2;
                    tmp1 = var2;
                    tmp1.preserve();
                    objv0[3] = tmp1;
                    assignedIndex = 3;
                    RESULT_OBJ = objv0;
                    var13_12 = null;
                    if (assignedIndex >= 3) break block7;
                    objv0[0] = null;
                    objv0[2] = null;
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    if (assignedIndex < 3) {
                        objv0[0] = null;
                        objv0[2] = null;
                        for (j = 0; j <= assignedIndex; ++j) {
                            tmp1 = objv0[j];
                            if (tmp1 == null) continue;
                            tmp1.release();
                        }
                    } else {
                        objv0[1].release();
                        objv0[3].release();
                    }
                    throw throwable;
                }
                for (j = 0; j <= assignedIndex; ++j) {
                    tmp1 = objv0[j];
                    if (tmp1 == null) continue;
                    tmp1.release();
                }
                continue;
            }
            objv0[1].release();
            objv0[3].release();
            {
                continue;
            }
        }
        TJC.releaseObjv(interp, objvOnStack, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void InternalObjvInvokeOnStackStack(Interp interp) throws TclException {
        TclObject[] objv0 = TJC.grabObjv(interp, 4);
        TclObject const0 = TclString.newInstance((String)"cmd");
        TclObject var1 = TclString.newInstance((String)"value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance((String)"const1");
        TclObject var2 = TclString.newInstance((String)"value2");
        var2.preserve();
        for (int i = 0; i < 5000; ++i) {
            TclObject tmp2;
            block5: {
                Object var11_10;
                TclObject tmp1 = null;
                tmp2 = null;
                try {
                    objv0[0] = const0;
                    tmp1 = var1;
                    tmp1.preserve();
                    objv0[1] = tmp1;
                    objv0[2] = const1;
                    tmp2 = var2;
                    tmp2.preserve();
                    objv0[3] = tmp2;
                    RESULT_OBJ = objv0;
                    var11_10 = null;
                    if (tmp1 == null) break block5;
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    if (tmp1 != null) {
                        tmp1.release();
                    }
                    if (tmp2 != null) {
                        tmp2.release();
                    }
                    throw throwable;
                }
                tmp1.release();
            }
            if (tmp2 == null) continue;
            tmp2.release();
            {
                continue;
            }
        }
        TJC.releaseObjv(interp, objv0, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void InternalObjvInvokeOnStackTryStack(Interp interp) throws TclException {
        TclObject[] objv0 = TJC.grabObjv(interp, 4);
        TclObject const0 = TclString.newInstance((String)"cmd");
        TclObject var1 = TclString.newInstance((String)"value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance((String)"const1");
        TclObject var2 = TclString.newInstance((String)"value2");
        var2.preserve();
        int i = 0;
        while (true) {
            TclObject tmp2;
            TclObject tmp1;
            block8: {
                Object var11_10;
                if (i >= 5000) {
                    TJC.releaseObjv(interp, objv0, 4);
                    return;
                }
                tmp1 = null;
                tmp2 = null;
                try {
                    objv0[0] = const0;
                    tmp1 = var1;
                    tmp1.preserve();
                    objv0[1] = tmp1;
                    objv0[2] = const1;
                    tmp2 = var2;
                    tmp2.preserve();
                    objv0[3] = tmp2;
                    var11_10 = null;
                    if (tmp2 != null || tmp1 == null) break block8;
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    if (tmp2 == null && tmp1 != null) {
                        tmp1.release();
                    }
                    throw throwable;
                }
                tmp1.release();
            }
            try {
                RESULT_OBJ = objv0;
            }
            finally {
                tmp1.release();
                tmp2.release();
            }
            ++i;
        }
    }
}

