/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import tcl.lang.Interp;
import tcl.lang.TJCThread;
import tcl.lang.TclClassLoader;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class TJCCompileJavaCmd
extends TclEvent
implements TJCThread.CompiledClassReady {
    final boolean debug = false;
    final Interp interp;
    final TclObject javaInfo;
    final String readyCmd;
    final String readyVar;
    boolean status;
    String errorMsg = "";
    ArrayList cnames;
    ArrayList cdata;

    TJCCompileJavaCmd(Interp interp, String javaInfo, String readyCmd, String readyVar) {
        this.interp = interp;
        this.javaInfo = TclString.newInstance((String)javaInfo);
        this.readyCmd = readyCmd;
        this.readyVar = readyVar;
    }

    public void compiled(String geninfo, String jfilename, String jsrcode, ArrayList cnames, ArrayList cdata, int status, String msg) {
        if (status == 0) {
            this.status = true;
        } else {
            this.status = false;
            this.errorMsg = msg;
        }
        if (cdata != null) {
            this.cnames = cnames;
            this.cdata = cdata;
        }
        this.interp.getNotifier().queueEvent((TclEvent)this, 0);
    }

    public int processEvent(int flags) {
        if (!this.status) {
            this.readyReport();
            return 1;
        }
        TclClassLoader tclClassLoader = (TclClassLoader)this.interp.getClassLoader();
        ArrayList<String> resolved_cnames = new ArrayList<String>();
        for (int i = 0; i < this.cdata.size(); ++i) {
            byte[] classBytes;
            Class cl;
            String cname = null;
            if (this.cnames != null && (cname = (String)this.cnames.get(i)).length() == 0) {
                cname = null;
            }
            if ((cl = tclClassLoader.defineClass(cname, classBytes = (byte[])this.cdata.get(i))) == null) {
                this.status = false;
                this.errorMsg = cname != null ? "class \"" + cname + "\" not loaded by TclClassLoader" : "class not loaded by TclClassLoader";
                this.readyReport();
                return 1;
            }
            if (cname == null) {
                cname = cl.getName();
            }
            resolved_cnames.add(cname);
        }
        this.cnames = resolved_cnames;
        this.readyReport();
        return 1;
    }

    void readyReport() {
        try {
            if (this.readyVar != null) {
                TclObject tlist = TclList.newInstance();
                if (this.status) {
                    TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)"OK"));
                } else {
                    TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)"FAIL"));
                }
                TclObject cnames_list = TclList.newInstance();
                if (this.cnames != null) {
                    for (int i = 0; i < this.cnames.size(); ++i) {
                        String cname = (String)this.cnames.get(i);
                        TclList.append((Interp)this.interp, (TclObject)cnames_list, (TclObject)TclString.newInstance((String)cname));
                    }
                }
                TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)cnames_list);
                TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)this.errorMsg));
                this.interp.setVar(this.readyVar, null, tlist, 1);
            } else if (this.readyCmd != null) {
                TclObject tlist = TclList.newInstance();
                TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)this.readyCmd));
                if (this.status) {
                    TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)"OK"));
                } else {
                    TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)"FAIL"));
                }
                TclObject cnames_list = TclList.newInstance();
                if (this.cnames != null) {
                    for (int i = 0; i < this.cnames.size(); ++i) {
                        String cname = (String)this.cnames.get(i);
                        TclList.append((Interp)this.interp, (TclObject)cnames_list, (TclObject)TclString.newInstance((String)cname));
                    }
                }
                TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)cnames_list);
                TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)this.errorMsg));
                this.interp.eval(tlist, 131072);
            }
        }
        catch (TclException te) {
            te.printStackTrace(System.err);
        }
    }

    String getJavaFileName() throws TclException {
        TclObject obj = TclList.index((Interp)this.interp, (TclObject)this.javaInfo, (int)0);
        String clName = obj.toString();
        StringBuffer nbuff = new StringBuffer(64);
        if (clName.indexOf(46) == -1) {
            nbuff.append(clName);
        } else {
            nbuff.append(clName.replace('.', '/'));
        }
        nbuff.append(".java");
        return nbuff.toString();
    }

    String getJavaSource() throws TclException {
        TclObject src = TclList.index((Interp)this.interp, (TclObject)this.javaInfo, (int)1);
        return src.toString();
    }
}

