/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.util.Calendar;
import java.util.TimeZone;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/gmtime.c")
public final class Gmtime {
    private Gmtime() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="Unix.tm")
    public static Value unix_gmtime(Value value) {
        return Gmtime.createTime((long)(value.asDouble() * 1000.0), false);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"float"}, returnType="Unix.tm")
    public static Value unix_localtime(Value value) {
        return Gmtime.createTime((long)(value.asDouble() * 1000.0), true);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.tm"}, returnType="float * Unix.tm")
    public static Value unix_mktime(Value value) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, value.get0().asCastedInt());
        calendar.set(12, value.get1().asCastedInt());
        calendar.set(11, value.get2().asCastedInt());
        calendar.set(5, value.get3().asCastedInt());
        calendar.set(2, value.get4().asCastedInt());
        calendar.set(1, value.get5().asCastedInt() + 1900);
        calendar.set(7, value.get6().asCastedInt() + 1);
        calendar.set(6, value.get7().asCastedInt() + 1);
        long l = calendar.getTimeInMillis();
        return Value.createBlock(0, Value.createDouble((double)l / 1000.0), Gmtime.createTime(l, true));
    }

    private static Value createTime(long l, boolean bl) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        Value value = Value.createBlock(0, 9L);
        value.set0(Value.createLong(calendar.get(13)));
        value.set1(Value.createLong(calendar.get(12)));
        value.set2(Value.createLong(calendar.get(11)));
        value.set3(Value.createLong(calendar.get(5)));
        value.set4(Value.createLong(calendar.get(2)));
        value.set5(Value.createLong(calendar.get(1) - 1900));
        value.set6(Value.createLong(calendar.get(7) - 1));
        value.set7(Value.createLong(calendar.get(6) - 1));
        value.set(8, bl && TimeZone.getDefault().inDaylightTime(calendar.getTime()) ? Value.TRUE : Value.FALSE);
        return value;
    }
}

