/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.NamespaceCmd;
import tcl.lang.PackageNameException;
import tcl.lang.Procedure;
import tcl.lang.TJCCompileJavaCmd;
import tcl.lang.TJCCompileTclCmd;
import tcl.lang.TJCThread;
import tcl.lang.TclClassLoader;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class TJCCompileCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int next;
        if (objv.length < 2 || objv.length == 3 || objv.length > 5) {
            throw new TclNumArgsException(interp, 1, objv, "?cmd? ?options?");
        }
        String javaInfo = null;
        String cmd = null;
        String readycmd = null;
        String readyvar = null;
        cmd = objv[1].toString();
        if (cmd.equals("-java")) {
            if (objv.length != 5) {
                throw new TclNumArgsException(interp, 1, objv, "?cmd? ?options?");
            }
            TclObject obj = objv[2];
            if (TclList.getLength((Interp)interp, (TclObject)obj) != 2) {
                throw new TclException(interp, "-java JINFO argument must be a 2 element list of {JCLASSNAME JSRCCODE}");
            }
            javaInfo = objv[2].toString();
            cmd = null;
            next = 3;
        } else {
            next = 2;
        }
        if (next != objv.length) {
            if (next + 2 != objv.length) {
                throw new TclNumArgsException(interp, 1, objv, "?cmd? ?options?");
            }
            String option = objv[next].toString();
            String value = objv[next + 1].toString();
            if (option.equals("-readycmd")) {
                readycmd = value;
            } else if (option.equals("-readyvar")) {
                readyvar = value;
            } else {
                throw new TclNumArgsException(interp, 1, objv, "?cmd? ?options?");
            }
        }
        if (javaInfo != null && cmd != null) {
            throw new TclRuntimeError("can set both cmd and -java");
        }
        if (readycmd != null && readyvar != null) {
            throw new TclRuntimeError("can set both -readyvar and -readycmd");
        }
        if (javaInfo != null) {
            TJCCompileCmd.JavaCompile(interp, javaInfo, readycmd, readyvar);
        } else {
            TJCCompileCmd.TclCompile(interp, cmd, readycmd, readyvar);
        }
    }

    static void JavaCompile(Interp interp, String javaInfo, String readyCmd, String readyVar) throws TclException {
        TJCThread.startThread();
        TJCCompileJavaCmd cjobj = new TJCCompileJavaCmd(interp, javaInfo, readyCmd, readyVar);
        String javaFileName = cjobj.getJavaFileName();
        String javaSrc = cjobj.getJavaSource();
        cjobj.getClass();
        TJCThread.compileJavaSource(javaFileName, javaSrc, cjobj);
    }

    static void TclCompile(Interp interp, String cmd, String readyCmd, String readyVar) throws TclException {
        int i;
        String fullyQualifiedCmd;
        TJCThread.startThread();
        Procedure proc = Procedure.findProc((Interp)interp, (String)cmd);
        if (proc == null) {
            throw new TclException(interp, "\"" + cmd + "\" isn't a procedure");
        }
        StringBuffer pname = new StringBuffer(64);
        StringBuffer cname = new StringBuffer(64);
        if (cmd.startsWith("::")) {
            pname.append(cmd);
        } else {
            String nsName = proc.wcmd.ns.fullName;
            if (nsName.equals("::")) {
                pname.append(nsName);
            } else {
                pname.append(nsName);
                pname.append("::");
            }
            pname.append(NamespaceCmd.tail((String)cmd));
        }
        String upper = fullyQualifiedCmd = pname.toString();
        boolean cap = true;
        int len = upper.length();
        for (i = 0; i < len; ++i) {
            char c = upper.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                if (cap) {
                    c = Character.toUpperCase(c);
                    cap = false;
                }
                cname.append(c);
                continue;
            }
            cap = true;
        }
        cname.append("Cmd");
        String javaClassName = cname.toString();
        if (TJCCompileCmd.isClassDefined(interp, javaClassName)) {
            String prefix = cname.toString();
            String suffix = null;
            for (i = 2; i < Integer.MAX_VALUE; ++i) {
                suffix = String.valueOf(i);
                if (!TJCCompileCmd.isClassDefined(interp, prefix + suffix)) break;
            }
            if (i == Integer.MAX_VALUE) {
                throw new TclRuntimeError("suffix integer overflow");
            }
            cname.append(suffix);
            javaClassName = cname.toString();
        }
        TclObject procList = TclList.newInstance();
        TclList.append((Interp)interp, (TclObject)procList, (TclObject)TclString.newInstance((String)"proc"));
        TclList.append((Interp)interp, (TclObject)procList, (TclObject)TclString.newInstance((String)cmd));
        TclObject args = TclList.newInstance();
        len = proc.argList.length;
        for (i = 0; i < len; ++i) {
            TclObject name = proc.argList[i][0];
            TclObject defval = proc.argList[i][1];
            if (defval == null) {
                TclList.append((Interp)interp, (TclObject)args, (TclObject)TclString.newInstance((String)name.toString()));
                continue;
            }
            TclObject defpair = TclList.newInstance();
            TclList.append((Interp)interp, (TclObject)defpair, (TclObject)TclString.newInstance((String)name.toString()));
            TclList.append((Interp)interp, (TclObject)defpair, (TclObject)TclString.newInstance((String)defval.toString()));
            TclList.append((Interp)interp, (TclObject)args, (TclObject)defpair);
        }
        if (proc.isVarArgs) {
            TclList.append((Interp)interp, (TclObject)args, (TclObject)TclString.newInstance((String)"args"));
        }
        TclList.append((Interp)interp, (TclObject)procList, (TclObject)TclString.newInstance((Object)args));
        TclList.append((Interp)interp, (TclObject)procList, (TclObject)TclString.newInstance((String)proc.body.toString()));
        TJCCompileTclCmd ctobj = new TJCCompileTclCmd(interp, fullyQualifiedCmd, readyCmd, readyVar);
        ctobj.getClass();
        TJCThread.compileTclSource(javaClassName, procList.toString(), ctobj);
    }

    static boolean isClassDefined(Interp interp, String javaClassName) {
        boolean debug = false;
        TclClassLoader tclClassLoader = (TclClassLoader)interp.getClassLoader();
        Class alreadyLoaded = null;
        try {
            alreadyLoaded = tclClassLoader.loadClass(javaClassName);
        }
        catch (ClassNotFoundException e) {
        }
        catch (PackageNameException e) {
            throw new TclRuntimeError("unexpected PackageNameException :" + e.getMessage());
        }
        boolean isDefined = alreadyLoaded != null;
        return isDefined;
    }
}

