/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import tcl.lang.Interp;
import tcl.lang.TJC;
import tcl.lang.TJCThread;
import tcl.lang.TclClassLoader;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class TJCCompileTclCmd
extends TclEvent
implements TJCThread.CompiledClassReady {
    final boolean debug = false;
    final Interp interp;
    final String cmd;
    final String readyCmd;
    final String readyVar;
    boolean status;
    String errorMsg = "";
    String className = null;
    byte[] classBytes = null;

    TJCCompileTclCmd(Interp interp, String cmd, String readyCmd, String readyVar) {
        this.interp = interp;
        this.cmd = cmd;
        this.readyCmd = readyCmd;
        this.readyVar = readyVar;
    }

    public void compiled(String geninfo, String jfilename, String jsrcode, ArrayList cnames, ArrayList cdata, int status, String msg) {
        if (status == 0) {
            this.status = true;
        } else {
            this.status = false;
            this.errorMsg = msg;
        }
        if (cdata != null) {
            if (cdata.size() == 1) {
                this.className = (String)cnames.get(0);
                this.classBytes = (byte[])cdata.get(0);
            } else {
                this.status = false;
                this.errorMsg = "unexpected number of class files " + cdata.size();
            }
        }
        this.interp.getNotifier().queueEvent((TclEvent)this, 0);
    }

    public int processEvent(int flags) {
        Class class_obj;
        if (!this.status) {
            this.readyReport();
            return 1;
        }
        TclClassLoader tclClassLoader = (TclClassLoader)this.interp.getClassLoader();
        if (this.className != null) {
            tclClassLoader.removeCache(this.className);
        }
        if ((class_obj = tclClassLoader.defineClass(this.className, this.classBytes)) == null) {
            this.status = false;
            this.errorMsg = "class not loaded by TclClassLoader";
            this.readyReport();
            return 1;
        }
        Object o = null;
        String instErr = null;
        if (this.className == null) {
            this.className = class_obj.getName();
        }
        try {
            o = class_obj.newInstance();
        }
        catch (InstantiationException ie) {
            instErr = "instance of class " + this.className + " could not be created";
        }
        catch (IllegalAccessException iae) {
            instErr = "instance of class " + this.className + " could not be created";
        }
        if (!(o instanceof TJC.CompiledCommand)) {
            instErr = "instance of class " + this.className + " must extend TJC.CompiledCommand";
        }
        if (instErr != null) {
            this.status = false;
            this.errorMsg = instErr;
            this.readyReport();
            return 1;
        }
        TJC.CompiledCommand cmdObj = o;
        try {
            TJC.createCommand(this.interp, this.cmd, cmdObj);
        }
        catch (TclException te) {
            this.status = false;
            this.errorMsg = te.getMessage();
            this.readyReport();
            return 1;
        }
        this.readyReport();
        return 1;
    }

    void readyReport() {
        try {
            if (this.readyVar != null) {
                TclObject tlist = TclList.newInstance();
                if (this.status) {
                    TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)"OK"));
                } else {
                    TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)"FAIL"));
                }
                TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)this.cmd));
                TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)this.errorMsg));
                this.interp.setVar(this.readyVar, null, tlist, 1);
            } else if (this.readyCmd != null) {
                TclObject tlist = TclList.newInstance();
                TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)this.readyCmd));
                if (this.status) {
                    TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)"OK"));
                } else {
                    TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)"FAIL"));
                }
                TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)this.cmd));
                TclList.append((Interp)this.interp, (TclObject)tlist, (TclObject)TclString.newInstance((String)this.errorMsg));
                this.interp.eval(tlist, 131072);
            }
        }
        catch (TclException te) {
            te.printStackTrace(System.err);
        }
    }
}

