/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class TJCThread
implements Runnable {
    public static final int STATUS_OK = 0;
    public static final int STATUS_ERROR = 1;
    private static boolean debug = false;
    private static String debugSetup = "";
    private static String driver = null;
    private static TJCThread tinstance = null;
    private static Thread tmain = null;
    private boolean terminate_request = false;
    private boolean terminated = false;
    private boolean ready = false;
    private static Vector queue = new Vector();
    private Interp interp = null;
    private static StringBuffer eventLog = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void compileJavaSource(String filename, String source, CompiledClassReady callback) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        if (eventLog != null) {
            eventLog.append("compileJavaSource " + filename + "\n");
        }
        if (debug) {
            System.out.println("compileJavaSource " + filename);
        }
        if (filename.equals("__FakeTest1.java")) {
            if (eventLog != null) {
                eventLog.append("Fake Java Test 1 processed\n");
            }
            if (debug) {
                System.out.println("Fake Java Test 1 processed");
            }
            ArrayList<String> class_names = new ArrayList<String>();
            class_names.add("__FakeTest1");
            byte[] bytes = new byte[]{70, 65, 75, 69};
            ArrayList<byte[]> class_data = new ArrayList<byte[]>();
            class_data.add(bytes);
            callback.compiled("", filename, source, class_names, class_data, 0, "");
            return;
        }
        Vector<Object> event = new Vector<Object>();
        event.addElement("JAVA");
        event.addElement(filename);
        event.addElement(source);
        event.addElement(callback);
        queue.addElement(event);
        TJCThread tJCThread = tinstance;
        synchronized (tJCThread) {
            if (eventLog != null) {
                eventLog.append("notify in compileJavaSource\n");
            }
            if (debug) {
                System.out.println("notify in compileJavaSource");
            }
            tinstance.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void compileTclSource(String filename, String proc_source, CompiledClassReady callback) {
        if (eventLog != null) {
            eventLog.append("compileTclSource " + filename + "\n");
        }
        if (debug) {
            System.out.println("compileTclSource " + filename);
            System.out.println("Tcl proc is:\n" + proc_source);
        }
        Vector<Object> event = new Vector<Object>();
        event.addElement("TCL");
        event.addElement(filename);
        event.addElement(proc_source);
        event.addElement(callback);
        queue.addElement(event);
        TJCThread tJCThread = tinstance;
        synchronized (tJCThread) {
            if (eventLog != null) {
                eventLog.append("notify in compileTclSource\n");
            }
            if (debug) {
                System.out.println("notify in compileTclSource");
            }
            tinstance.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void terminateThread() {
        if (eventLog != null) {
            eventLog.append("terminateThread\n");
        }
        if (debug) {
            System.out.println("terminateThread");
            if (queue.size() != 0) {
                System.out.println("terminateThread with unprocessed events");
            } else {
                System.out.println("terminateThread with no unprocessed events");
            }
        }
        if (TJCThread.tinstance.terminated) {
            if (eventLog != null) {
                eventLog.append("thread already terminated\n");
            }
            if (debug) {
                System.out.println("thread already terminated");
            }
            return;
        }
        TJCThread.tinstance.terminate_request = true;
        TJCThread tJCThread = tinstance;
        synchronized (tJCThread) {
            if (eventLog != null) {
                eventLog.append("notify in terminateThread\n");
            }
            if (debug) {
                System.out.println("notify in terminateThread");
            }
            tinstance.notify();
        }
    }

    public static synchronized void debugSetup(String dbgstr) {
        debugSetup = dbgstr;
        eventLog = null;
        StringTokenizer st = new StringTokenizer(debugSetup);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("-debug")) {
                debug = true;
                continue;
            }
            if (token.equals("-event")) {
                eventLog = new StringBuffer(128);
                continue;
            }
            if (token.equals("-pizza")) {
                driver = "pizza";
                continue;
            }
            if (!token.equals("-janino")) continue;
            driver = "janino";
        }
    }

    public static synchronized boolean isThreadReady() {
        return TJCThread.tinstance.ready;
    }

    public static synchronized String getEventLog() {
        if (eventLog == null) {
            return null;
        }
        return eventLog.toString();
    }

    public static synchronized void startThread() {
        if (tinstance != null && !TJCThread.tinstance.terminate_request) {
            if (debug) {
                System.out.println("thread currently running");
            }
            return;
        }
        if (debug) {
            System.out.println("creating new Thread()");
        }
        tinstance = new TJCThread();
        tmain = new Thread(tinstance);
        tmain.setDaemon(true);
        int priority = tmain.getPriority();
        if (priority > 1) {
            tmain.setPriority(--priority);
        }
        tmain.setName("TJCThread service");
        if (eventLog != null) {
            eventLog.append("thread create\n");
        }
        if (debug) {
            System.out.println("thread create");
        }
        tmain.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (eventLog != null) {
            eventLog.append("thread start\n");
        }
        if (debug) {
            System.out.println("thread start");
        }
        while (!this.terminate_request) {
            Object event;
            do {
                Vector vector = queue;
                synchronized (vector) {
                    if (queue.size() == 0) {
                        break;
                    }
                    event = (Vector)queue.remove(0);
                    if (debug) {
                        System.out.println("removed event, there are " + queue.size() + " events left");
                    }
                }
                this.processEvent((Vector)event);
            } while (!this.terminate_request);
            if (this.terminate_request) break;
            try {
                event = this;
                synchronized (event) {
                    if (eventLog != null) {
                        eventLog.append("thread wait\n");
                    }
                    if (debug) {
                        System.out.println("thread wait");
                    }
                    this.ready = true;
                    this.wait();
                    this.ready = false;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.terminate_request) break;
            if (eventLog != null) {
                eventLog.append("thread wakeup\n");
            }
            if (!debug) continue;
            System.out.println("thread wakeup");
        }
        if (this.terminate_request) {
            if (eventLog != null) {
                eventLog.append("thread terminate request\n");
            }
            if (debug) {
                System.out.println("thread terminate request");
            }
        }
        if (eventLog != null) {
            eventLog.append("thread terminated\n");
        }
        if (debug) {
            System.out.println("thread terminated");
        }
        this.terminated = true;
        if (this.interp != null) {
            if (debug) {
                System.out.println("Invoking interp.dispose()");
            }
            this.interp.dispose();
            this.interp = null;
        }
    }

    private void processEvent(Vector event) {
        block18: {
            int len = event.size();
            if (eventLog != null) {
                eventLog.append("process event\n");
            }
            if (debug) {
                System.out.println("PROCESS QUEUE EVENT: " + event);
            }
            if (len != 4) {
                throw new RuntimeException("unexpected number of event args: " + len);
            }
            String type = (String)event.elementAt(0);
            String filename = (String)event.elementAt(1);
            String source = (String)event.elementAt(2);
            CompiledClassReady callback = (CompiledClassReady)event.elementAt(3);
            if (filename.equals("__FakeTest2.java")) {
                if (eventLog != null) {
                    eventLog.append("Fake Java Test 2 processed\n");
                }
                if (debug) {
                    System.out.println("Fake Java Test 2 processed");
                }
                ArrayList<String> class_names = new ArrayList<String>();
                class_names.add("__FakeTest2");
                byte[] bytes = new byte[]{70, 65, 75, 69};
                ArrayList<byte[]> class_data = new ArrayList<byte[]>();
                class_data.add(bytes);
                callback.compiled("", filename, source, class_names, class_data, 0, "");
                return;
            }
            try {
                if (this.interp == null) {
                    if (eventLog != null) {
                        eventLog.append("Interp() and init\n");
                    }
                    if (debug) {
                        System.out.println("Interp() and init");
                    }
                    this.interp = new Interp();
                    if (driver != null) {
                        this.interp.setVar("JAVA_DRIVER", null, driver, 0);
                    }
                    this.interp.eval("source resource:/tjc/library/tjcthread.tcl");
                }
                if (type.equals("JAVA")) {
                    this.processJavaSource(filename, source, callback);
                    break block18;
                }
                if (type.equals("TCL")) {
                    this.processTclSource(filename, source, callback);
                    break block18;
                }
                throw new TclException(this.interp, "unknown type " + type);
            }
            catch (TclException te) {
                StringBuffer msg = new StringBuffer(128);
                msg.append("TclException: ");
                try {
                    TclObject ei = this.interp.getVar("errorInfo", null, 1);
                    msg.append(ei.toString());
                }
                catch (TclException e) {
                    msg.append(te.getMessage());
                }
                if (eventLog != null) {
                    eventLog.append(msg.toString());
                    eventLog.append('\n');
                }
                if (debug) {
                    System.out.println(msg.toString());
                }
                callback.compiled("", filename, source, null, null, 1, msg.toString());
            }
        }
    }

    private void processJavaSource(String filename, String source, CompiledClassReady callback) throws TclException {
        if (eventLog != null) {
            eventLog.append("process java source: " + filename + "\n");
        }
        if (debug) {
            System.out.println("processJavaSource " + filename);
        }
        TclObject cmd_obj = TclString.newInstance((String)"processJavaSource");
        TclObject filename_obj = TclString.newInstance((String)filename);
        TclObject source_obj = TclString.newInstance((String)source);
        TclObject list = TclList.newInstance();
        TclList.append((Interp)this.interp, (TclObject)list, (TclObject)cmd_obj);
        TclList.append((Interp)this.interp, (TclObject)list, (TclObject)filename_obj);
        TclList.append((Interp)this.interp, (TclObject)list, (TclObject)source_obj);
        this.interp.eval(list, 131072);
        TclObject result = this.interp.getResult();
        if (debug) {
            System.out.println("processJavaSource interp result was: " + result.toString());
        }
        ArrayList<String> class_names = new ArrayList<String>();
        ArrayList<byte[]> class_data = new ArrayList<byte[]>();
        int len = TclList.getLength((Interp)this.interp, (TclObject)result);
        for (int i = 0; i < len; i += 2) {
            TclObject name = TclList.index((Interp)this.interp, (TclObject)result, (int)i);
            TclObject reflectObj = TclList.index((Interp)this.interp, (TclObject)result, (int)(i + 1));
            class_names.add(name.toString());
            Object obj = ReflectObject.get((Interp)this.interp, (TclObject)reflectObj);
            if (!(obj instanceof byte[])) {
                throw new TclException(this.interp, "obj \"" + obj + "\" is not a byte[] instance");
            }
            class_data.add((byte[])obj);
        }
        this.interp.resetResult();
        callback.compiled("", filename, source, class_names, class_data, 0, "");
    }

    private void processTclSource(String filename, String source, CompiledClassReady callback) throws TclException {
        if (eventLog != null) {
            eventLog.append("process tcl source: " + filename + "\n");
        }
        if (debug) {
            System.out.println("processTclSource " + filename);
        }
        TclObject cmd_obj = TclString.newInstance((String)"processTclSource");
        TclObject filename_obj = TclString.newInstance((String)filename);
        TclObject source_obj = TclString.newInstance((String)source);
        TclObject list = TclList.newInstance();
        TclList.append((Interp)this.interp, (TclObject)list, (TclObject)cmd_obj);
        TclList.append((Interp)this.interp, (TclObject)list, (TclObject)filename_obj);
        TclList.append((Interp)this.interp, (TclObject)list, (TclObject)source_obj);
        this.interp.eval(list, 131072);
        TclObject processTclSourceResult = this.interp.getResult();
        String proc_name = TclList.index((Interp)this.interp, (TclObject)processTclSourceResult, (int)0).toString();
        String java_source = TclList.index((Interp)this.interp, (TclObject)processTclSourceResult, (int)1).toString();
        if (debug) {
            System.out.println("processTclSource interp result was:\n" + java_source);
        }
        cmd_obj = TclString.newInstance((String)"processJavaSource");
        filename_obj = TclString.newInstance((String)filename);
        source_obj = TclString.newInstance((String)java_source);
        list = TclList.newInstance();
        TclList.append((Interp)this.interp, (TclObject)list, (TclObject)cmd_obj);
        TclList.append((Interp)this.interp, (TclObject)list, (TclObject)filename_obj);
        TclList.append((Interp)this.interp, (TclObject)list, (TclObject)source_obj);
        this.interp.eval(list, 131072);
        TclObject result = this.interp.getResult();
        if (debug) {
            System.out.println("processTclSource interp result was: " + result.toString());
        }
        ArrayList<String> class_names = new ArrayList<String>();
        ArrayList<byte[]> class_data = new ArrayList<byte[]>();
        int len = TclList.getLength((Interp)this.interp, (TclObject)result);
        for (int i = 0; i < len; i += 2) {
            TclObject name = TclList.index((Interp)this.interp, (TclObject)result, (int)i);
            TclObject reflectObj = TclList.index((Interp)this.interp, (TclObject)result, (int)(i + 1));
            class_names.add(name.toString());
            Object obj = ReflectObject.get((Interp)this.interp, (TclObject)reflectObj);
            if (!(obj instanceof byte[])) {
                throw new TclException(this.interp, "obj \"" + obj + "\" is not a byte[] instance");
            }
            class_data.add((byte[])obj);
        }
        this.interp.resetResult();
        callback.compiled(proc_name, filename, java_source, class_names, class_data, 0, "");
    }

    protected void finalize() throws Throwable {
        if (debug) {
            System.out.println("TJCThread finalized");
        }
        super.finalize();
    }

    public static interface CompiledClassReady {
        public void compiled(String var1, String var2, String var3, ArrayList var4, ArrayList var5, int var6, String var7);
    }
}

