/*
 * Decompiled with CFR 0.152.
 */
package itcl.lang;

import itcl.lang.Cmds;
import itcl.lang.ItclClass;
import itcl.lang.ItclHierIter;
import itcl.lang.ItclInt;
import itcl.lang.ItclMember;
import itcl.lang.ItclMemberCode;
import itcl.lang.ItclMemberFunc;
import itcl.lang.ItclObject;
import itcl.lang.ItclObjectInfo;
import itcl.lang.ItclVarDefn;
import itcl.lang.ItclVarLookup;
import itcl.lang.Itcl_List;
import itcl.lang.Itcl_ListElem;
import itcl.lang.Itcl_Stack;
import itcl.lang.Methods;
import itcl.lang.Migrate;
import itcl.lang.Objects;
import itcl.lang.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.ItclAccess;
import tcl.lang.Namespace;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Var;
import tcl.lang.WrappedCommand;

class Class {
    static int itclCompatFlags = Cmds.itclCompatFlags;

    Class() {
    }

    static ItclClass CreateClass(Interp interp, String path, ItclObjectInfo info) throws TclException {
        ItclVarDefn vdefn;
        Namespace classNs = Namespace.findNamespace((Interp)interp, (String)path, null, (int)0);
        if (classNs != null && Class.IsClassNamespace(classNs)) {
            throw new TclException(interp, "class \"" + path + "\" already exists");
        }
        WrappedCommand wcmd = Namespace.findCommand((Interp)interp, (String)path, null, (int)2);
        if (wcmd != null && !Cmds.IsStub(wcmd)) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("command \"" + path + "\" already exists");
            if (path.indexOf("::") == -1) {
                buffer.append(" in namespace \"" + Namespace.getCurrentNamespace((Interp)interp).fullName + "\"");
            }
            throw new TclException(interp, buffer.toString());
        }
        Util.ParseNamespPathResult res = Util.ParseNamespPath(path);
        String head = res.head;
        String tail = res.tail;
        if (tail.indexOf(".") != -1) {
            throw new TclException(interp, "bad class name \"" + tail + "\"");
        }
        ItclClass cd = new ItclClass();
        cd.name = null;
        cd.fullname = null;
        cd.interp = interp;
        cd.info = info;
        Util.PreserveData(info);
        cd.namesp = null;
        cd.accessCmd = null;
        cd.w_accessCmd = null;
        cd.variables = new HashMap();
        cd.functions = new HashMap();
        cd.numInstanceVars = 0;
        cd.resolveVars = new HashMap();
        cd.resolveCmds = new HashMap();
        cd.bases = new Itcl_List();
        Util.InitList(cd.bases);
        cd.derived = new Itcl_List();
        Util.InitList(cd.derived);
        cd.initCode = null;
        cd.unique = 0;
        cd.flags = 0;
        cd.heritage = new HashMap();
        cd.heritage.put(cd, "");
        Util.PreserveData(cd);
        if (classNs == null) {
            classNs = Namespace.createNamespace((Interp)interp, (String)path, (Namespace.DeleteProc)new DestroyClassNamespImpl(cd));
        } else {
            if (classNs.deleteProc != null) {
                classNs.deleteProc.delete();
            }
            classNs.deleteProc = new DestroyClassNamespImpl(cd);
        }
        if (classNs == null) {
            Util.ReleaseData(cd);
            throw new TclException(interp, interp.getResult().toString());
        }
        cd.namesp = classNs;
        cd.name = classNs.name;
        cd.fullname = classNs.fullName;
        ClassResolverImpl resolver = new ClassResolverImpl();
        Namespace.setNamespaceResolver((Namespace)classNs, (Resolver)resolver);
        try {
            vdefn = Class.CreateVarDefn(interp, cd, "this", null, null);
        }
        catch (TclException ex) {
            throw new TclRuntimeError("unexpected TclException");
        }
        vdefn.member.protection = 2;
        vdefn.member.flags |= ItclInt.THIS_VAR;
        cd.variables.put("this", vdefn);
        Util.PreserveData(cd);
        interp.createCommand(cd.fullname, (Command)new HandleClassCmd(cd));
        cd.w_accessCmd = Namespace.findCommand((Interp)interp, (String)cd.fullname, null, (int)2);
        cd.accessCmd = cd.w_accessCmd.cmd;
        return cd;
    }

    static void DeleteClass(Interp interp, ItclClass cdefn) throws TclException {
        ItclClass cd = null;
        Itcl_ListElem elem = Util.FirstListElem(cdefn.derived);
        while (elem != null) {
            cd = (ItclClass)Util.GetListValue(elem);
            elem = Util.NextListElem(elem);
            try {
                Class.DeleteClass(interp, cd);
            }
            catch (TclException ex) {
                Class.DeleteClassFailed(interp, cd.namesp.fullName, ex);
            }
        }
        Iterator iter = cdefn.info.objects.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ItclObject contextObj = (ItclObject)entry.getValue();
            if (contextObj.classDefn != cdefn) continue;
            try {
                Objects.DeleteObject(interp, contextObj);
            }
            catch (TclException ex) {
                cd = cdefn;
                Class.DeleteClassFailed(interp, cd.namesp.fullName, ex);
            }
            iter = cdefn.info.objects.entrySet().iterator();
        }
        Namespace.deleteNamespace((Namespace)cdefn.namesp);
    }

    static void DeleteClassFailed(Interp interp, String fullName, TclException ex) throws TclException {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("\n    (while deleting class \"");
        buffer.append(fullName);
        buffer.append("\")");
        interp.addErrorInfo(buffer.toString());
        throw ex;
    }

    static void DestroyClass(ItclClass cdefn) {
        cdefn.accessCmd = null;
        cdefn.w_accessCmd = null;
        Namespace.deleteNamespace((Namespace)cdefn.namesp);
        Util.ReleaseData(cdefn);
    }

    static void DestroyClassNamesp(ItclClass cdefn) {
        Itcl_ListElem elem = Util.FirstListElem(cdefn.derived);
        while (elem != null) {
            ItclClass cd = (ItclClass)Util.GetListValue(elem);
            Namespace.deleteNamespace((Namespace)cd.namesp);
            elem = Util.FirstListElem(cdefn.derived);
        }
        Iterator iter = cdefn.info.objects.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ItclObject contextObj = (ItclObject)entry.getValue();
            if (contextObj.classDefn != cdefn) continue;
            cdefn.interp.deleteCommandFromToken(contextObj.w_accessCmd);
            iter = cdefn.info.objects.entrySet().iterator();
        }
        Itcl_ListElem belem = Util.FirstListElem(cdefn.bases);
        while (belem != null) {
            ItclClass base = (ItclClass)Util.GetListValue(belem);
            elem = Util.FirstListElem(base.derived);
            while (elem != null) {
                ItclClass derived = (ItclClass)Util.GetListValue(elem);
                if (derived == cdefn) {
                    Util.ReleaseData((ItclClass)Util.GetListValue(elem));
                    elem = Util.DeleteListElem(elem);
                    continue;
                }
                elem = Util.NextListElem(elem);
            }
            belem = Util.NextListElem(belem);
        }
        if (cdefn.accessCmd != null) {
            HandleClassCmd hcc = (HandleClassCmd)cdefn.accessCmd;
            hcc.release = true;
            cdefn.interp.deleteCommandFromToken(cdefn.w_accessCmd);
        }
        Util.ReleaseData(cdefn);
    }

    static void FreeClass(ItclClass cdefn) {
        Map.Entry entry;
        Itcl_ListElem elem = Util.FirstListElem(cdefn.derived);
        while (elem != null) {
            Util.ReleaseData((ItclClass)Util.GetListValue(elem));
            elem = Util.NextListElem(elem);
        }
        Util.DeleteList(cdefn.derived);
        cdefn.derived = null;
        HashMap<String, Var> varTable = new HashMap<String, Var>();
        Iterator iter = cdefn.resolveVars.entrySet().iterator();
        while (iter.hasNext()) {
            Var var;
            entry = iter.next();
            ItclVarLookup vlookup = (ItclVarLookup)entry.getValue();
            if (--vlookup.usage != 0 || (vlookup.vdefn.member.flags & ItclInt.COMMON) == 0 || vlookup.vdefn.member.classDefn != cdefn || ItclAccess.decrVarRefCount(var = vlookup.common) != 0) continue;
            varTable.put(vlookup.vdefn.member.fullname, var);
        }
        ItclAccess.deleteVars(cdefn.interp, varTable);
        cdefn.resolveVars = null;
        cdefn.resolveCmds.clear();
        cdefn.resolveCmds = null;
        iter = cdefn.variables.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            ItclVarDefn vdefn = (ItclVarDefn)entry.getValue();
            Class.DeleteVarDefn(vdefn);
        }
        cdefn.variables.clear();
        cdefn.variables = null;
        iter = cdefn.functions.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            ItclMemberFunc mfunc = (ItclMemberFunc)entry.getValue();
            Util.ReleaseData(mfunc);
        }
        cdefn.functions.clear();
        cdefn.functions = null;
        elem = Util.FirstListElem(cdefn.bases);
        while (elem != null) {
            Util.ReleaseData((ItclClass)Util.GetListValue(elem));
            elem = Util.NextListElem(elem);
        }
        Util.DeleteList(cdefn.bases);
        cdefn.bases = null;
        cdefn.heritage.clear();
        cdefn.heritage = null;
        if (cdefn.initCode != null) {
            cdefn.initCode.release();
        }
        Util.ReleaseData(cdefn.info);
        cdefn.name = null;
        cdefn.fullname = null;
    }

    static boolean IsClassNamespace(Namespace ns) {
        if (ns != null) {
            return ns.deleteProc instanceof DestroyClassNamespImpl;
        }
        return false;
    }

    static ItclClass GetClassFromNamespace(Namespace ns) {
        if (ns == null || !(ns.deleteProc instanceof DestroyClassNamespImpl)) {
            throw new TclRuntimeError("namespace is not a class namespace");
        }
        return ((DestroyClassNamespImpl)ns.deleteProc).cdefn;
    }

    static boolean IsClass(WrappedCommand wcmd) {
        HandleClassCmd hcc = null;
        if (wcmd.cmd instanceof HandleClassCmd) {
            hcc = (HandleClassCmd)wcmd.cmd;
        } else {
            WrappedCommand origCmd = Namespace.getOriginalCommand((WrappedCommand)wcmd);
            if (origCmd != null && origCmd.cmd instanceof HandleClassCmd) {
                hcc = (HandleClassCmd)origCmd.cmd;
            }
        }
        return hcc != null && !hcc.release;
    }

    static ItclClass FindClass(Interp interp, String path, boolean autoload) {
        Namespace classNs = Class.FindClassNamespace(interp, path);
        if (classNs != null && Class.IsClassNamespace(classNs)) {
            return Class.GetClassFromNamespace(classNs);
        }
        if (autoload) {
            try {
                interp.eval("::auto_load \"" + path + "\"");
            }
            catch (TclException ex) {
                interp.addErrorInfo("\n    (while attempting to autoload class \"" + path + "\")");
                return null;
            }
            interp.resetResult();
            classNs = Class.FindClassNamespace(interp, path);
            if (classNs != null && Class.IsClassNamespace(classNs)) {
                return Class.GetClassFromNamespace(classNs);
            }
        }
        String result = interp.getResult().toString();
        StringBuffer sb = new StringBuffer(64);
        sb.append(result);
        sb.append("class \"");
        sb.append(path);
        sb.append("\" not found in context \"");
        sb.append(Namespace.getCurrentNamespace((Interp)interp).fullName);
        sb.append("\"");
        interp.setResult(sb.toString());
        return null;
    }

    static Namespace FindClassNamespace(Interp interp, String path) {
        Namespace contextNs = Namespace.getCurrentNamespace((Interp)interp);
        Namespace classNs = Namespace.findNamespace((Interp)interp, (String)path, null, (int)0);
        if (classNs == null && contextNs.parent != null && !path.startsWith("::")) {
            if (contextNs.name.equals(path)) {
                classNs = contextNs;
            } else {
                StringBuffer buffer = new StringBuffer(64);
                buffer.append("::");
                buffer.append(path);
                classNs = Namespace.findNamespace((Interp)interp, (String)buffer.toString(), null, (int)0);
            }
        }
        return classNs;
    }

    static WrappedCommand ClassCmdResolver(Interp interp, String name, Namespace context, int flags) throws TclException {
        ItclClass cdefn = Class.GetClassFromNamespace(context);
        ItclMemberFunc mfunc = (ItclMemberFunc)cdefn.resolveCmds.get(name);
        if (mfunc == null) {
            return null;
        }
        if (mfunc.member.protection != 1 && !Util.CanAccessFunc(mfunc, context = Util.GetTrueNamespace(interp, cdefn.info))) {
            throw new TclException(interp, "can't access \"" + name + "\": " + Util.ProtectionStr(mfunc.member.protection) + " variable");
        }
        WrappedCommand wcmd = mfunc.w_accessCmd;
        boolean isCmdDeleted = wcmd.deleted;
        if (isCmdDeleted) {
            mfunc.accessCmd = null;
            mfunc.w_accessCmd = null;
            throw new TclException(interp, "can't access \"" + name + "\": deleted or redefined\n" + "(use the \"body\" command to redefine methods/procs)");
        }
        return mfunc.w_accessCmd;
    }

    static Var ClassVarResolver(Interp interp, String name, Namespace context, int flags) throws TclException {
        ItclVarLookup tmp;
        Var var;
        HashMap vtable;
        CallFrame varFrame = ItclAccess.getVarFrame(interp);
        Util.Assert(Class.IsClassNamespace(context), "IsClassNamespace(context)");
        ItclClass cdefn = Class.GetClassFromNamespace(context);
        if ((flags & 1) != 0) {
            return null;
        }
        if (varFrame != null && ItclAccess.isProcCallFrame(varFrame) && name.indexOf("::") == -1 && (vtable = ItclAccess.getVarTable(varFrame)) != null && (var = (Var)vtable.get(name)) != null) {
            return var;
        }
        ItclVarLookup vlookup = (ItclVarLookup)cdefn.resolveVars.get(name);
        if (vlookup == null) {
            return null;
        }
        if (!vlookup.accessible) {
            return null;
        }
        if ((vlookup.vdefn.member.flags & ItclInt.COMMON) != 0) {
            return vlookup.common;
        }
        CallFrame frame = Migrate.GetCallFrame(interp, 0);
        ItclObject contextObj = (ItclObject)cdefn.info.contextFrames.get(frame);
        if (contextObj == null) {
            return null;
        }
        if (contextObj.classDefn != vlookup.vdefn.member.classDefn && (tmp = (ItclVarLookup)contextObj.classDefn.resolveVars.get(vlookup.vdefn.member.fullname)) != null) {
            vlookup = tmp;
        }
        return contextObj.data[vlookup.index];
    }

    static void BuildVirtualTables(ItclClass cdefn) {
        boolean newEntry;
        Namespace ns;
        String key;
        ItclVarLookup vlookup;
        Map.Entry entry;
        StringBuffer buffer = new StringBuffer(64);
        StringBuffer buffer2 = new StringBuffer(64);
        Iterator iter = cdefn.resolveVars.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            vlookup = (ItclVarLookup)entry.getValue();
            if (--vlookup.usage != 0) continue;
        }
        cdefn.resolveVars.clear();
        cdefn.resolveVars = new HashMap();
        cdefn.numInstanceVars = 0;
        ++cdefn.numInstanceVars;
        ItclHierIter hier = new ItclHierIter();
        Class.InitHierIter(hier, cdefn);
        ItclClass cd = Class.AdvanceHierIter(hier);
        while (cd != null) {
            iter = cd.variables.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                key = (String)entry.getKey();
                ItclVarDefn vdefn = (ItclVarDefn)entry.getValue();
                vlookup = new ItclVarLookup();
                vlookup.vdefn = vdefn;
                vlookup.usage = 0;
                vlookup.leastQualName = null;
                boolean bl = vlookup.accessible = vdefn.member.protection != 3 || vdefn.member.classDefn == cdefn;
                if ((vdefn.member.flags & ItclInt.COMMON) != 0) {
                    ns = cd.namesp;
                    vlookup.common = (Var)ns.varTable.get(vdefn.member.name);
                    Util.Assert(vlookup.common != null, "vlookup.common != null");
                } else if ((vdefn.member.flags & ItclInt.THIS_VAR) != 0) {
                    vlookup.index = 0;
                } else {
                    ++cdefn.numInstanceVars;
                    vlookup.index = vlookup.index;
                }
                buffer.setLength(0);
                buffer.append(vdefn.member.name);
                ns = cd.namesp;
                while (true) {
                    boolean bl2 = newEntry = cdefn.resolveVars.get(key = buffer.toString()) == null;
                    if (newEntry) {
                        cdefn.resolveVars.put(key, vlookup);
                        ++vlookup.usage;
                        if (vlookup.leastQualName == null) {
                            vlookup.leastQualName = key;
                        }
                    }
                    if (ns == null) break;
                    buffer2.setLength(0);
                    buffer2.append(key);
                    buffer.setLength(0);
                    buffer.append(ns.name);
                    buffer.append("::");
                    buffer.append(buffer2.toString());
                    ns = ns.parent;
                }
                if (vlookup.usage != 0) continue;
            }
            cd = Class.AdvanceHierIter(hier);
        }
        Class.DeleteHierIter(hier);
        cdefn.resolveCmds.clear();
        cdefn.resolveCmds = new HashMap();
        Class.InitHierIter(hier, cdefn);
        cd = Class.AdvanceHierIter(hier);
        while (cd != null) {
            iter = cd.functions.entrySet().iterator();
            block5: while (iter.hasNext()) {
                entry = iter.next();
                key = (String)entry.getKey();
                ItclMemberFunc mfunc = (ItclMemberFunc)entry.getValue();
                buffer.setLength(0);
                buffer.append(mfunc.member.name);
                ns = cd.namesp;
                while (true) {
                    boolean bl = newEntry = cdefn.resolveCmds.get(key = buffer.toString()) == null;
                    if (newEntry) {
                        cdefn.resolveCmds.put(key, mfunc);
                    }
                    if (ns == null) continue block5;
                    buffer2.setLength(0);
                    buffer2.append(key);
                    buffer.setLength(0);
                    buffer.append(ns.name);
                    buffer.append("::");
                    buffer.append(buffer2.toString());
                    ns = ns.parent;
                }
            }
            cd = Class.AdvanceHierIter(hier);
        }
        Class.DeleteHierIter(hier);
    }

    static ItclVarDefn CreateVarDefn(Interp interp, ItclClass cdefn, String name, String init, String config) throws TclException {
        ItclMemberCode mcode;
        boolean newEntry;
        boolean bl = newEntry = !cdefn.variables.containsKey(name);
        if (!newEntry) {
            throw new TclException(interp, "variable name \"" + name + "\" already defined in class \"" + cdefn.fullname + "\"");
        }
        if (config != null) {
            mcode = Methods.CreateMemberCode(interp, cdefn, null, config);
            Util.PreserveData(mcode);
        } else {
            mcode = null;
        }
        ItclVarDefn vdefn = new ItclVarDefn();
        vdefn.member = Class.CreateMember(interp, cdefn, name);
        vdefn.member.code = mcode;
        if (vdefn.member.protection == 4) {
            vdefn.member.protection = 2;
        }
        vdefn.init = init;
        cdefn.variables.put(name, vdefn);
        return vdefn;
    }

    static void DeleteVarDefn(ItclVarDefn vdefn) {
        Class.DeleteMember(vdefn.member);
        vdefn.init = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String GetCommonVar(Interp interp, String name, ItclClass contextClass) {
        CallFrame frame = ItclAccess.newCallFrame(interp);
        Namespace.pushCallFrame((Interp)interp, (CallFrame)frame, (Namespace)contextClass.namesp, (boolean)false);
        try {
            TclObject val = interp.getVar(name, 0);
            if (val == null) {
                String string = null;
                return string;
            }
            String string = val.toString();
            return string;
        }
        catch (TclException ex) {
            String string = null;
            return string;
        }
        finally {
            Namespace.popCallFrame((Interp)interp);
        }
    }

    static ItclMember CreateMember(Interp interp, ItclClass cdefn, String name) {
        ItclMember mem = new ItclMember();
        mem.interp = interp;
        mem.classDefn = cdefn;
        mem.flags = 0;
        mem.protection = Util.Protection(interp, 0);
        mem.code = null;
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(cdefn.fullname);
        buffer.append("::");
        buffer.append(name);
        mem.fullname = buffer.toString();
        mem.name = name;
        return mem;
    }

    static void DeleteMember(ItclMember mem) {
        if (mem != null) {
            mem.name = null;
            mem.fullname = null;
            if (mem.code != null) {
                Util.ReleaseData(mem.code);
            }
            mem.code = null;
        }
    }

    static void InitHierIter(ItclHierIter iter, ItclClass cdefn) {
        iter.stack = new Itcl_Stack();
        Util.InitStack(iter.stack);
        Util.PushStack(cdefn, iter.stack);
        iter.current = cdefn;
    }

    static void DeleteHierIter(ItclHierIter iter) {
        Util.DeleteStack(iter.stack);
        iter.current = null;
    }

    static ItclClass AdvanceHierIter(ItclHierIter iter) {
        iter.current = (ItclClass)Util.PopStack(iter.stack);
        if (iter.current != null) {
            ItclClass cd = iter.current;
            Itcl_ListElem elem = Util.LastListElem(cd.bases);
            while (elem != null) {
                Util.PushStack(Util.GetListValue(elem), iter.stack);
                elem = Util.PrevListElem(elem);
            }
        }
        return iter.current;
    }

    static class ClassResolverImpl
    implements Resolver {
        ClassResolverImpl() {
        }

        public WrappedCommand resolveCmd(Interp interp, String name, Namespace context, int flags) throws TclException {
            return Class.ClassCmdResolver(interp, name, context, flags);
        }

        public Var resolveVar(Interp interp, String name, Namespace context, int flags) throws TclException {
            return Class.ClassVarResolver(interp, name, context, flags);
        }
    }

    static class HandleClassCmd
    implements CommandWithDispose {
        ItclClass cdefn;
        boolean release = false;

        HandleClassCmd(ItclClass cdefn) {
            this.cdefn = cdefn;
        }

        public void disposeCmd() {
            if (!this.release) {
                Class.DestroyClass(this.cdefn);
            } else {
                Util.ReleaseData(this.cdefn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length == 1) {
                return;
            }
            String token = objv[1].toString();
            if (token.equals("::") && objv.length > 2) {
                if ((this.cdefn.flags & ItclInt.OLD_STYLE) != 0) {
                    CallFrame frame = ItclAccess.newCallFrame(interp);
                    Namespace.pushCallFrame((Interp)interp, (CallFrame)frame, (Namespace)this.cdefn.namesp, (boolean)false);
                    TclObject cmdline = Util.CreateArgs(interp, null, objv, 2);
                    TclObject[] cmdlinev = TclList.getElements((Interp)interp, (TclObject)cmdline);
                    try {
                        Util.EvalArgs(interp, cmdlinev);
                        return;
                    }
                    finally {
                        Namespace.popCallFrame((Interp)interp);
                    }
                }
                throw new TclException(interp, "syntax \"class :: proc\" is an anachronism\n[incr Tcl] no longer supports this syntax.\nInstead, remove the spaces from your procedure invocations:\n  " + objv[0] + "::" + objv[2] + " ?args?");
            }
            StringBuffer buffer = new StringBuffer(64);
            String objName = null;
            String start = token;
            if (start.indexOf("#auto") != -1) {
                String suffix;
                String prefix;
                if (start.equals("#auto")) {
                    prefix = null;
                    suffix = null;
                } else if (start.startsWith("#auto")) {
                    prefix = null;
                    suffix = start.substring(5);
                } else if (start.endsWith("#auto")) {
                    prefix = start.substring(0, start.length() - 5);
                    suffix = null;
                } else {
                    int index = start.indexOf("#auto");
                    prefix = start.substring(0, index);
                    suffix = start.substring(index + 5);
                }
                StringBuffer unique = new StringBuffer(64);
                do {
                    String first = this.cdefn.name.substring(0, 1).toLowerCase();
                    unique.setLength(0);
                    unique.append(first);
                    unique.append(this.cdefn.name.substring(1));
                    unique.append(this.cdefn.unique++);
                    buffer.setLength(0);
                    if (prefix != null) {
                        buffer.append(prefix);
                    }
                    buffer.append(unique);
                    if (suffix == null) continue;
                    buffer.append(suffix);
                } while (interp.getCommand(objName = buffer.toString()) != null);
            }
            if (objName == null) {
                objName = token;
            }
            TclObject cmdline = Util.CreateArgs(interp, null, objv, 2);
            TclObject[] cmdlinev = TclList.getElements((Interp)interp, (TclObject)cmdline);
            ItclObject newObj = Objects.CreateObject(interp, objName, this.cdefn, cmdlinev);
            interp.setResult(objName);
        }
    }

    static class DestroyClassNamespImpl
    implements Namespace.DeleteProc {
        ItclClass cdefn;

        DestroyClassNamespImpl(ItclClass cdefn) {
            this.cdefn = cdefn;
        }

        public void delete() {
            Class.DestroyClassNamesp(this.cdefn);
        }
    }
}

