/*
 * Decompiled with CFR 0.152.
 */
package itcl.lang;

import itcl.lang.Class;
import itcl.lang.ItclClass;
import itcl.lang.ItclEventuallyFreed;
import itcl.lang.ItclInt;
import itcl.lang.ItclMember;
import itcl.lang.ItclMemberFunc;
import itcl.lang.ItclObjectInfo;
import itcl.lang.ItclPreservedData;
import itcl.lang.Itcl_InterpState;
import itcl.lang.Itcl_List;
import itcl.lang.Itcl_ListElem;
import itcl.lang.Itcl_Stack;
import itcl.lang.Migrate;
import java.util.Hashtable;
import java.util.Stack;
import tcl.lang.CallFrame;
import tcl.lang.Interp;
import tcl.lang.ItclAccess;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.WrappedCommand;

class Util {
    static Itcl_ListElem listPool = null;
    static int listPoolLen = 0;
    static Hashtable ItclPreservedList = new Hashtable();
    static int VALID_LIST = 33213968;
    static int LIST_POOL_SIZE = 200;
    static int STATE_VALID = 19083792;

    Util() {
    }

    static void Assert(boolean tExpr, String tExprStr) {
        if (!tExpr) {
            throw new TclRuntimeError("Itcl Assertion failed: \"" + tExprStr + "\"");
        }
    }

    static void InitStack(Itcl_Stack stack) {
        stack.s = new Stack();
    }

    static void DeleteStack(Itcl_Stack stack) {
        stack.s.clear();
        stack.s = null;
    }

    static void PushStack(Object cdata, Itcl_Stack stack) {
        stack.s.push(cdata);
    }

    static Object PopStack(Itcl_Stack stack) {
        if (stack.s != null && !stack.s.empty()) {
            return stack.s.pop();
        }
        return null;
    }

    static Object PeekStack(Itcl_Stack stack) {
        if (stack.s == null) {
            return null;
        }
        return stack.s.peek();
    }

    static Object GetStackValue(Itcl_Stack stack, int pos) {
        if (stack.s == null) {
            return null;
        }
        return stack.s.elementAt(pos);
    }

    static int GetStackSize(Itcl_Stack stack) {
        if (stack.s == null) {
            return 0;
        }
        return stack.s.size();
    }

    static void InitList(Itcl_List list) {
        list.validate = VALID_LIST;
        list.num = 0;
        list.head = null;
        list.tail = null;
    }

    static void DeleteList(Itcl_List list) {
        Util.Assert(list.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Itcl_ListElem elem = list.head;
        while (elem != null) {
            elem = Util.DeleteListElem(elem);
        }
        list.validate = 0;
    }

    static Itcl_ListElem CreateListElem(Itcl_List list) {
        Itcl_ListElem elem;
        if (listPoolLen > 0) {
            elem = listPool;
            listPool = elem.next;
            --listPoolLen;
        } else {
            elem = new Itcl_ListElem();
        }
        elem.owner = list;
        elem.value = null;
        elem.next = null;
        elem.prev = null;
        return elem;
    }

    static Itcl_ListElem DeleteListElem(Itcl_ListElem elem) {
        Itcl_ListElem next = elem.next;
        if (elem.prev != null) {
            elem.prev.next = elem.next;
        }
        if (elem.next != null) {
            elem.next.prev = elem.prev;
        }
        Itcl_List list = elem.owner;
        if (elem == list.head) {
            list.head = elem.next;
        }
        if (elem == list.tail) {
            list.tail = elem.prev;
        }
        --list.num;
        if (listPoolLen < LIST_POOL_SIZE) {
            elem.next = listPool;
            listPool = elem;
            ++listPoolLen;
        } else {
            elem = null;
        }
        return next;
    }

    static Itcl_ListElem InsertList(Itcl_List list, Object val) {
        Util.Assert(list.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Itcl_ListElem elem = Util.CreateListElem(list);
        elem.value = val;
        elem.next = list.head;
        elem.prev = null;
        if (list.head != null) {
            list.head.prev = elem;
        }
        list.head = elem;
        if (list.tail == null) {
            list.tail = elem;
        }
        ++list.num;
        return elem;
    }

    static Itcl_ListElem InsertListElem(Itcl_ListElem pos, Object val) {
        Itcl_List list = pos.owner;
        Util.Assert(list.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Itcl_ListElem elem = Util.CreateListElem(list);
        elem.value = val;
        elem.prev = pos.prev;
        if (elem.prev != null) {
            elem.prev.next = elem;
        }
        elem.next = pos;
        pos.prev = elem;
        if (list.head == pos) {
            list.head = elem;
        }
        if (list.tail == null) {
            list.tail = elem;
        }
        ++list.num;
        return elem;
    }

    static Itcl_ListElem AppendList(Itcl_List list, Object val) {
        Util.Assert(list.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Itcl_ListElem elem = Util.CreateListElem(list);
        elem.value = val;
        elem.prev = list.tail;
        elem.next = null;
        if (list.tail != null) {
            list.tail.next = elem;
        }
        list.tail = elem;
        if (list.head == null) {
            list.head = elem;
        }
        ++list.num;
        return elem;
    }

    static Itcl_ListElem AppendListElem(Itcl_ListElem pos, Object val) {
        Itcl_List list = pos.owner;
        Util.Assert(list.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Itcl_ListElem elem = Util.CreateListElem(list);
        elem.value = val;
        elem.next = pos.next;
        if (elem.next != null) {
            elem.next.prev = elem;
        }
        elem.prev = pos;
        pos.next = elem;
        if (list.tail == pos) {
            list.tail = elem;
        }
        if (list.head == null) {
            list.head = elem;
        }
        ++list.num;
        return elem;
    }

    static void SetListValue(Itcl_ListElem elem, Object val) {
        Itcl_List list = elem.owner;
        Util.Assert(list.validate == VALID_LIST, "list.validate == Util.VALID_LIST");
        Util.Assert(elem != null, "elem != null");
        elem.value = val;
    }

    static Itcl_ListElem NextListElem(Itcl_ListElem elem) {
        return elem.next;
    }

    static Itcl_ListElem PrevListElem(Itcl_ListElem elem) {
        return elem.prev;
    }

    static Itcl_ListElem FirstListElem(Itcl_List l) {
        return l.head;
    }

    static Itcl_ListElem LastListElem(Itcl_List l) {
        return l.tail;
    }

    static int GetListLength(Itcl_List l) {
        return l.num;
    }

    static Object GetListValue(Itcl_ListElem elem) {
        return elem.value;
    }

    static void EventuallyFree(ItclEventuallyFreed fobj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void PreserveData(ItclEventuallyFreed fobj) {
        if (fobj == null) {
            return;
        }
        Hashtable hashtable = ItclPreservedList;
        synchronized (hashtable) {
            ItclPreservedData chunk = (ItclPreservedData)ItclPreservedList.get(fobj);
            if (chunk == null) {
                chunk = new ItclPreservedData();
                chunk.fobj = fobj;
                chunk.usage = 0;
                ItclPreservedList.put(fobj, chunk);
            }
            if (chunk.usage >= 0) {
                ++chunk.usage;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void ReleaseData(ItclEventuallyFreed fobj) {
        boolean delEntry = false;
        if (fobj == null) {
            return;
        }
        Hashtable hashtable = ItclPreservedList;
        synchronized (hashtable) {
            ItclPreservedData chunk = (ItclPreservedData)ItclPreservedList.get(fobj);
            Util.Assert(chunk != null, "chunk != null");
            if (chunk.usage > 0 && --chunk.usage == 0) {
                chunk.usage = -1;
                delEntry = true;
            }
        }
        if (delEntry) {
            fobj.eventuallyFreed();
            hashtable = ItclPreservedList;
            synchronized (hashtable) {
                ItclPreservedList.remove(fobj);
            }
        }
    }

    static Itcl_InterpState SaveInterpState(Interp interp, int status) {
        TclObject val = null;
        Itcl_InterpState info = new Itcl_InterpState();
        info.validate = STATE_VALID;
        info.status = status;
        info.errorInfo = null;
        info.errorCode = null;
        info.objResult = interp.getResult();
        info.objResult.preserve();
        try {
            val = null;
            val = interp.getVar("errorInfo", 1);
        }
        catch (TclException ex) {
            // empty catch block
        }
        if (val != null && val.toString().length() > 0) {
            info.errorInfo = val;
            info.errorInfo.preserve();
        }
        try {
            val = null;
            val = interp.getVar("errorCode", 1);
        }
        catch (TclException ex) {
            // empty catch block
        }
        if (val != null && val.toString().length() > 0) {
            info.errorCode = val;
            info.errorCode.preserve();
        }
        interp.resetResult();
        return info;
    }

    static int RestoreInterpState(Interp interp, Itcl_InterpState state) {
        Itcl_InterpState info = state;
        Util.Assert(info.validate == STATE_VALID, "info.validate == Util.STATE_VALID");
        interp.resetResult();
        if (info.errorInfo != null) {
            interp.addErrorInfo(info.errorInfo.toString());
            info.errorInfo.release();
            info.errorInfo = null;
        }
        if (info.errorCode != null) {
            interp.setErrorCode(info.errorCode);
            info.errorCode.release();
            info.errorCode = null;
        }
        interp.setResult(info.objResult);
        info.objResult.release();
        info.objResult = null;
        int status = info.status;
        info.validate = 0;
        info = null;
        return status;
    }

    static void DiscardInterpState(Itcl_InterpState state) {
        Itcl_InterpState info = state;
        Util.Assert(info.validate == STATE_VALID, "info.validate == Util.STATE_VALID");
        if (info.errorInfo != null) {
            info.errorInfo.release();
            info.errorInfo = null;
        }
        if (info.errorCode != null) {
            info.errorCode.release();
            info.errorCode = null;
        }
        info.objResult.release();
        info.objResult = null;
        info.validate = 0;
        info = null;
    }

    static int Protection(Interp interp, int newLevel) {
        ItclObjectInfo info = (ItclObjectInfo)interp.getAssocData(ItclInt.INTERP_DATA);
        Util.Assert(info != null, "info != null");
        int oldVal = info.protection;
        if (newLevel != 0) {
            Util.Assert(newLevel == 1 || newLevel == 2 || newLevel == 3 || newLevel == 4, "newLevel Protection");
            info.protection = newLevel;
        }
        return oldVal;
    }

    static String ProtectionStr(int pLevel) {
        switch (pLevel) {
            case 1: {
                return "public";
            }
            case 2: {
                return "protected";
            }
            case 3: {
                return "private";
            }
        }
        return "<bad-protection-code>";
    }

    static boolean CanAccess(ItclMember member, Namespace fromNs) {
        if (member.protection == 1) {
            return true;
        }
        if (member.protection == 3) {
            return member.classDefn.namesp == fromNs;
        }
        Util.Assert(member.protection == 2, "member.protection == Itcl.PROTECTED");
        if (Class.IsClassNamespace(fromNs)) {
            ItclClass fromCd = Class.GetClassFromNamespace(fromNs);
            Object entry = fromCd.heritage.get(member.classDefn);
            if (entry != null) {
                return true;
            }
        }
        return false;
    }

    static boolean CanAccessFunc(ItclMemberFunc mfunc, Namespace fromNs) {
        if (Util.CanAccess(mfunc.member, fromNs)) {
            return true;
        }
        if ((mfunc.member.flags & ItclInt.COMMON) == 0 && Class.IsClassNamespace(fromNs)) {
            Object entry;
            ItclClass cd = mfunc.member.classDefn;
            ItclClass fromCd = Class.GetClassFromNamespace(fromNs);
            if (cd.heritage.get(fromCd) != null && (entry = fromCd.resolveCmds.get(mfunc.member.name)) != null) {
                ItclMemberFunc ovlfunc = (ItclMemberFunc)entry;
                if ((ovlfunc.member.flags & ItclInt.COMMON) == 0 && ovlfunc.member.protection < 3) {
                    return true;
                }
            }
        }
        return false;
    }

    static Namespace GetTrueNamespace(Interp interp, ItclObjectInfo info) {
        boolean transparent = false;
        CallFrame frame = Migrate.GetCallFrame(interp, 0);
        for (int i = Util.GetStackSize(info.transparentFrames) - 1; i >= 0; --i) {
            CallFrame transFrame = (CallFrame)Util.GetStackValue(info.transparentFrames, i);
            if (frame != transFrame) continue;
            transparent = true;
            break;
        }
        Namespace contextNs = transparent ? ((frame = Migrate.GetCallFrame(interp, 1)) != null ? ItclAccess.getCallFrameNamespace(frame) : Namespace.getGlobalNamespace((Interp)interp)) : Namespace.getCurrentNamespace((Interp)interp);
        return contextNs;
    }

    static ParseNamespPathResult ParseNamespPath(String name) {
        String head;
        String tail;
        int i = name.length();
        while (--i > 0 && (name.charAt(i) != ':' || name.charAt(i - 1) != ':')) {
        }
        if (i > 0) {
            tail = name.substring(i + 1);
            while (i > 0 && name.charAt(i - 1) == ':') {
                --i;
            }
            head = name.substring(0, i);
        } else {
            tail = name;
            head = null;
        }
        return new ParseNamespPathResult(head, tail);
    }

    static DecodeScopedCommandResult DecodeScopedCommand(Interp interp, String name) throws TclException {
        Namespace ns = null;
        int len = name.length();
        TclObject[] listv = null;
        TclException ex = null;
        String cmdName = name;
        if (len > 17 && name.startsWith("namespace ")) {
            int pos;
            for (pos = 9; pos < len && name.charAt(pos) == ' '; ++pos) {
            }
            if (pos + 8 <= len && name.charAt(pos) == 'i' && name.substring(pos, pos + 8).equals("inscope ")) {
                try {
                    listv = TclList.getElements((Interp)interp, (TclObject)TclString.newInstance((String)name));
                }
                catch (TclException e) {
                    ex = e;
                }
                if (ex == null) {
                    if (listv.length != 4) {
                        ex = new TclException(interp, "malformed command \"" + name + "\": should be \"" + "namespace inscope namesp command\"");
                    } else {
                        String findNS = listv[2].toString();
                        ns = Namespace.findNamespace((Interp)interp, (String)findNS, null, (int)512);
                        if (ns == null) {
                            ex = new TclException(interp, interp.getResult().toString());
                        } else {
                            cmdName = listv[3].toString();
                        }
                    }
                }
                if (ex != null) {
                    String msg = "\n    (while decoding scoped command \"" + name + "\")";
                    interp.addErrorInfo(msg);
                    throw ex;
                }
            }
        }
        DecodeScopedCommandResult r = new DecodeScopedCommandResult();
        r.rNS = ns;
        r.rCmd = cmdName;
        return r;
    }

    static void EvalArgs(Interp interp, TclObject[] objv) throws TclException {
        TclObject cmdline = null;
        WrappedCommand wcmd = Namespace.findCommand((Interp)interp, (String)objv[0].toString(), null, (int)0);
        TclObject[] cmdlinev = objv;
        if (wcmd == null) {
            wcmd = Namespace.findCommand((Interp)interp, (String)"unknown", null, (int)1);
            if (wcmd == null) {
                interp.resetResult();
                throw new TclException(interp, "invalid command name \"" + objv[0].toString() + "\"");
            }
            cmdline = Util.CreateArgs(interp, "unknown", objv, 0);
            cmdlinev = TclList.getElements((Interp)interp, (TclObject)cmdline);
        }
        interp.resetResult();
        wcmd.cmd.cmdProc(interp, cmdlinev);
    }

    static TclObject CreateArgs(Interp interp, String string, TclObject[] objv, int skip) throws TclException {
        TclObject list = TclList.newInstance();
        if (string != null) {
            TclList.append((Interp)interp, (TclObject)list, (TclObject)TclString.newInstance((String)string));
        }
        if (objv != null) {
            for (int i = skip; i < objv.length; ++i) {
                TclList.append((Interp)interp, (TclObject)list, (TclObject)objv[i]);
            }
        }
        list.preserve();
        return list;
    }

    static void StartSublist(StringBuffer buffer) {
        if (Util.NeedSpace(buffer)) {
            buffer.append(" {");
        } else {
            buffer.append('{');
        }
    }

    static void EndSublist(StringBuffer buffer) {
        buffer.append('}');
    }

    static void AppendElement(StringBuffer buffer, String elem) {
        if (Util.NeedSpace(buffer)) {
            buffer.append(' ');
        }
        buffer.append(elem);
    }

    static boolean NeedSpace(StringBuffer buffer) {
        int len = buffer.length();
        if (len == 0) {
            return false;
        }
        int end = len - 1;
        while (buffer.charAt(end) == '{') {
            if (end == 0) {
                return false;
            }
            --end;
        }
        return !Character.isSpaceChar(buffer.charAt(end)) || end != 0 && buffer.charAt(end - 1) == '\\';
    }

    static class DecodeScopedCommandResult {
        Namespace rNS;
        String rCmd;

        DecodeScopedCommandResult() {
        }
    }

    static class ParseNamespPathResult {
        String head;
        String tail;

        ParseNamespPathResult(String head, String tail) {
            this.head = head;
            this.tail = tail;
        }
    }
}

