/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import org.ocamljava.runtime.annotations.primitives.AbstractPrimitivesConverter;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;

public final class Primitives2CompatibilityXML
extends AbstractPrimitivesConverter {
    private final PrintStream out;

    private Primitives2CompatibilityXML(String string, String string2) throws IOException {
        super(string, null);
        assert (string2 != null) : "null f";
        this.out = new PrintStream(string2);
    }

    private static String normalize(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(string.charAt(i));
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String concat(String[] stringArray) {
        assert (stringArray != null) : "null lines";
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : stringArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(Primitives2CompatibilityXML.normalize(string));
        }
        return stringBuilder.toString();
    }

    @Override
    protected void beforeWalk() {
        this.out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.out.println("<primitives>");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void visitClass(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            PrimitiveProvider primitiveProvider = clazz.getAnnotation(PrimitiveProvider.class);
            if (primitiveProvider == null) return;
            for (Method method : clazz.getDeclaredMethods()) {
                Primitive primitive = method.getAnnotation(Primitive.class);
                if (primitive == null) continue;
                this.out.printf("  <primitive library=\"%s\" module=\"%s\" name=\"%s\" source=\"%s\" compatibility=\"%s\" comment=\"%s\"/>\n", primitiveProvider.library(), primitive.module().equals("") ? primitiveProvider.module() : primitive.module(), method.getName(), primitiveProvider.source(), primitive.compatibility().toString().toLowerCase(), Primitives2CompatibilityXML.concat(primitive.comment()));
            }
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void afterWalk() {
        this.out.println("</primitives>");
        this.out.close();
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.err;
        if (stringArray.length == 2) {
            try {
                Primitives2CompatibilityXML primitives2CompatibilityXML = new Primitives2CompatibilityXML(stringArray[0], stringArray[1]);
                primitives2CompatibilityXML.walkFileTree();
            }
            catch (IOException iOException) {
                printStream.printf("i/o error: %s\n", iOException.getMessage());
                System.exit(1);
            }
            System.exit(0);
        } else {
            printStream.println("error: a path, and a file should be provided");
            System.exit(1);
        }
    }
}

