#
#  Copyright (c) 2005 Advanced Micro Devices, Inc.
#
#  See the file "license.amd" for information on usage and
#  redistribution of this file, and for a DISCLAIMER OF ALL
#   WARRANTIES.
#
#  RCS: @(#) $Id: parse.tcl,v 1.4 2006/05/29 21:56:14 mdejong Exp $
#
#

# This module contains functions that access the contents
# of a parse result. Most of the time, this will involve
# decoding a parse subtree to see what it contains.

# Return true if the subtree is a simple/text type.
# This method is called frequently by all the
# modules, so it is optimized so as to make it
# execute as quickly as possible.

TJC::command parse_is_simple_text tjc.ParseIsSimpleTextCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return a simple text string given a simple/text subtree
# and the script it was generated from. This function
# assumes that the parse_is_simple_text has already
# been invoked and has returned true for this subtree.
# The default rtype is "simple" meaning return the
# range defined in the simple tuple. If the rtype "text"
# is passed then the range defined by the text subtree
# element is defined. The text range can be a subrange
# of the simple range in the case of a quoted string.

TJC::command parse_get_simple_text tjc.ParseGetSimpleTextCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Like above, but return the range

TJC::command parse_get_simple_text_range tjc.ParseGetSimpleTextRangeCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if the inner range is contained inside the
# outer range. For example, a quoted string has
# an outer range that includes the quotes and
# an inner range that does not. This method returns
# 1 if the ranges are identical.

TJC::command parse_is_subrange tjc.ParseIsSubrangeCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return 1 if this is a "word" type. A word type can contain
# nested commands and variables.

TJC::command parse_is_word tjc.ParseIsWordCmd
#
#
#
#
#
#
#

# Return 1 if this is a word/command type. This is the type used
# for a nested command as a command argument.

TJC::command parse_is_word_command tjc.ParseIsWordCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return the nested command text for a word/command type
# given a subtree and the script it was generated from.
# This function assumes that parse_is_word_command
# has already been invoked and returned true for this subtree.

TJC::command parse_get_word_command tjc.ParseGetWordCommandCmd
#
#
#
#
#
#
#

# Return 1 if this is a word/variable type. This is the type used
# for a command argument that is a variable.

TJC::command parse_is_word_variable tjc.ParseIsWordVariableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return word variable text string given a word/variable subtree
# and the script it was generated from. This function
# assumes that the parse_is_word_variable has already
# been invoked and has returned true for this subtree.
# The default rtype is "variable" meaning return the
# range defined in the variable tuple which includes the
# dollar sign. If the "text" rtype is passed, then only
# the variable name after the dollar sign is returned.

TJC::command parse_get_word_variable tjc.ParseGetWordVariableCmd
#
#
#
#
#
#
#

# Return variable text string given a variable subtree
# and the script it was generated from. This function
# assumes that the parse_is_variable has already
# been invoked and has returned true for this subtree.
# The default rtype is "variable" meaning return the
# range defined in the variable tuple which includes the
# dollar sign. If the "text" rtype is passes then only
# the variable name after the dollar sign is returned.

TJC::command parse_get_variable tjc.ParseGetVariableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the subtree is a text type.

TJC::command parse_is_text tjc.ParseIsTextCmd
#
#

# Return the text string indicated by a text subtree
# given the subtree and the script it was generated from.

TJC::command parse_get_text tjc.ParseGetTextCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Given a nested command invocation like "set i [foo]",
# return the range for "foo" (inside the brackets).

TJC::command parse_range_without_brackets tjc.ParseRangeWithoutBracketsCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the text denoted by range is enclosed in braces.

TJC::command parse_is_braced tjc.ParseIsBracedCmd
#
#
#
#
#
#
#
#
#
#
#
#
#

# Given a range for a braced string like "{foo}",
# return the range for "foo" (inside the braces).

TJC::command parse_range_without_braces tjc.ParseRangeWithoutBracesCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the given stree indicates a constant value
# text element. For example, a simple/text element is a
# constant word. A word element that is braces would be
# treated as a simple/text except for the special case of
# a backslash newline subst. If a backslash newline subst
# if found, then treat it as a constant. An unbraced string
# that contains regular backslash elements like \t would
# not be considered constant here.

TJC::command parse_is_constant tjc.ParseIsConstantCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked while iterating over the elements of a word
# during parse_is_constant. This method checks that
# a word is made up of either constant elements
# or the special backslash newline element.

TJC::command _parse_is_constant_word_iterate tjc.ParseIsConstantWordIterateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# This method assumes that parse_is_constant has already
# returned true for this stree. The method will return
# a list of elements. The first is the constant string.
# The second is the quote characters, either "", "{}",
# or "\"\"". The third element is the string without
# the surrounding quote characters.

TJC::command parse_get_constant_text tjc.ParseGetConstantTextCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Combine range of each tree element to get the range of the
# whole tree.

TJC::command parse_range_of_tree tjc.ParseRangeOfTreeCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the subtree is a variable type

TJC::command parse_is_variable tjc.ParseIsVariableCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if a variable subtree is for a scalar
# variable.

TJC::command parse_is_scalar_variable tjc.ParseIsScalarVariableCmd
#
#
#
#
#
#
#
#
#
#

# Return name of scalar variable in stree. This
# is much faster than setting up a whole variable
# scan for a simple scalar variable.

TJC::command parse_get_scalar_variable tjc.ParseGetScalarVariableCmd
#
#
#
#
#
#
#

# Given a subtree for a variable type, return a
# list describing the variable and any additional
# elements contained inside the word key.

TJC::command parse_get_variable_list tjc.ParseGetVariableListCmd
#
#
#
#
#
#
#
#
#

# Callback invoked as a result of parsing a variable.

TJC::command _parse_get_variable_list_callback tjc.ParseGetVariableListCallbackCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Convert a variable inner tree to a list of types contained inside
# the inner tree.

TJC::command _parse_variable_subtree_types tjc.ParseVariableSubtreeTypesCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#


# Return true if the subtree is a command type.

TJC::command parse_is_command tjc.ParseIsCommandCmd
#
#

# Return the command text inside the brackets for a command type.

TJC::command parse_get_command tjc.ParseGetCommandCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Iterate over the contents of a variable. Pass
# the variable parse subtree and the script it
# was generated from along with the name of
# a callback command to invoke.

TJC::command parse_variable_iterate tjc.ParseVariableIterateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

TJC::command _parse_variable_iterate tjc.ParseVariableIterateCmd2
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Called to query the current value of a array variable
# word key or to set a new value. This method only has meaning
# after a {word begin} but before a {word end} iteration
# pair. If a value for the word key is not set it will be {}.

TJC::command parse_variable_iterate_word_value tjc.ParseVariableIterateWordValueCmd
#
#
#
#
#
#
#
#
#
#

# Iterate over the contents of a word. A word can be made
# up of text, variable, and command elements. Pass
# the word parse subtree and the script it was generated
# from along with the name of a callback command to invoke.

TJC::command parse_word_iterate tjc.ParseWordIterateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Called to query the current value of a word value
# as its elements are being iterated over or to set
# a new value. This method should only be used during
# a word iteration callback. The result word value will
# be returned by parse_word_iterate.

TJC::command parse_word_iterate_word_value tjc.ParseWordIterateWordValueCmd
#
#
#
#
#
#
#
#
#
#






# Iterate over expr subexpressions starting from the inner
# most one and progressing outward. Expressions can invoke
# the in_cmd callback to evaluate operands and expressions
# and so on. The in_cmd callback should invoke
# parse_expr_iterate_type_value to set the type and
# result for an operand or expression evaluation.
# The result value will be passed as a value type and will
# also be returned by this function. If values are not set
# then the value returning code will not be used. This
# procedure is recursion safe since the entire expr is descended
# into before any callbacks that might invoke parse_expr_iterate
# again are invoked.
#
# The in_cmd callback should accept 5 arguments as follows:
# { script etree type values ranges }

TJC::command parse_expr_iterate tjc.ParseExprIterateCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked when a "value" element is found while iterating over an expr. A value
# argument may be evaluated by the callback.

TJC::command _parse_expr_iterate_evaluate_value tjc.ParseExprIterateEvaluateValueCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked when a "subexpr" element is found while iterating over an expr.

TJC::command _parse_expr_iterate_subexpr tjc.ParseExprIterateSubexprCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Return true if the given operator is a math function defined in Tcl.

TJC::command _parse_expr_iterate_is_math_function tjc.ParseExprIterateIsMathFunctionCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Descend into expression tree and create a result that starts with
# the inner most expression and ends with the outer most one.

TJC::command _parse_expr_iterate_descend tjc.ParseExprIterateDescendCmd
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#
#

# Invoked to indicate that a type and value pair for
# an operand or a subexpression is available. The value
# for an operand will be passed to an operator. The
# value for a subexpession will be passed to the enclosing
# subexpression. If no value is set a placeholder will
# be passed for the value.

TJC::command parse_expr_iterate_type_value tjc.ParseExprIterateTypeValueCmd
#
#
#


