/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import org.ocamljava.runtime.values.Value;

public final class GCState {
    private long gcMinorHeapSize = 32768L;
    private long gcMajorHeapIncrement = 63488L;
    private long gcSpaceOverhead = 80L;
    private long gcVerbose = 0L;
    private long gcMaxOverhead = 500L;
    private long gcStackLimit = 262144L;
    private long gcMinorCounter = 0L;
    private long gcMajorCounter = 0L;
    private long gcCompactionCounter = 0L;
    private long gcAllocationPolicy = 0L;

    GCState() {
    }

    public Value makeGcParams() {
        return Value.createBlock(0, Value.createLong(this.gcMinorHeapSize), Value.createLong(this.gcMajorHeapIncrement), Value.createLong(this.gcSpaceOverhead), Value.createLong(this.gcVerbose), Value.createLong(this.gcMaxOverhead), Value.createLong(this.gcStackLimit), Value.createLong(this.gcAllocationPolicy));
    }

    public void setGcParams(Value params) {
        assert (params != null) : "null params";
        this.gcMinorHeapSize = params.get0().asLong();
        this.gcMajorHeapIncrement = params.get1().asLong();
        this.gcSpaceOverhead = params.get2().asLong();
        this.gcVerbose = params.get3().asLong();
        this.gcMaxOverhead = params.get4().asLong();
        this.gcStackLimit = params.get5().asLong();
        long ap = params.get6().asLong();
        this.gcAllocationPolicy = ap >= 0L && ap <= 1L ? ap : 1L;
    }

    public Value makeGcStats() {
        double totalMemory = Runtime.getRuntime().totalMemory() / 8L;
        Value totalMemoryAsValue = Value.createLong((long)totalMemory);
        Value res = Value.createBlock(0, 16L);
        res.set0(Value.createDouble(totalMemory));
        res.set1(Value.createDouble(totalMemory));
        res.set2(Value.createDouble(totalMemory));
        res.set3(Value.createLong(this.gcMinorCounter));
        res.set4(Value.createLong(this.gcMajorCounter));
        res.set5(totalMemoryAsValue);
        res.set6(Value.ONE);
        res.set7(Value.ZERO);
        res.set(8, Value.ZERO);
        res.set(9, Value.ZERO);
        res.set(10, Value.ZERO);
        res.set(11, Value.ZERO);
        res.set(12, Value.ZERO);
        res.set(13, Value.createLong(this.gcCompactionCounter));
        res.set(14, totalMemoryAsValue);
        res.set(15, Value.ZERO);
        return res;
    }

    public Value makeGcCounters() {
        double totalMemory = Runtime.getRuntime().totalMemory() / 8L;
        return Value.createBlock(0, Value.createDouble(totalMemory), Value.createDouble(totalMemory), Value.createDouble(totalMemory));
    }

    public void incMinorCounter() {
        ++this.gcMinorCounter;
    }

    public void incMajorCounter() {
        ++this.gcMajorCounter;
    }

    public void incCompactionCounter() {
        ++this.gcCompactionCounter;
    }
}

