/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.ByteCodeRunner;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Debug;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FailException;
import org.ocamljava.runtime.kernel.FatalError;
import org.ocamljava.runtime.kernel.Misc;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.Value;

public final class StandardError {
    private StandardError() {
    }

    public static void reportNativeException(AbstractNativeRunner runner, Throwable exception) {
        Context context = CurrentContext.get();
        Channel ch = context.getFilesState().getChannel(2);
        if (ch != null) {
            PrintStream ps = new PrintStream(ch.newOutputStream(), true);
            if (exception instanceof FailException) {
                String msg = Misc.convertException(((FailException)exception).getValue(), null);
                ps.println("Fatal error: exception " + msg);
                if (context.getCodeState().isBacktraceActive() || Debug.initDebugEnabled()) {
                    runner.printExceptionBacktrace(ps);
                }
            } else if (exception instanceof FatalError) {
                ps.println("Fatal error: " + ((FatalError)exception).getMessage());
            } else {
                Throwable exception2 = null;
                try {
                    Fail.raise(Fail.asValue(exception));
                }
                catch (Throwable t) {
                    exception2 = t;
                }
                StandardError.reportNativeException(runner, exception2);
            }
        }
    }

    public static void reportBytecodeException(ByteCodeRunner runner, Throwable exception) throws OCamlJavaException {
        PrintStream err;
        ByteArrayOutputStream altErr;
        Context context = CurrentContext.get();
        Channel ch = context.getFilesState().getChannel(2);
        if (ch != null && ch.isOutputChannel()) {
            altErr = null;
            err = new PrintStream(ch.newOutputStream(), true);
        } else {
            altErr = new ByteArrayOutputStream();
            err = new PrintStream(altErr, true);
        }
        if (exception instanceof FailException) {
            CodeState codeState = context.getCodeState();
            Value globalData = codeState.getGlobalData();
            String msg = Misc.convertException(((FailException)exception).getValue(), globalData);
            err.println("Fatal error: exception " + msg);
            if (codeState.isBacktraceActive() && !context.getDebuggerState().isDebuggerInUse()) {
                runner.printExceptionBacktrace(err);
            }
            if (altErr == null) {
                err.close();
            }
            throw new OCamlJavaException(altErr != null ? altErr.toString() : "program exception", exception);
        }
        if (exception instanceof FatalError) {
            err.println(((FatalError)exception).getMessage());
            if (altErr == null) {
                err.close();
            }
            throw new OCamlJavaException(altErr != null ? altErr.toString() : "fatal error", exception);
        }
        err.println(exception.toString());
        if (altErr == null) {
            err.close();
        }
        throw new OCamlJavaException(altErr != null ? altErr.toString() : "internal error", exception);
    }

    public static void reportThreadException(Thread thread, Throwable exception) {
        Channel ch = CurrentContext.getFilesState().getChannel(2);
        if (ch != null) {
            PrintStream ps = new PrintStream(ch.newOutputStream(), true);
            ps.printf("Thread '%s' raised an exception: ", thread.getName());
            if (exception instanceof FailException) {
                Value e = ((FailException)exception).getValue();
                ps.println(Misc.convertException(e, null));
            } else {
                ps.println(exception.getClass().getName());
            }
        }
    }
}

