/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.util.HashMap;
import java.util.Map;
import org.ocamljava.runtime.values.Value;

public final class PredefinedExceptions {
    public final Value exnOutOfMemory;
    public final Value exnSysError;
    public final Value exnFailure;
    public final Value exnInvalidArgument;
    public final Value exnEndOfFile;
    public final Value exnDivisionByZero;
    public final Value exnNotFound;
    public final Value exnMatchFailure;
    public final Value exnStackOverflow;
    public final Value exnSysBlockedIO;
    public final Value exnAssertFailure;
    public final Value exnUndefinedRecursiveModule;
    public final Value exnJavaException;
    public final Value exnJavaError;
    private static final int OUT_OF_MEMORY_EXCEPTION = 0;
    private static final int SYS_ERROR_EXCEPTION = 1;
    private static final int FAILURE_EXCEPTION = 2;
    private static final int INVALID_EXCEPTION = 3;
    private static final int END_OF_FILE_EXCEPTION = 4;
    private static final int ZERO_DIVIDE_EXCEPTION = 5;
    private static final int NOT_FOUND_EXCEPTION = 6;
    private static final int MATCH_FAILURE_EXCEPTION = 7;
    private static final int STACK_OVERFLOW_EXCEPTION = 8;
    private static final int SYS_BLOCKED_IO_EXCEPTION = 9;
    private static final int ASSERT_FAILURE_EXCEPTION = 10;
    private static final int UNDEFINED_RECURSIVE_MODULE_EXCEPTION = 11;
    private static final int JAVA_EXCEPTION = 12;
    private static final int JAVA_ERROR = 13;

    private static Value buildPredefinedException(String name) {
        assert (name != null) : "null name";
        String symName = "caml_exn_" + name;
        Value symValue = Value.createBlock(0, Value.createString(name));
        return symValue;
    }

    public PredefinedExceptions() {
        this.exnOutOfMemory = PredefinedExceptions.buildPredefinedException("Out_of_memory");
        this.exnSysError = PredefinedExceptions.buildPredefinedException("Sys_error");
        this.exnFailure = PredefinedExceptions.buildPredefinedException("Failure");
        this.exnInvalidArgument = PredefinedExceptions.buildPredefinedException("Invalid_argument");
        this.exnEndOfFile = PredefinedExceptions.buildPredefinedException("End_of_file");
        this.exnDivisionByZero = PredefinedExceptions.buildPredefinedException("Division_by_zero");
        this.exnNotFound = PredefinedExceptions.buildPredefinedException("Not_found");
        this.exnMatchFailure = PredefinedExceptions.buildPredefinedException("Match_failure");
        this.exnStackOverflow = PredefinedExceptions.buildPredefinedException("Stack_overflow");
        this.exnSysBlockedIO = PredefinedExceptions.buildPredefinedException("Sys_blocked_io");
        this.exnAssertFailure = PredefinedExceptions.buildPredefinedException("Assert_failure");
        this.exnUndefinedRecursiveModule = PredefinedExceptions.buildPredefinedException("Undefined_recursive_module");
        this.exnJavaException = PredefinedExceptions.buildPredefinedException("Java_exception");
        this.exnJavaError = PredefinedExceptions.buildPredefinedException("Java_error");
    }

    public Map<String, Value> initialMap() {
        HashMap<String, Value> res = new HashMap<String, Value>();
        res.put("caml_exn_Out_of_memory", this.exnOutOfMemory);
        res.put("caml_exn_Sys_error", this.exnSysError);
        res.put("caml_exn_Failure", this.exnFailure);
        res.put("caml_exn_Invalid_argument", this.exnInvalidArgument);
        res.put("caml_exn_End_of_file", this.exnEndOfFile);
        res.put("caml_exn_Division_by_zero", this.exnDivisionByZero);
        res.put("caml_exn_Not_found", this.exnNotFound);
        res.put("caml_exn_Match_failure", this.exnMatchFailure);
        res.put("caml_exn_Stack_overflow", this.exnStackOverflow);
        res.put("caml_exn_Sys_blocked_io", this.exnSysBlockedIO);
        res.put("caml_exn_Assert_failure", this.exnAssertFailure);
        res.put("caml_exn_Undefined_recursive_module", this.exnUndefinedRecursiveModule);
        res.put("caml_exn_Java_exception", this.exnJavaException);
        res.put("caml_exn_Java_error", this.exnJavaError);
        return res;
    }

    public PredefinedExceptions(Value globalData) {
        this.exnOutOfMemory = globalData.get(0);
        this.exnSysError = globalData.get(1);
        this.exnFailure = globalData.get(2);
        this.exnInvalidArgument = globalData.get(3);
        this.exnEndOfFile = globalData.get(4);
        this.exnDivisionByZero = globalData.get(5);
        this.exnNotFound = globalData.get(6);
        this.exnMatchFailure = globalData.get(7);
        this.exnStackOverflow = globalData.get(8);
        this.exnSysBlockedIO = globalData.get(9);
        this.exnAssertFailure = globalData.get(10);
        this.exnUndefinedRecursiveModule = globalData.get(11);
        this.exnJavaException = null;
        this.exnJavaError = null;
    }
}

