/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.MurmurHash3;
import org.ocamljava.runtime.util.PlatformUtils;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Hashtbl", source="byterun/hash.c")
public final class Hash {
    private static final long QUEUE_SIZE = 256L;

    private Hash() {
    }

    public static int caml_hash_mix_uint32(int hash, int d) {
        return MurmurHash3.mix32(hash, d);
    }

    public static int caml_hash_mix_intnat(int hash, long d) {
        int n = (int)(d >> 32 ^ d >> 63 ^ d);
        return MurmurHash3.mix32(hash, n);
    }

    public static int caml_hash_mix_int64(int hash, long d) {
        int hi = PlatformUtils.isBigEndianPlatform() ? (int)(d & 0xFFFFFFFFL) : (int)(d >>> 32);
        int lo = PlatformUtils.isBigEndianPlatform() ? (int)(d >>> 32) : (int)(d & 0xFFFFFFFFL);
        int h = MurmurHash3.mix32(hash, lo);
        h = MurmurHash3.mix32(h, hi);
        return h;
    }

    public static int caml_hash_mix_double(int hash, double d) {
        int lo;
        long bits = Double.doubleToRawLongBits(d);
        int hi = PlatformUtils.isBigEndianPlatform() ? (int)(bits & 0xFFFFFFFFL) : (int)(bits >>> 32);
        int n = lo = PlatformUtils.isBigEndianPlatform() ? (int)(bits >>> 32) : (int)(bits & 0xFFFFFFFFL);
        if ((hi & 0x7FF00000) == 0x7FF00000 && (lo | hi & 0xFFFFF) != 0) {
            hi = 0x7FF00000;
            lo = 1;
        } else if (hi == Integer.MIN_VALUE && lo == 0) {
            hi = 0;
        }
        int res = MurmurHash3.mix32(hash, lo);
        res = MurmurHash3.mix32(res, hi);
        return res;
    }

    public static int caml_hash_mix_float(int hash, float d) {
        int bits = Float.floatToRawIntBits(d);
        if ((bits & 0x7F800000) == 2139095040 && (bits & 0x7FFFFF) != 0) {
            bits = 2139095041;
        } else if (bits == Integer.MIN_VALUE) {
            bits = 0;
        }
        return MurmurHash3.mix32(hash, bits);
    }

    public static int caml_hash_mix_string(int hash, Value s) {
        int w;
        int[] bytes = s.getUnsignedBytes();
        int len = bytes.length;
        int h = hash;
        int i = 0;
        while (i + 4 <= len) {
            w = bytes[i] | bytes[i + 1] << 8 | bytes[i + 2] << 16 | bytes[i + 3] << 24;
            h = MurmurHash3.mix32(h, w);
            i += 4;
        }
        switch (len & 3) {
            case 0: {
                w = 0;
                break;
            }
            case 1: {
                w = bytes[i];
                break;
            }
            case 2: {
                w = bytes[i] | bytes[i + 1] << 8;
                break;
            }
            case 3: {
                w = bytes[i] | bytes[i + 1] << 8 | bytes[i + 2] << 16;
                break;
            }
            default: {
                assert (false) : "should not happen";
                w = 0;
            }
        }
        if (w != 0) {
            h = MurmurHash3.mix32(h, w);
        }
        return h ^ len;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "'a"}, returnType="int")
    public static Value caml_hash(Value count, Value limit, Value seed, Value obj) {
        Value[] queue = new Value[256];
        long lmt = limit.asLong();
        int sz = lmt < 0L || lmt > 256L ? 256 : (int)lmt;
        long num = count.asLong();
        int h = seed.asCastedInt();
        queue[0] = obj;
        int rd = 0;
        int wr = 1;
        boolean again = false;
        Value v = null;
        block10: while (rd < wr && num > 0L) {
            if (again) {
                again = false;
            } else {
                v = queue[rd++];
            }
            if (v.isLong()) {
                h = Hash.caml_hash_mix_intnat(h, v.getRawValue());
                --num;
                continue;
            }
            int tag = v.getTag();
            block0 : switch (tag) {
                case 252: {
                    h = Hash.caml_hash_mix_string(h, v);
                    --num;
                    break;
                }
                case 253: {
                    h = Hash.caml_hash_mix_double(h, v.asDouble());
                    --num;
                    break;
                }
                case 254: {
                    long i;
                    long szDoubles = v.sizeDoubles();
                    for (i = 0L; i < szDoubles; ++i) {
                        h = Hash.caml_hash_mix_double(h, v.getDouble(i));
                        if (--num < 0L) break block0;
                    }
                    continue block10;
                }
                case 251: {
                    break;
                }
                case 249: {
                    h = Hash.caml_hash_mix_uint32(h, (int)(v.getWoSize() * 8L));
                    v = v.getParent();
                    again = true;
                    continue block10;
                }
                case 250: {
                    v = v.get0();
                    again = true;
                    continue block10;
                }
                case 248: {
                    h = Hash.caml_hash_mix_intnat(h, v.get1().asLong());
                    --num;
                    break;
                }
                case 255: {
                    CustomOperations ops = obj.getCustomOperations();
                    if (!ops.isHashable()) continue block10;
                    h = Hash.caml_hash_mix_uint32(h, (int)ops.hash(v));
                    --num;
                    break;
                }
                default: {
                    long i;
                    h = Hash.caml_hash_mix_uint32(h, (int)v.getHeader());
                    long len = v.sizeValues();
                    for (i = 0L; i < len; ++i) {
                        if (wr >= sz) break block0;
                        queue[wr++] = v.get(i);
                    }
                    continue block10;
                }
            }
            {
                continue block10;
                break;
            }
        }
        h = MurmurHash3.finalMix32(h);
        return Value.createLong(h & 0x3FFFFFFF);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "'a"}, returnType="int")
    public static Value caml_hash_univ_param(Value count, Value limit, Value obj) {
        HashParams hp = new HashParams(limit.asLong(), count.asLong());
        Hash.hashVal(obj, hp, true);
        return Value.createLong(hp.get());
    }

    public static Value hashVariant(String s) {
        long res = 0L;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int ch = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(s.charAt(i)));
            res = 223L * (res >> 1) + (long)ch << 1;
        }
        return Value.createLong((res &= 0xFFFFFFFEL) >> 1);
    }

    private static void hashVal(Value obj, HashParams hash, boolean count) {
        if (count) {
            hash.decrementLimit();
            if (hash.stopHashing()) {
                return;
            }
        }
        if (obj.isLong()) {
            hash.decrementCount();
            hash.combine(obj.asLong());
            return;
        }
        int tag = obj.getTag();
        switch (tag) {
            case 252: {
                hash.decrementCount();
                byte[] chars = obj.getBytes();
                int lenChars = chars.length;
                for (int i = 0; i < lenChars; ++i) {
                    hash.combineSmall(IntegerUtils.signedToUnsignedByte(chars[i]));
                }
                break;
            }
            case 253: {
                hash.decrementCount();
                Hash.hashDouble(obj.asDouble(), hash);
                break;
            }
            case 254: {
                hash.decrementCount();
                long lenDbl = obj.sizeDoubles();
                for (long i = 0L; i < lenDbl; ++i) {
                    Hash.hashDouble(obj.getDouble(i), hash);
                }
                break;
            }
            case 251: {
                break;
            }
            case 249: {
                Hash.hashVal(obj.getParent(), hash, true);
                break;
            }
            case 250: {
                Hash.hashVal(obj.get0(), hash, false);
                return;
            }
            case 248: {
                hash.decrementCount();
                hash.combine(obj.get1().asLong());
                break;
            }
            case 255: {
                CustomOperations ops = obj.getCustomOperations();
                if (!ops.isHashable()) break;
                hash.decrementCount();
                hash.combine(ops.hash(obj));
                break;
            }
            default: {
                hash.decrementCount();
                hash.combineSmall(tag);
                long lenBl = obj.sizeValues();
                for (long i = lenBl - 1L; i >= 0L; --i) {
                    Hash.hashVal(obj.get(i), hash, true);
                }
            }
        }
    }

    private static void hashDouble(double d, HashParams hash) {
        long bits = Double.doubleToRawLongBits(d);
        for (int i = 0; i < 8; ++i) {
            hash.combineSmall((int)(bits >> i * 8 & 0xFFL));
        }
    }

    private static final class HashParams {
        private static final long ALPHA = 65599L;
        private static final long BETA = 19L;
        private long accu = 0L;
        private long limit;
        private long count;

        private HashParams(long lim, long cnt) {
            this.limit = lim;
            this.count = cnt;
        }

        private boolean stopHashing() {
            return this.count < 0L || this.limit < 0L;
        }

        private void decrementCount() {
            --this.count;
        }

        private void decrementLimit() {
            --this.limit;
        }

        private void combineSmall(int x) {
            this.accu = this.accu * 19L + (long)x;
        }

        private void combine(long x) {
            this.accu = this.accu * 65599L + x;
        }

        private int get() {
            return (int)(this.accu & 0x3FFFFFFFL);
        }
    }
}

