/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.util.SignalSupport;

public final class Signal {
    public static final int INVALID_SIGNAL_NUMBER = -1;
    public static final String INVALID_SIGNAL_NAME = "invalid-signal";
    final Object inst;

    public Signal(SignalKind k) {
        Object obj;
        assert (k != null) : "null k";
        if (SignalSupport.AVAILABLE) {
            try {
                obj = SignalSupport.CSTR_SIGNAL.newInstance(k.getID());
            }
            catch (Throwable t) {
                obj = null;
            }
        } else {
            obj = null;
        }
        this.inst = obj;
    }

    Signal(Object signal) {
        assert (signal.getClass().getName().equals("sun.misc.Signal")) : "invalid signal";
        this.inst = SignalSupport.AVAILABLE ? signal : null;
    }

    public boolean isValid() {
        return this.inst != null;
    }

    public int getNumber() {
        if (this.isValid()) {
            try {
                return (Integer)SignalSupport.MTH_SIGNAL_GET_NUMBER.invoke(this.inst, new Object[0]);
            }
            catch (Throwable t) {
                return -1;
            }
        }
        return -1;
    }

    public String getName() {
        if (this.isValid()) {
            try {
                return (String)SignalSupport.MTH_SIGNAL_GET_NAME.invoke(this.inst, new Object[0]);
            }
            catch (Throwable t) {
                return INVALID_SIGNAL_NAME;
            }
        }
        return INVALID_SIGNAL_NAME;
    }

    public boolean raise() {
        if (this.isValid()) {
            try {
                SignalSupport.MTH_SIGNAL_RAISE.invoke(null, this.inst);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append('/');
        sb.append(this.getNumber());
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Signal) {
            Signal that = (Signal)obj;
            return this.getName().equals(that.getName()) && this.getNumber() == that.getNumber();
        }
        return false;
    }

    public int hashCode() {
        return this.getNumber() + this.getName().hashCode();
    }
}

