(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

(** Extendable arrays that are also invertible, meaning that it is
    possible to get the index corresponding to a value.

    Results are unspecified if the array contains the same value twice. *)


module type HashableComparableType = sig
  type t
  val equal : t -> t -> bool
  val compare : t -> t -> int
  val hash : t -> int
  val to_string : t -> string
 end
(** The input signature of the functor [Make]. *)

module type S = sig
  type elem
  type t
  type index = Utils.u2
  val make : int -> int -> elem -> t
  val from_array : exn -> elem array -> elem -> t
  val to_array : t -> elem array
  val length : t -> int
  val capacity : t -> int
  val get : t -> index -> elem
  val set : t -> index -> elem -> unit
  val find : elem -> t -> index
  val add : exn -> t -> elem -> elem -> bool -> index
  val add_if_not_found : exn -> t -> elem -> elem -> bool -> index
  val equal : t -> t -> bool
  val compare : t -> t -> int
  val hash : t -> int
  val to_string : t -> string
end
(** The output signature of the functor [Make], akin to
    [ExtendableArray]. *)

module Make (T : HashableComparableType) : S with type elem = T.t
(** Functor building an invertible array implementation. *)
