(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

(** Utilities related to class hierarchy. *)

val parent_class_definitions : bool -> ClassLoader.t -> ClassDefinition.t -> ClassDefinition.t list
(** [parent_class_definitions fail loader cd] returns the list of [cd]
    parent classes, using [loader] to load classes. The first element of
    the returned list is the passed class definition, and the last
    element is its most distant ancestor. [fail] indicates the behavior
    when a class cannot be loaded when iterating over parents:
    - if [true], an exception is raised;
    - if [false], the list built so far is returned. *)

val parent_class_names : bool -> ClassLoader.t -> ClassDefinition.t -> Name.for_class list
(** Similar to [parent_class_definitions], except that the returned list
    contains class names rather than class definitions. *)

val all_parent_class_definitions : bool -> ClassLoader.t -> ClassDefinition.t -> ClassDefinition.t list
(** Similar to [parent_class_definitions], except that the returned list
    contains not only parent classes, but also parent interfaces. *)

val all_parent_class_names : bool -> ClassLoader.t -> ClassDefinition.t -> Name.for_class list
(** Similar to [all_parent_class_definitions], except that the returned
    list contains class names rather than class definitions. *)
