(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

(** Byte arrays.

    This definition is independent of the actual implementation, that can
    be based on either the OCaml standard library, or the OCaml-Java
    runtime library. *)


type t
(** The type of byte arrays. *)

val empty : t
(** Constant representing an array of size 0. *)

val make_of_size : int -> t
(** Creates an array of the passed size.

    Raises [Invalid_argument] is size is negative. *)

val make_of_string : string -> t
(** Creates an array using the bytes from the passed string. *)

val length : t -> int
(** Returns the length of the passed byte array. *)

val as_string : t -> string
(** Returns a string containing the btyes of the passed array. *)

val to_string : t -> string
(** Returns a string representation of the passed array (typically for
    display). *)
