(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

(** UTF8 buffers.

    This definition is independent of the actual implementation,
    that can be based on either the Camomile library (available at
    http://camomile.sourceforge.net), or the OCaml-Java runtime
    library. *)


type t
(** The type of UTF8 buffers. *)

val default_size : int
(** The size of buffers created through [make]. *)

val make : unit -> t
(** Constructs an empty buffer, of size [default_size]. *)

val make_of_size : int -> t
(** [make_of_size sz] constructs an empty buffer, of size [sz].

    Raises [Invalid_argument] if [sz] is negative. *)

val add_char : t -> UChar.t -> unit
(** [add_char buff ch] appends char [ch] to buffer [buff]. *)

val add_string : t -> UTF8.t -> unit
(** [add_char buff str] appends string [str] to buffer [buff]. *)

val add_endline : t -> UTF8.t -> unit
(** [add_char buff sstr] appends string [str] to buffer [buff],
    and then also appends an end-of-line character. *)

val add_newline : t -> unit
(** Appends an end-of-line character to the passed buffer. *)

val contents : t -> UTF8.t
(** [contents buff] returns the contents of buffer [buff] as a UTF8
    string. *)

(**/**)

val add_string2 : t -> UTF8.t -> t
val print_string : t -> bool -> bool -> int -> UTF8.t -> t

val add_char2 : t -> UChar.t -> t
val print_char : t -> bool -> bool -> int -> UChar.t -> t

val add_float : t -> float -> t
val print_float : t -> bool -> int -> float -> t

val add_int : t -> int -> t
val add_int_hexa : t -> int -> t
val print_int : t -> bool -> int -> bool -> bool -> int -> t

val add_int32 : t -> int32 -> t
val add_int32_hexa : t -> int32 -> t
val print_int32 : t -> bool -> int -> bool -> bool -> int32 -> t

val add_int64 : t -> int64 -> t
val add_int64_hexa : t -> int64 -> t
val print_int64 : t -> bool -> int -> bool -> bool -> int64 -> t

val add_nativeint : t -> nativeint -> t
val add_nativeint_hexa : t -> nativeint -> t
val print_nativeint : t -> bool -> int -> bool -> bool -> nativeint -> t

val add_newline2 : t -> t
