(*
 * This file is part of Barista.
 * Copyright (C) 2007-2014 Xavier Clerc.
 *
 * Barista is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Barista is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *)

(** Byte Buffers.

    This definition is independent of the actual implementation, that can
    be based on either the OCaml standard library, or the OCaml-Java
    runtime library. *)


type t
(** The type of byte buffers, growing as necessary. *)

val make_of_size : int -> t
(** Creates a buffer of passed size. The size is only the initial size,
    buffer will grow as necessary.

    Raises [Invalid_argument] is size is negative. *)

val add_byte : t -> int -> unit
(** [add_byte buff byte] adds the byte [byte] to [buff]. *)

val add_bytes : t -> Bytes.t -> unit
(** [add_bytes buff bytes] adds the bytes [bytes] to [buff]. *)

val add_bytes_from : t -> Bytes.t -> int -> int -> unit
(** [add_bytes_from buff bytes ofs len] adds [len] bytes from [bytes]
    (starting at offset [ofs]) to [buff].

    Raises [Invalid_argument] if [ofs] or [len] is invalid. *)

val contents : t -> Bytes.t
(** Return the current contents of the buffer as bytes. *)
