/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.Value;

public final class ValueStack {
    private static final int MAX_NB_PRINTED_VALUES = 5;
    private int top;
    private final Value[] elements;
    private final int maxIndex;

    public ValueStack(int n) {
        assert (n > 0) : "maxSz should be > 0";
        this.elements = new Value[n];
        this.top = -1;
        this.maxIndex = n - 1;
    }

    public boolean isEmpty() {
        return this.top <= -1;
    }

    public boolean isFull() {
        return this.top >= this.maxIndex;
    }

    public int size() {
        return this.top + 1;
    }

    public int maxSize() {
        return this.maxIndex + 1;
    }

    public void push(Value value) throws Fail.Exception {
        assert (value != null) : "null v";
        if (this.isFull()) {
            Fail.raiseStackOverflow();
        } else {
            this.elements[++this.top] = value;
        }
    }

    public Value pop() throws Fatal.Exception {
        if (this.isEmpty()) {
            Fatal.raiseStackUnderflow();
            return null;
        }
        Value value = this.elements[this.top];
        this.elements[this.top--] = null;
        return value;
    }

    public void pop(int n) throws Fatal.Exception {
        assert (n >= 0) : "n should be >= 0";
        if (this.size() >= n) {
            for (int i = 0; i < n; ++i) {
                this.elements[this.top--] = null;
            }
        } else {
            while (this.top > -1) {
                this.elements[this.top--] = null;
            }
            Fatal.raiseStackUnderflow();
        }
    }

    public void slide(int n, int n2) throws Fatal.Exception {
        assert (n >= 0) : "n should be >= 0";
        assert (n2 >= 0) : "delta should be >= 0";
        System.arraycopy(this.elements, this.top - n + 1, this.elements, this.top - n - n2 + 1, n);
        for (int i = 0; i < n2; ++i) {
            this.elements[this.top--] = null;
        }
    }

    public void inject(int n, Value value, Value value2, Value value3) {
        assert (n >= 0) : "n should be >= 0";
        assert (value != null) : "null v0";
        assert (value2 != null) : "null v1";
        assert (value3 != null) : "null v2";
        System.arraycopy(this.elements, this.top - n + 1, this.elements, this.top + 4 - n, n);
        this.elements[this.top - n + 1] = value;
        this.elements[this.top - n + 2] = value2;
        this.elements[this.top - n + 3] = value3;
        this.top += 3;
    }

    public Value peek(int n) throws Fatal.Exception {
        assert (n >= 0) : "idx should be >= 0";
        if (n < this.size()) {
            return this.elements[this.top - n];
        }
        Fatal.raiseStackUnderflow();
        return null;
    }

    public void assign(int n, Value value) throws Fatal.Exception {
        assert (n >= 0) : "idx should be >= 0";
        assert (value != null) : "null v";
        if (n < this.size()) {
            this.elements[this.top - n] = value;
        } else {
            Fatal.raiseStackUnderflow();
        }
    }

    public Value[] popSlice(int n) throws Fatal.Exception {
        assert (n >= 0) : "n should be >= 0";
        Value[] valueArray = new Value[n];
        if (this.size() >= n) {
            System.arraycopy(this.elements, this.top - n + 1, valueArray, 0, n);
        }
        this.pop(n);
        return valueArray;
    }

    public void pushSlice(Value[] valueArray) throws Fail.Exception {
        assert (valueArray != null) : "null s";
        int n = valueArray.length;
        if (this.top + n > this.maxIndex) {
            System.arraycopy(valueArray, 0, this.elements, this.top + 1, this.maxIndex - this.top);
            this.top = this.maxIndex;
            Fail.raiseStackOverflow();
        } else {
            System.arraycopy(valueArray, 0, this.elements, this.top + 1, n);
            this.top += n;
        }
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder("ValueStack [maxSize=");
        stringBuilder.append(this.maxIndex + 1);
        stringBuilder.append(", top=");
        stringBuilder.append(this.top);
        stringBuilder.append("]: ");
        boolean bl = true;
        for (n = this.top; n >= 0 && this.top - n < 5; --n) {
            if (bl) {
                bl = false;
                continue;
            }
            stringBuilder.append(", ");
        }
        if (n >= 0) {
            stringBuilder.append("(...)");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ValueStack) {
            ValueStack valueStack = (ValueStack)object;
            return this.maxIndex == valueStack.maxIndex && Arrays.equals(this.elements, valueStack.elements);
        }
        return false;
    }

    public int hashCode() {
        return this.maxIndex + Arrays.hashCode(this.elements);
    }
}

