/*
 * Decompiled with CFR 0.152.
 */
package com.onemoonscientific.swank;

import com.onemoonscientific.swank.BindEvent;
import com.onemoonscientific.swank.SwkListener;
import com.onemoonscientific.swank.SwkSMenu;
import com.onemoonscientific.swank.Widgets;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class SwkPopupListener
extends MouseAdapter
implements SwkListener {
    Interp interp;
    String popupName;
    SwkSMenu popup = null;
    Component component;

    SwkPopupListener(Interp interp, Component component, String popupName) {
        this.interp = interp;
        this.component = component;
        this.popupName = popupName.intern();
    }

    public void mousePressed(MouseEvent e) {
        System.out.println("pressed");
        this.maybeShowPopup(e, 0);
    }

    public void mouseReleased(MouseEvent e) {
        System.out.println("released");
        this.maybeShowPopup(e, 0);
    }

    public void mouseEntered(MouseEvent e) {
        System.out.println("entered");
        if (this.popup != null) {
            // empty if block
        }
    }

    public void mouseExited(MouseEvent e) {
        System.out.println("exited");
    }

    public void maybeShowPopup(MouseEvent e, int show) {
        BindEvent bEvent = new BindEvent(this.interp, this, e, show);
        this.interp.getNotifier().queueEvent((TclEvent)bEvent, 0);
    }

    public void processEvent(EventObject eventObject, Object obj, int show) {
        MouseEvent e = (MouseEvent)eventObject;
        if (!e.isPopupTrigger()) {
            // empty if block
        }
        System.out.println("popuptrigger");
        TclObject tObj = (TclObject)Widgets.getWidget(this.interp, this.popupName);
        System.out.println(this.popupName);
        if (tObj == null) {
            System.out.println("no popup");
            return;
        }
        try {
            if (ReflectObject.get((Interp)this.interp, (TclObject)tObj) instanceof SwkSMenu) {
                this.popup = (SwkSMenu)ReflectObject.get((Interp)this.interp, (TclObject)tObj);
                if (this.popup == null) {
                    System.out.println("no popup");
                    return;
                }
                Dimension dim = e.getComponent().getSize();
                Point loc = e.getComponent().getLocationOnScreen();
                Point loc1 = e.getComponent().getLocation();
                int x = loc.x + dim.width;
                int y = loc.y;
                System.out.println("show popup " + x + " " + y);
                if (show == 0) {
                    this.popup.show(this.component, loc1.x + dim.width, loc1.y);
                } else if (show == 1) {
                    this.popup.setLocation(x, y);
                    this.popup.setVisible(true);
                } else {
                    this.popup.setVisible(false);
                }
            } else {
                System.out.println("not SwkSMenu " + this.popupName);
            }
        }
        catch (TclException tE) {
            this.interp.addErrorInfo("\n    (\"binding\" script)");
            this.interp.backgroundError();
        }
    }
}

