/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMSlot;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMTransaction;
import org.ocamljava.runtime.primitives.javalibs.concurrent.STMVariable;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="STM", source="")
public final class STM {
    private STM() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="unit")
    public static Value ocamljava_stm_init(Value unit) throws Fail.Exception {
        STMSlot.init();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="STM.transaction")
    public static Value ocamljava_stm_make_transaction(Value unit) throws Fail.Exception {
        STMTransaction res = new STMTransaction(STMSlot.get().getGlobalVersionClock().get());
        return Value.createInstance(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a"}, returnType="'a STM.ref")
    public static Value ocamljava_stm_make_ref(Value value) throws Fail.Exception {
        STMVariable res = new STMVariable(value, 0);
        return Value.createInstance(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"STM.transaction", "'a STM.ref"}, returnType="'a")
    public static Value ocamljava_stm_get(Value trans, Value var) throws Fail.Exception {
        STMTransaction t = (STMTransaction)trans.asCustom();
        STMVariable v = (STMVariable)var.asCustom();
        return t.readVariable(v);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"STM.transaction", "'a STM.ref", "'a"}, returnType="unit")
    public static Value ocamljava_stm_set(Value trans, Value var, Value val) throws Fail.Exception {
        STMTransaction t = (STMTransaction)trans.asCustom();
        STMVariable v = (STMVariable)var.asCustom();
        t.writeVariable(v, val);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"STM.transaction"}, returnType="unit")
    public static Value ocamljava_stm_commit(Value trans) throws Fail.Exception {
        STMTransaction t = (STMTransaction)trans.asCustom();
        t.commit();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"STM.transaction"}, returnType="unit")
    public static Value ocamljava_stm_invalidate(Value trans) throws Fail.Exception {
        STMTransaction t = (STMTransaction)trans.asCustom();
        t.invalidate();
        return Value.UNIT;
    }

    static void raiseRetry() throws Fail.Exception {
        Value exn = CurrentContext.getCodeState().getCallback("Concurrent.STM.Retry");
        if (exn != null) {
            Fail.raise(exn);
        } else {
            Fail.invalidArgument("Exception Concurrent.STM.Retry not initialized");
        }
    }
}

