/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.Invoker;
import org.ocamljava.runtime.values.Applications;
import org.ocamljava.runtime.values.MethodHandleValue;
import org.ocamljava.runtime.values.Value;

public final class NativeApply
implements Applications {
    private NativeApply() {
    }

    public static Value apply(Value closure, Value[] arguments) throws Fail.Exception, Fatal.Exception, Throwable {
        Value code = closure.get0();
        switch (code.getApplicationKind()) {
            case 0: {
                MethodHandleValue mhv = (MethodHandleValue)closure.get2();
                int arity = mhv.getArity();
                Value bl = arguments[0];
                Value[] objs = new Value[arity];
                objs[arity - 1] = mhv.getEnv();
                bl.copyValuesIntoArray(objs);
                Value tmp = Invoker.call(mhv.getHandle(), objs);
                if (arguments.length == 1) {
                    return tmp;
                }
                int newLen = arguments.length - 1;
                Value[] newArguments = new Value[newLen];
                System.arraycopy(arguments, 1, newArguments, 0, newLen);
                return NativeApply.apply(tmp, newArguments);
            }
            case 1: {
                MethodHandleValue mhv = (MethodHandleValue)(code.isMethodHandle() ? closure.get0() : closure.get2());
                Value tmp = mhv.getArity() == 1 ? mhv.getHandle().invokeExact(arguments[0]) : mhv.getHandle().invokeExact(arguments[0], mhv.getEnv());
                int lenArguments = arguments.length;
                if (lenArguments == 1) {
                    return tmp;
                }
                Value[] newArguments = new Value[lenArguments - 1];
                System.arraycopy(arguments, 1, newArguments, 0, lenArguments - 1);
                return NativeApply.apply(tmp, newArguments);
            }
            case 2: {
                MethodHandleValue mhv = (MethodHandleValue)closure.get2();
                Value env = mhv.getEnv();
                int funArity = mhv.getArity();
                int remArity = -((int)code.asCodeOffset() + 1);
                int lenArguments = arguments.length;
                if (remArity - lenArguments <= 0) {
                    int i;
                    Value[] objs = new Value[funArity];
                    objs[funArity - 1] = env;
                    if (env != closure) {
                        int len = (int)closure.sizeValues();
                        for (i = 3; i < len; ++i) {
                            objs[i - 3] = closure.get(i);
                        }
                        int m = Math.min(lenArguments, remArity);
                        for (int i2 = 0; i2 < m; ++i2) {
                            objs[i2 + len - 3] = arguments[i2];
                        }
                    } else {
                        int m = Math.min(lenArguments, remArity);
                        for (i = 0; i < m; ++i) {
                            objs[i] = arguments[i];
                        }
                    }
                    Value tmp = Invoker.call(mhv.getHandle(), objs);
                    if (remArity - lenArguments == 0) {
                        return tmp;
                    }
                    int newLen = lenArguments - remArity;
                    Value[] newArguments = new Value[newLen];
                    System.arraycopy(arguments, remArity, newArguments, 0, newLen);
                    return NativeApply.apply(tmp, newArguments);
                }
                int newArity = remArity - lenArguments;
                int blockSize = env != closure ? (int)closure.sizeValues() + lenArguments : 3 + lenArguments;
                int newCode = -newArity - 1;
                Value newBlock = Value.createClosure(blockSize, (long)newCode);
                newBlock.set1(Value.createLong(newArity));
                newBlock.set2(mhv);
                if (env != closure) {
                    int i;
                    int len = (int)closure.sizeValues();
                    for (i = 3; i < len; ++i) {
                        newBlock.set(i, closure.get(i));
                    }
                    for (i = 0; i < lenArguments; ++i) {
                        newBlock.set(i + len, arguments[i]);
                    }
                } else {
                    for (int i = 0; i < lenArguments; ++i) {
                        newBlock.set(3 + i, arguments[i]);
                    }
                }
                return newBlock;
            }
        }
        assert (false) : "should not be reached";
        return null;
    }

    public static Value apply(Value closure, Value arg0) throws Fail.Exception, Fatal.Exception, Throwable {
        Value code = closure.get0();
        switch (code.getApplicationKind()) {
            case 0: {
                MethodHandleValue mhv = (MethodHandleValue)closure.get2();
                int arity = mhv.getArity();
                long size = (int)arg0.sizeValues();
                if ((long)arity == size) {
                    switch (arity) {
                        case 0: {
                            return mhv.getHandle().invokeExact();
                        }
                        case 1: {
                            return mhv.getHandle().invokeExact(arg0.get0());
                        }
                        case 2: {
                            return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1());
                        }
                        case 3: {
                            return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2());
                        }
                        case 4: {
                            return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2(), arg0.get3());
                        }
                        case 5: {
                            return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2(), arg0.get3(), arg0.get4());
                        }
                        case 6: {
                            return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2(), arg0.get3(), arg0.get4(), arg0.get5());
                        }
                        case 7: {
                            return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2(), arg0.get3(), arg0.get4(), arg0.get5(), arg0.get6());
                        }
                        case 8: {
                            return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2(), arg0.get3(), arg0.get4(), arg0.get5(), arg0.get6(), arg0.get7());
                        }
                    }
                    Value[] objs = new Value[arity];
                    arg0.copyValuesIntoArray(objs);
                    return Invoker.call(mhv.getHandle(), objs);
                }
                switch (arity) {
                    case 1: {
                        return mhv.getHandle().invokeExact(mhv.getEnv());
                    }
                    case 2: {
                        return mhv.getHandle().invokeExact(arg0.get0(), mhv.getEnv());
                    }
                    case 3: {
                        return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), mhv.getEnv());
                    }
                    case 4: {
                        return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2(), mhv.getEnv());
                    }
                    case 5: {
                        return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2(), arg0.get3(), mhv.getEnv());
                    }
                    case 6: {
                        return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2(), arg0.get3(), arg0.get4(), mhv.getEnv());
                    }
                    case 7: {
                        return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2(), arg0.get3(), arg0.get4(), arg0.get5(), mhv.getEnv());
                    }
                    case 8: {
                        return mhv.getHandle().invokeExact(arg0.get0(), arg0.get1(), arg0.get2(), arg0.get3(), arg0.get4(), arg0.get5(), arg0.get6(), mhv.getEnv());
                    }
                }
                Value[] objs = new Value[arity];
                objs[arity - 1] = mhv.getEnv();
                arg0.copyValuesIntoArray(objs);
                return Invoker.call(mhv.getHandle(), objs);
            }
            case 1: {
                MethodHandleValue mhv = (MethodHandleValue)(code.isMethodHandle() ? closure.get0() : closure.get2());
                return mhv.getArity() == 1 ? mhv.getHandle().invokeExact(arg0) : mhv.getHandle().invokeExact(arg0, mhv.getEnv());
            }
            case 2: {
                MethodHandleValue mhv = (MethodHandleValue)closure.get2();
                Value env = mhv.getEnv();
                int funArity = mhv.getArity();
                int remArity = -((int)code.asCodeOffset() + 1);
                if (remArity - 1 <= 0) {
                    Value[] objs = new Value[funArity];
                    objs[funArity - 1] = env;
                    if (env != closure) {
                        int len = (int)closure.sizeValues();
                        for (int i = 3; i < len; ++i) {
                            objs[i - 3] = closure.get(i);
                        }
                        objs[len - 3] = arg0;
                    } else {
                        objs[0] = arg0;
                    }
                    return Invoker.call(mhv.getHandle(), objs);
                }
                int newArity = remArity - 1;
                int blockSize = env != closure ? (int)closure.sizeValues() + 1 : 4;
                int newCode = -newArity - 1;
                Value newBlock = Value.createClosure(blockSize, (long)newCode);
                newBlock.set1(Value.createLong(newArity));
                newBlock.set2(mhv);
                if (env != closure) {
                    int len = (int)closure.sizeValues();
                    for (int i = 3; i < len; ++i) {
                        newBlock.set(i, closure.get(i));
                    }
                    newBlock.set(len, arg0);
                } else {
                    newBlock.set(3, arg0);
                }
                return newBlock;
            }
        }
        assert (false) : "should not be reached";
        return null;
    }

    public static Value apply(Value closure, Value arg0, Value arg1) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(closure, new Value[]{arg0, arg1});
    }

    public static Value apply(Value closure, Value arg0, Value arg1, Value arg2) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(closure, new Value[]{arg0, arg1, arg2});
    }

    public static Value apply(Value closure, Value arg0, Value arg1, Value arg2, Value arg3) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(closure, new Value[]{arg0, arg1, arg2, arg3});
    }

    public static Value apply(Value closure, Value arg0, Value arg1, Value arg2, Value arg3, Value arg4) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(closure, new Value[]{arg0, arg1, arg2, arg3, arg4});
    }

    public static Value apply(Value closure, Value arg0, Value arg1, Value arg2, Value arg3, Value arg4, Value arg5) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(closure, new Value[]{arg0, arg1, arg2, arg3, arg4, arg5});
    }

    public static Value apply(Value closure, Value arg0, Value arg1, Value arg2, Value arg3, Value arg4, Value arg5, Value arg6) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(closure, new Value[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6});
    }

    public static Value apply(Value closure, Value arg0, Value arg1, Value arg2, Value arg3, Value arg4, Value arg5, Value arg6, Value arg7) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(closure, new Value[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7});
    }

    public static Value apply(Value closure, Value arg0, Value arg1, Value arg2, Value arg3, Value arg4, Value arg5, Value arg6, Value arg7, Value arg8) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(closure, new Value[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8});
    }

    public static Value apply(Value closure, Value arg0, Value arg1, Value arg2, Value arg3, Value arg4, Value arg5, Value arg6, Value arg7, Value arg8, Value arg9) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(closure, new Value[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9});
    }

    public static Value send(Value tag, Value cache, Value pos, Value[] args) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(NativeApply.getMethod(tag, cache, pos, args[0]), args);
    }

    public static Value send(Value tag, Value cache, Value pos, Value arg0) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(NativeApply.getMethod(tag, cache, pos, arg0), arg0);
    }

    public static Value send(Value tag, Value cache, Value pos, Value arg0, Value arg1) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(NativeApply.getMethod(tag, cache, pos, arg0), arg0, arg1);
    }

    public static Value send(Value tag, Value cache, Value pos, Value arg0, Value arg1, Value arg2) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(NativeApply.getMethod(tag, cache, pos, arg0), arg0, arg1, arg2);
    }

    public static Value send(Value tag, Value cache, Value pos, Value arg0, Value arg1, Value arg2, Value arg3) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(NativeApply.getMethod(tag, cache, pos, arg0), arg0, arg1, arg2, arg3);
    }

    public static Value send(Value tag, Value cache, Value pos, Value arg0, Value arg1, Value arg2, Value arg3, Value arg4) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(NativeApply.getMethod(tag, cache, pos, arg0), arg0, arg1, arg2, arg3, arg4);
    }

    public static Value send(Value tag, Value cache, Value pos, Value arg0, Value arg1, Value arg2, Value arg3, Value arg4, Value arg5) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(NativeApply.getMethod(tag, cache, pos, arg0), arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public static Value send(Value tag, Value cache, Value pos, Value arg0, Value arg1, Value arg2, Value arg3, Value arg4, Value arg5, Value arg6) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(NativeApply.getMethod(tag, cache, pos, arg0), arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static Value send(Value tag, Value cache, Value pos, Value arg0, Value arg1, Value arg2, Value arg3, Value arg4, Value arg5, Value arg6, Value arg7) throws Fail.Exception, Fatal.Exception, Throwable {
        return NativeApply.apply(NativeApply.getMethod(tag, cache, pos, arg0), arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    private static Value getMethod(Value tag, Value cache, Value pos, Value obj) {
        long tagR;
        Value meths = obj.get0();
        Value mask = meths.get1();
        long cached = cache.get(pos.asLong()).getRawValue() & mask.getRawValue();
        long tagC = meths.get(2L + cached).getRawValue();
        if (tagC == (tagR = tag.getRawValue())) {
            return meths.get(1L + cached);
        }
        long li = 3L;
        long hi = meths.get0().getRawValue();
        while (li < hi) {
            long mi = li + hi >> 1 | 1L;
            if (tagR < meths.get(mi).getRawValue()) {
                hi = mi - 2L;
                continue;
            }
            li = mi;
        }
        cache.set(pos.asLong(), Value.createFromRawValue(li - 2L));
        return meths.get(li - 1L);
    }
}

