/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Signals;
import org.ocamljava.runtime.util.Signal;
import org.ocamljava.runtime.util.SignalKind;
import org.ocamljava.runtime.values.Value;

public final class SignalsState {
    private static final Value SIGNAL_DEFAULT_HANDLER = Value.ZERO;
    private static final Value SIGNAL_IGNORE_HANDLER = Value.ONE;
    private static final int SIG_SETMASK = 0;
    private static final int SIG_BLOCK = 1;
    private static final int SIG_UNBLOCK = 2;
    private final Context context;
    private final Map<Integer, Value> signals;
    private final Set<Integer> blockedSignals;
    private final Set<Integer> ignoredSignals;
    private Exception asyncException;

    SignalsState(Context context) {
        assert (context != null) : "null ctxt";
        this.context = context;
        this.signals = new HashMap<Integer, Value>();
        this.blockedSignals = new HashSet<Integer>();
        this.ignoredSignals = new HashSet<Integer>();
        this.asyncException = null;
    }

    public Set<Integer> getBlockedSignals() {
        return this.blockedSignals;
    }

    public Set<Integer> getIgnoredSignals() {
        return this.ignoredSignals;
    }

    public void clearSignals() {
        Signals.unregisterContext(this.context);
        this.signals.clear();
        this.blockedSignals.clear();
        this.ignoredSignals.clear();
    }

    public Value getSignalHandler(int n) {
        Value value = this.signals.get(n);
        return value != null ? value : SIGNAL_DEFAULT_HANDLER;
    }

    public Set<Integer> getPendingSignals() {
        return Signals.getPendingSignals(this.blockedSignals);
    }

    public Set<Integer> blockSignals(int n, Set<Integer> set) {
        assert (set != null) : "null s";
        HashSet<Integer> hashSet = new HashSet<Integer>(this.blockedSignals);
        switch (n) {
            case 0: {
                this.blockedSignals.clear();
                this.blockedSignals.addAll(set);
                break;
            }
            case 1: {
                this.blockedSignals.addAll(set);
                break;
            }
            case 2: {
                this.blockedSignals.removeAll(set);
                break;
            }
            default: {
                assert (false) : "invalid sigmask action";
                break;
            }
        }
        this.blockedSignals.remove(new Signal(SignalKind.KILL).getNumber());
        this.blockedSignals.remove(new Signal(SignalKind.STOP).getNumber());
        return hashSet;
    }

    public int waitSignal(Set<Integer> set) throws FalseExit, Fail.Exception {
        assert (set != null) : "null s";
        return Signals.waitForSignal(this.context, set);
    }

    public Value installSignalHandler(Value value, Value value2) throws Fail.Exception {
        int n = Signals.ocamlToSystemIdentifier(value.asCastedInt());
        if (n < 0) {
            Fail.invalidArgument("Sys.signal: unavailable signal");
        }
        if (n == new Signal(SignalKind.KILL).getNumber() || n == new Signal(SignalKind.STOP).getNumber()) {
            Fail.raiseSysError("Invalid argument");
        }
        if (value2 == SIGNAL_DEFAULT_HANDLER) {
            Signals.unregisterContext(n, this.context);
            return this.registerSignal(n, SIGNAL_DEFAULT_HANDLER);
        }
        if (value2 == SIGNAL_IGNORE_HANDLER) {
            Signals.registerContext(n, this.context);
            return this.registerSignal(n, SIGNAL_IGNORE_HANDLER);
        }
        Signals.registerContext(n, this.context);
        return this.registerSignal(n, value2.get0());
    }

    private Value registerSignal(int n, Value value) {
        Value value2 = this.signals.put(n, value);
        if (value2 == null) {
            return SIGNAL_DEFAULT_HANDLER;
        }
        if (value2.isBlock()) {
            return Value.createBlock(0, value2);
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsyncException(Exception exception) {
        assert (exception != null) : "null e";
        SignalsState signalsState = this;
        synchronized (signalsState) {
            this.asyncException = exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getAndClearAsyncException() {
        Exception exception;
        SignalsState signalsState = this;
        synchronized (signalsState) {
            exception = this.asyncException;
            this.asyncException = null;
        }
        return exception;
    }
}

