/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.labltk;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.labltk.TKSlot;
import org.ocamljava.runtime.values.Value;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclString;

@PrimitiveProvider(library="labltk", module="Tk", source="otherlibs/labltk/support/cltkVar.c")
public final class CltkVar {
    private CltkVar() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string"}, returnType="string")
    public static Value camltk_getvar(Value var) throws Fail.Exception {
        TKSlot slot = TKSlot.checkInit();
        try {
            TclObject res = slot.getInterpreter().getVar(var.asString(), 1);
            return Value.createString((String)res.toString());
        }
        catch (TclException te) {
            slot.tkError(te);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "string"}, returnType="unit")
    public static Value camltk_setvar(Value var, Value contents) throws Fail.Exception {
        TKSlot slot = TKSlot.checkInit();
        try {
            TclObject cont = TclString.newInstance((String)contents.asString());
            slot.getInterpreter().setVar(var.asString(), cont, 1);
        }
        catch (TclException te) {
            slot.tkError(te);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "Protocol.cbid"}, returnType="unit")
    public static Value camltk_trace_var(Value var, Value cbid) throws Fail.Exception {
        TKSlot slot = TKSlot.checkInit();
        try {
            slot.getInterpreter().traceVar(var.asString(), slot.createVarTrace(cbid.asLong()), 97);
        }
        catch (TclException te) {
            slot.tkError(te);
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "Protocol.cbid"}, returnType="unit")
    public static Value camltk_untrace_var(Value var, Value cbid) throws Fail.Exception {
        TKSlot slot = TKSlot.checkInit();
        slot.getInterpreter().untraceVar(var.asString(), slot.getVarTrace(cbid.asLong()), 97);
        return Value.UNIT;
    }
}

