/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.num;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.otherlibs.num.Nat;
import org.ocamljava.runtime.primitives.stdlib.Hash;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.AbstractCustomOperations;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

final class CustomNat
extends AbstractCustomOperations {
    static final CustomOperations OPS = new CustomNat();

    private CustomNat() {
        super("_nat", false, false, false, true, true);
    }

    @Override
    public CustomOperations.SerializationSizes serialize(DataOutput dataOutput, Value value) throws IOException {
        long[] lArray = (long[])value.asCustom();
        int n = lArray.length;
        IO.write32u(dataOutput, n);
        for (int i = 0; i < n; ++i) {
            IO.write64s(dataOutput, lArray[i]);
        }
        return new CustomOperations.SerializationSizes(n * 8, n * 8);
    }

    @Override
    public CustomOperations.DeserializedValue deserialize(DataInput dataInput) throws IOException, Fatal.Exception {
        int n;
        int n2 = IntegerUtils.ensure32s(IO.read32u(dataInput));
        long[] lArray = new long[n2];
        for (n = 0; n < n2; ++n) {
            lArray[n] = IO.read64s(dataInput);
        }
        n = n2 * 8;
        Value value = Value.createCustom(OPS, n, lArray);
        return new CustomOperations.DeserializedValue(value, n);
    }

    @Override
    public long hash(Value value) {
        int n = (int)Nat.num_digits_nat(value, Value.ZERO, Value.createLong(value.getWoSize() - 1L)).asLong();
        long[] lArray = (long[])value.asCustom();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            n2 = Hash.caml_hash_mix_uint32(n2, (int)(l & 0xFFFFFFFFL));
            if ((l >>>= 32) == 0L && i + 1 == n) break;
            n2 = Hash.caml_hash_mix_uint32(n2, (int)(l & 0xFFFFFFFFL));
        }
        return n2;
    }
}

