/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

final class AppletRunner
implements Runnable {
    private final Applet applet;
    private Thread thread;
    private AbstractNativeRunner runner;

    AppletRunner(Applet applet) {
        assert (applet != null) : "null a";
        this.applet = applet;
    }

    void setRunner(AbstractNativeRunner abstractNativeRunner) {
        assert (abstractNativeRunner != null) : "null r";
        this.runner = abstractNativeRunner;
    }

    private final Value getCallback(String string) {
        return this.runner.getContext().getCodeState().getCallback(string);
    }

    private final void callback(String string) {
        assert (string != null) : "null cb";
        try {
            Value value = this.runner.getContext().getCodeState().getCallback(string);
            this.runner.callback(value, Value.createInstance(this.applet));
        }
        catch (Throwable throwable) {
            this.applet.showStatus(throwable.toString());
        }
    }

    final String getAppletInfo() {
        Value value = this.getCallback("ocamljava java.applet.getAppletInfo");
        return value != null ? value.asString() : null;
    }

    final String[][] getParameterInfo() {
        Value value = this.getCallback("ocamljava java.applet.getParameterInfo");
        if (value != null) {
            BlockValue blockValue = value.asBlock();
            int n = (int)blockValue.sizeValues();
            String[][] stringArray = new String[n][3];
            for (int i = 0; i < n; ++i) {
                BlockValue blockValue2 = blockValue.get(i).asBlock();
                stringArray[i][0] = blockValue2.get0().asString();
                stringArray[i][1] = blockValue2.get1().asString();
                stringArray[i][2] = blockValue2.get2().asString();
            }
            return stringArray;
        }
        return null;
    }

    final void init(boolean bl) {
        if (bl) {
            Context context = this.runner.getContext();
            String string = this.applet.getParameter("width") + "x" + this.applet.getParameter("height");
            GraphSlot graphSlot = new GraphSlot(context.getParameters(), "applet", string);
            Canvas canvas = graphSlot.getCanvas();
            this.applet.setLayout(new BorderLayout());
            this.applet.add((Component)canvas, "Center");
            canvas.requestFocus();
            context.getCodeState().registerSlot(GraphSlot.SLOT, graphSlot);
        }
        OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this.runner);
        this.callback("ocamljava java.applet.init");
    }

    final void start() {
        this.callback("ocamljava java.applet.start");
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
            OCamlJavaThread.registerCodeRunner(this.thread, this.runner);
        } else {
            try {
                this.runner.getContext().leaveBlockingSection();
            }
            catch (Throwable throwable) {
                this.applet.showStatus(throwable.toString());
            }
            this.thread.resume();
        }
    }

    final void stop() {
        if (this.thread != null) {
            this.thread.suspend();
            this.runner.getContext().enterBlockingSection();
        }
        this.callback("ocamljava java.applet.stop");
    }

    final void destroy() {
        if (this.thread != null) {
            this.thread.stop();
            this.runner.getContext().enterBlockingSection();
        }
        this.callback("ocamljava java.applet.destroy");
    }

    @Override
    public final void run() {
        this.callback("ocamljava java.applet.run");
    }
}

